/* Automatically generated by wasm2c */
#include <assert.h>
#include <math.h>
#include <stdarg.h>
#include <stddef.h>
#include <string.h>
#if defined(__MINGW32__)
#include <malloc.h>
#elif defined(_MSC_VER)
#include <intrin.h>
#include <malloc.h>
#define alloca _alloca
#elif defined(__FreeBSD__) || defined(__OpenBSD__)
#include <stdlib.h>
#else
#include <alloca.h>
#endif

#include "hermes_sandbox_impl_opt_compiled.h"

#define TRAP(x) (wasm_rt_trap(WASM_RT_TRAP_##x), 0)

#if WASM_RT_USE_STACK_DEPTH_COUNT
#define FUNC_PROLOGUE                                            \
  if (++wasm_rt_call_stack_depth > WASM_RT_MAX_CALL_STACK_DEPTH) \
    TRAP(EXHAUSTION);

#define FUNC_EPILOGUE --wasm_rt_call_stack_depth
#else
#define FUNC_PROLOGUE

#define FUNC_EPILOGUE
#endif

#define UNREACHABLE TRAP(UNREACHABLE)

static inline bool func_types_eq(const wasm_rt_func_type_t a,
                                 const wasm_rt_func_type_t b) {
  return (a == b) || LIKELY(a && b && !memcmp(a, b, 32));
}

#define CALL_INDIRECT(table, t, ft, x, ...)              \
  (LIKELY((x) < table.size && table.data[x].func &&      \
          func_types_eq(ft, table.data[x].func_type)) || \
       TRAP(CALL_INDIRECT),                              \
   ((t)table.data[x].func)(__VA_ARGS__))

#ifdef SUPPORT_MEMORY64
#define RANGE_CHECK(mem, offset, len)              \
  do {                                             \
    uint64_t res;                                  \
    if (__builtin_add_overflow(offset, len, &res)) \
      TRAP(OOB);                                   \
    if (UNLIKELY(res > mem->size))                 \
      TRAP(OOB);                                   \
  } while (0);
#else
#define RANGE_CHECK(mem, offset, len)               \
  if (UNLIKELY(offset + (uint64_t)len > mem->size)) \
    TRAP(OOB);
#endif

#if WASM_RT_MEMCHECK_GUARD_PAGES
#define MEMCHECK(mem, a, t)
#else
#define MEMCHECK(mem, a, t) RANGE_CHECK(mem, a, sizeof(t))
#endif

#ifdef __GNUC__
#define wasm_asm __asm__
#else
#define wasm_asm(X)
#endif

#if WABT_BIG_ENDIAN
static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  size_t i = 0;
  u8* dest_chars = dest;
  memcpy(dest, src, n);
  for (i = 0; i < (n >> 1); i++) {
    u8 cursor = dest_chars[i];
    dest_chars[i] = dest_chars[n - i - 1];
    dest_chars[n - i - 1] = cursor;
  }
}
#define LOAD_DATA(m, o, i, s)                   \
  do {                                          \
    RANGE_CHECK((&m), m.size - o - s, s);       \
    load_data(&(m.data[m.size - o - s]), i, s); \
  } while (0)
#define DEFINE_LOAD(name, t1, t2, t3)                                  \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) {             \
    MEMCHECK(mem, addr, t1);                                           \
    t1 result;                                                         \
    wasm_rt_memcpy(&result, &mem->data[mem->size - addr - sizeof(t1)], \
                   sizeof(t1));                                        \
    wasm_asm("" ::"r"(result));                                        \
    return (t3)(t2)result;                                             \
  }

#define DEFINE_STORE(name, t1, t2)                                      \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) {  \
    MEMCHECK(mem, addr, t1);                                            \
    t1 wrapped = (t1)value;                                             \
    wasm_rt_memcpy(&mem->data[mem->size - addr - sizeof(t1)], &wrapped, \
                   sizeof(t1));                                         \
  }
#else
static inline void load_data(void* dest, const void* src, size_t n) {
  if (!n) {
    return;
  }
  memcpy(dest, src, n);
}
#define LOAD_DATA(m, o, i, s)      \
  do {                             \
    RANGE_CHECK((&m), o, s);       \
    load_data(&(m.data[o]), i, s); \
  } while (0)
#define DEFINE_LOAD(name, t1, t2, t3)                      \
  static inline t3 name(wasm_rt_memory_t* mem, u64 addr) { \
    MEMCHECK(mem, addr, t1);                               \
    t1 result;                                             \
    wasm_rt_memcpy(&result, &mem->data[addr], sizeof(t1)); \
    wasm_asm("" ::"r"(result));                            \
    return (t3)(t2)result;                                 \
  }

#define DEFINE_STORE(name, t1, t2)                                     \
  static inline void name(wasm_rt_memory_t* mem, u64 addr, t2 value) { \
    MEMCHECK(mem, addr, t1);                                           \
    t1 wrapped = (t1)value;                                            \
    wasm_rt_memcpy(&mem->data[addr], &wrapped, sizeof(t1));            \
  }
#endif

DEFINE_LOAD(i32_load, u32, u32, u32)
DEFINE_LOAD(i64_load, u64, u64, u64)
DEFINE_LOAD(f32_load, f32, f32, f32)
DEFINE_LOAD(f64_load, f64, f64, f64)
DEFINE_LOAD(i32_load8_s, s8, s32, u32)
DEFINE_LOAD(i64_load8_s, s8, s64, u64)
DEFINE_LOAD(i32_load8_u, u8, u32, u32)
DEFINE_LOAD(i64_load8_u, u8, u64, u64)
DEFINE_LOAD(i32_load16_s, s16, s32, u32)
DEFINE_LOAD(i64_load16_s, s16, s64, u64)
DEFINE_LOAD(i32_load16_u, u16, u32, u32)
DEFINE_LOAD(i64_load16_u, u16, u64, u64)
DEFINE_LOAD(i64_load32_s, s32, s64, u64)
DEFINE_LOAD(i64_load32_u, u32, u64, u64)
DEFINE_STORE(i32_store, u32, u32)
DEFINE_STORE(i64_store, u64, u64)
DEFINE_STORE(f32_store, f32, f32)
DEFINE_STORE(f64_store, f64, f64)
DEFINE_STORE(i32_store8, u8, u32)
DEFINE_STORE(i32_store16, u16, u32)
DEFINE_STORE(i64_store8, u8, u64)
DEFINE_STORE(i64_store16, u16, u64)
DEFINE_STORE(i64_store32, u32, u64)

#if defined(_MSC_VER)

// Adapted from
// https://github.com/nemequ/portable-snippets/blob/master/builtin/builtin.h

static inline int I64_CLZ(unsigned long long v) {
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  if (_BitScanReverse64(&r, v)) {
    return 63 - r;
  }
#else
  if (_BitScanReverse(&r, (unsigned long)(v >> 32))) {
    return 31 - r;
  } else if (_BitScanReverse(&r, (unsigned long)v)) {
    return 63 - r;
  }
#endif
  return 64;
}

static inline int I32_CLZ(unsigned long v) {
  unsigned long r = 0;
  if (_BitScanReverse(&r, v)) {
    return 31 - r;
  }
  return 32;
}

static inline int I64_CTZ(unsigned long long v) {
  if (!v) {
    return 64;
  }
  unsigned long r = 0;
#if defined(_M_AMD64) || defined(_M_ARM)
  _BitScanForward64(&r, v);
  return (int)r;
#else
  if (_BitScanForward(&r, (unsigned int)(v))) {
    return (int)(r);
  }

  _BitScanForward(&r, (unsigned int)(v >> 32));
  return (int)(r + 32);
#endif
}

static inline int I32_CTZ(unsigned long v) {
  if (!v) {
    return 32;
  }
  unsigned long r = 0;
  _BitScanForward(&r, v);
  return (int)r;
}

#define POPCOUNT_DEFINE_PORTABLE(f_n, T)                            \
  static inline u32 f_n(T x) {                                      \
    x = x - ((x >> 1) & (T) ~(T)0 / 3);                             \
    x = (x & (T) ~(T)0 / 15 * 3) + ((x >> 2) & (T) ~(T)0 / 15 * 3); \
    x = (x + (x >> 4)) & (T) ~(T)0 / 255 * 15;                      \
    return (T)(x * ((T) ~(T)0 / 255)) >> (sizeof(T) - 1) * 8;       \
  }

POPCOUNT_DEFINE_PORTABLE(I32_POPCNT, u32)
POPCOUNT_DEFINE_PORTABLE(I64_POPCNT, u64)

#undef POPCOUNT_DEFINE_PORTABLE

#else

#define I32_CLZ(x) ((x) ? __builtin_clz(x) : 32)
#define I64_CLZ(x) ((x) ? __builtin_clzll(x) : 64)
#define I32_CTZ(x) ((x) ? __builtin_ctz(x) : 32)
#define I64_CTZ(x) ((x) ? __builtin_ctzll(x) : 64)
#define I32_POPCNT(x) (__builtin_popcount(x))
#define I64_POPCNT(x) (__builtin_popcountll(x))

#endif

#define DIV_S(ut, min, x, y)                                      \
  ((UNLIKELY((y) == 0))                                           \
       ? TRAP(DIV_BY_ZERO)                                        \
       : (UNLIKELY((x) == min && (y) == -1)) ? TRAP(INT_OVERFLOW) \
                                             : (ut)((x) / (y)))

#define REM_S(ut, min, x, y) \
  ((UNLIKELY((y) == 0))      \
       ? TRAP(DIV_BY_ZERO)   \
       : (UNLIKELY((x) == min && (y) == -1)) ? 0 : (ut)((x) % (y)))

#define I32_DIV_S(x, y) DIV_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_DIV_S(x, y) DIV_S(u64, INT64_MIN, (s64)x, (s64)y)
#define I32_REM_S(x, y) REM_S(u32, INT32_MIN, (s32)x, (s32)y)
#define I64_REM_S(x, y) REM_S(u64, INT64_MIN, (s64)x, (s64)y)

#define DIVREM_U(op, x, y) \
  ((UNLIKELY((y) == 0)) ? TRAP(DIV_BY_ZERO) : ((x)op(y)))

#define DIV_U(x, y) DIVREM_U(/, x, y)
#define REM_U(x, y) DIVREM_U(%, x, y)

#define ROTL(x, y, mask) \
  (((x) << ((y) & (mask))) | ((x) >> (((mask) - (y) + 1) & (mask))))
#define ROTR(x, y, mask) \
  (((x) >> ((y) & (mask))) | ((x) << (((mask) - (y) + 1) & (mask))))

#define I32_ROTL(x, y) ROTL(x, y, 31)
#define I64_ROTL(x, y) ROTL(x, y, 63)
#define I32_ROTR(x, y) ROTR(x, y, 31)
#define I64_ROTR(x, y) ROTR(x, y, 63)

#define FMIN(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? x : y) \
                                                : (x < y) ? x : y)

#define FMAX(x, y)                                                     \
  ((UNLIKELY((x) != (x)))                                              \
       ? NAN                                                           \
       : (UNLIKELY((y) != (y)))                                        \
             ? NAN                                                     \
             : (UNLIKELY((x) == 0 && (y) == 0)) ? (signbit(x) ? y : x) \
                                                : (x > y) ? x : y)

#define TRUNC_S(ut, st, ft, min, minop, max, x)                           \
  ((UNLIKELY((x) != (x)))                                                 \
       ? TRAP(INVALID_CONVERSION)                                         \
       : (UNLIKELY(!((x)minop(min) && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                     : (ut)(st)(x))

#define I32_TRUNC_S_F32(x) \
  TRUNC_S(u32, s32, f32, (f32)INT32_MIN, >=, 2147483648.f, x)
#define I64_TRUNC_S_F32(x) \
  TRUNC_S(u64, s64, f32, (f32)INT64_MIN, >=, (f32)INT64_MAX, x)
#define I32_TRUNC_S_F64(x) \
  TRUNC_S(u32, s32, f64, -2147483649., >, 2147483648., x)
#define I64_TRUNC_S_F64(x) \
  TRUNC_S(u64, s64, f64, (f64)INT64_MIN, >=, (f64)INT64_MAX, x)

#define TRUNC_U(ut, ft, max, x)                                          \
  ((UNLIKELY((x) != (x)))                                                \
       ? TRAP(INVALID_CONVERSION)                                        \
       : (UNLIKELY(!((x) > (ft)-1 && (x) < (max)))) ? TRAP(INT_OVERFLOW) \
                                                    : (ut)(x))

#define I32_TRUNC_U_F32(x) TRUNC_U(u32, f32, 4294967296.f, x)
#define I64_TRUNC_U_F32(x) TRUNC_U(u64, f32, (f32)UINT64_MAX, x)
#define I32_TRUNC_U_F64(x) TRUNC_U(u32, f64, 4294967296., x)
#define I64_TRUNC_U_F64(x) TRUNC_U(u64, f64, (f64)UINT64_MAX, x)

#define TRUNC_SAT_S(ut, st, ft, min, smin, minop, max, smax, x) \
  ((UNLIKELY((x) != (x)))                                       \
       ? 0                                                      \
       : (UNLIKELY(!((x)minop(min))))                           \
             ? smin                                             \
             : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(st)(x))

#define I32_TRUNC_SAT_S_F32(x)                                            \
  TRUNC_SAT_S(u32, s32, f32, (f32)INT32_MIN, INT32_MIN, >=, 2147483648.f, \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F32(x)                                              \
  TRUNC_SAT_S(u64, s64, f32, (f32)INT64_MIN, INT64_MIN, >=, (f32)INT64_MAX, \
              INT64_MAX, x)
#define I32_TRUNC_SAT_S_F64(x)                                        \
  TRUNC_SAT_S(u32, s32, f64, -2147483649., INT32_MIN, >, 2147483648., \
              INT32_MAX, x)
#define I64_TRUNC_SAT_S_F64(x)                                              \
  TRUNC_SAT_S(u64, s64, f64, (f64)INT64_MIN, INT64_MIN, >=, (f64)INT64_MAX, \
              INT64_MAX, x)

#define TRUNC_SAT_U(ut, ft, max, smax, x)               \
  ((UNLIKELY((x) != (x))) ? 0                           \
                          : (UNLIKELY(!((x) > (ft)-1))) \
                                ? 0                     \
                                : (UNLIKELY(!((x) < (max)))) ? smax : (ut)(x))

#define I32_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u32, f32, 4294967296.f, UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F32(x) \
  TRUNC_SAT_U(u64, f32, (f32)UINT64_MAX, UINT64_MAX, x)
#define I32_TRUNC_SAT_U_F64(x) TRUNC_SAT_U(u32, f64, 4294967296., UINT32_MAX, x)
#define I64_TRUNC_SAT_U_F64(x) \
  TRUNC_SAT_U(u64, f64, (f64)UINT64_MAX, UINT64_MAX, x)

#define DEFINE_REINTERPRET(name, t1, t2) \
  static inline t2 name(t1 x) {          \
    t2 result;                           \
    memcpy(&result, &x, sizeof(result)); \
    return result;                       \
  }

DEFINE_REINTERPRET(f32_reinterpret_i32, u32, f32)
DEFINE_REINTERPRET(i32_reinterpret_f32, f32, u32)
DEFINE_REINTERPRET(f64_reinterpret_i64, u64, f64)
DEFINE_REINTERPRET(i64_reinterpret_f64, f64, u64)

static float quiet_nanf(float x) {
  uint32_t tmp;
  memcpy(&tmp, &x, 4);
  tmp |= 0x7fc00000lu;
  memcpy(&x, &tmp, 4);
  return x;
}

static double quiet_nan(double x) {
  uint64_t tmp;
  memcpy(&tmp, &x, 8);
  tmp |= 0x7ff8000000000000llu;
  memcpy(&x, &tmp, 8);
  return x;
}

static double wasm_quiet(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return x;
}

static float wasm_quietf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return x;
}

static double wasm_floor(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return floor(x);
}

static float wasm_floorf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return floorf(x);
}

static double wasm_ceil(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return ceil(x);
}

static float wasm_ceilf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return ceilf(x);
}

static double wasm_trunc(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return trunc(x);
}

static float wasm_truncf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return truncf(x);
}

static float wasm_nearbyintf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return nearbyintf(x);
}

static double wasm_nearbyint(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return nearbyint(x);
}

static float wasm_fabsf(float x) {
  if (UNLIKELY(isnan(x))) {
    uint32_t tmp;
    memcpy(&tmp, &x, 4);
    tmp = tmp & ~(1UL << 31);
    memcpy(&x, &tmp, 4);
    return x;
  }
  return fabsf(x);
}

static double wasm_fabs(double x) {
  if (UNLIKELY(isnan(x))) {
    uint64_t tmp;
    memcpy(&tmp, &x, 8);
    tmp = tmp & ~(1ULL << 63);
    memcpy(&x, &tmp, 8);
    return x;
  }
  return fabs(x);
}

static double wasm_sqrt(double x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nan(x);
  }
  return sqrt(x);
}

static float wasm_sqrtf(float x) {
  if (UNLIKELY(isnan(x))) {
    return quiet_nanf(x);
  }
  return sqrtf(x);
}

static inline void memory_fill(wasm_rt_memory_t* mem, u32 d, u32 val, u32 n) {
  RANGE_CHECK(mem, d, n);
  memset(mem->data + d, val, n);
}

static inline void memory_copy(wasm_rt_memory_t* dest,
                               const wasm_rt_memory_t* src,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  RANGE_CHECK(dest, dest_addr, n);
  RANGE_CHECK(src, src_addr, n);
  memmove(dest->data + dest_addr, src->data + src_addr, n);
}

static inline void memory_init(wasm_rt_memory_t* dest,
                               const u8* src,
                               u32 src_size,
                               u32 dest_addr,
                               u32 src_addr,
                               u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  LOAD_DATA((*dest), dest_addr, src + src_addr, n);
}

typedef struct {
  wasm_rt_func_type_t type;
  wasm_rt_function_ptr_t func;
  size_t module_offset;
} wasm_elem_segment_expr_t;

static inline void funcref_table_init(wasm_rt_funcref_table_t* dest,
                                      const wasm_elem_segment_expr_t* src,
                                      u32 src_size,
                                      u32 dest_addr,
                                      u32 src_addr,
                                      u32 n,
                                      void* module_instance) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    const wasm_elem_segment_expr_t* src_expr = &src[src_addr + i];
    dest->data[dest_addr + i] =
        (wasm_rt_funcref_t){src_expr->type, src_expr->func,
                            (char*)module_instance + src_expr->module_offset};
  }
}

// Currently Wasm only supports initializing externref tables with ref.null.
static inline void externref_table_init(wasm_rt_externref_table_t* dest,
                                        u32 src_size,
                                        u32 dest_addr,
                                        u32 src_addr,
                                        u32 n) {
  if (UNLIKELY(src_addr + (uint64_t)n > src_size))
    TRAP(OOB);
  if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))
    TRAP(OOB);
  for (u32 i = 0; i < n; i++) {
    dest->data[dest_addr + i] = wasm_rt_externref_null_value;
  }
}

#define DEFINE_TABLE_COPY(type)                                              \
  static inline void type##_table_copy(wasm_rt_##type##_table_t* dest,       \
                                       const wasm_rt_##type##_table_t* src,  \
                                       u32 dest_addr, u32 src_addr, u32 n) { \
    if (UNLIKELY(dest_addr + (uint64_t)n > dest->size))                      \
      TRAP(OOB);                                                             \
    if (UNLIKELY(src_addr + (uint64_t)n > src->size))                        \
      TRAP(OOB);                                                             \
                                                                             \
    memmove(dest->data + dest_addr, src->data + src_addr,                    \
            n * sizeof(wasm_rt_##type##_t));                                 \
  }

DEFINE_TABLE_COPY(funcref)
DEFINE_TABLE_COPY(externref)

#define DEFINE_TABLE_GET(type)                        \
  static inline wasm_rt_##type##_t type##_table_get(  \
      const wasm_rt_##type##_table_t* table, u32 i) { \
    if (UNLIKELY(i >= table->size))                   \
      TRAP(OOB);                                      \
    return table->data[i];                            \
  }

DEFINE_TABLE_GET(funcref)
DEFINE_TABLE_GET(externref)

#define DEFINE_TABLE_SET(type)                                               \
  static inline void type##_table_set(const wasm_rt_##type##_table_t* table, \
                                      u32 i, const wasm_rt_##type##_t val) { \
    if (UNLIKELY(i >= table->size))                                          \
      TRAP(OOB);                                                             \
    table->data[i] = val;                                                    \
  }

DEFINE_TABLE_SET(funcref)
DEFINE_TABLE_SET(externref)

#define DEFINE_TABLE_FILL(type)                                               \
  static inline void type##_table_fill(const wasm_rt_##type##_table_t* table, \
                                       u32 d, const wasm_rt_##type##_t val,   \
                                       u32 n) {                               \
    if (UNLIKELY((uint64_t)d + n > table->size))                              \
      TRAP(OOB);                                                              \
    for (uint32_t i = d; i < d + n; i++) {                                    \
      table->data[i] = val;                                                   \
    }                                                                         \
  }

DEFINE_TABLE_FILL(funcref)
DEFINE_TABLE_FILL(externref)

#if defined(__GNUC__) || defined(__clang__)
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char* const x
#define FUNC_TYPE_EXTERN_T(x) const char* const x
#define FUNC_TYPE_T(x) static const char* const x
#else
#define FUNC_TYPE_DECL_EXTERN_T(x) extern const char x[]
#define FUNC_TYPE_EXTERN_T(x) const char x[]
#define FUNC_TYPE_T(x) static const char x[]
#endif

FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t0);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t1);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t2);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t3);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t4);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t5);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t6);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t7);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t8);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t9);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t10);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t11);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t12);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t13);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t14);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t15);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t16);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t17);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t18);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t19);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t20);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t21);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t22);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t23);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t24);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t25);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t26);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t27);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t28);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t29);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t30);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t31);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t32);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t33);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t34);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t35);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t36);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t37);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t38);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t39);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t40);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t41);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t42);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t43);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t44);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t45);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t46);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t47);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t48);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t49);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t50);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t51);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t52);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t53);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t54);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t55);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t56);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t57);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t58);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t59);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t60);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t61);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t62);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t63);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t64);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t65);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t66);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t67);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t68);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t69);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t70);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t71);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t72);
FUNC_TYPE_DECL_EXTERN_T(w2c_hermes_t73);

void w2c_hermes_dlfree(w2c_hermes*, u32);
u32 w2c_hermes_operator0x20new0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCScope0x3A0x3A_newChunkAndPHV0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_memmove(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorBase0x3A0x3Agrow_pod0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseTypeError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineMethod0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20char0x2C0x20char0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20char0x2C0x20char0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20char0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20char0x2C0x20char0x20const0x2A0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cunsigned0x20char0x2C0x20char0x20const0x2A0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_memcpy(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3AallocateNewSlab0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_memcmp(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AStringTable0x3A0x3AgetString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Aadvance0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_memset(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCScope0x3A0x3A0x7EGCScope0x280x29(w2c_hermes*, u32);
void w2c_hermes_abort(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AallocSlow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3ApushOperand0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetNamedWithReceiver_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyCacheEntry0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseRangeError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetRegister0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringPrim0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoString_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AVariable0x3A0x3AgetIndexInVariableList0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBasicBlock0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_operator0x20delete0x5B0x5D0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahermes_fatal0x28char0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Av150070x5D0x28char0x20const0x2A0x29(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdefineOwnPropertyInternal0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoNumber_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3A0x7EInstruction0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3Abuild0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3ABuilder0x28void0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AwriteBarrierSlow0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AerrorExpected0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3Aparser0x3A0x3ATokenKind0x3E0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoObject0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpression0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_fmod(w2c_hermes*, f64, f64);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_weak_count0x3A0x3A_0x5Frelease_weak0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitKey0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedWithReceiver_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBranchInst0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_strlen(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateStringView0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineProperty0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AESTreeVisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AwriteBarrierSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_dlmalloc(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoIntegerOrInfinity0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoBoolean0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObjectBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseStackOverflow0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AStackOverflowKind0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArray0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoPrimitive_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APreferredType0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20int0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AIdentifier0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20int0x3E0x2A0x2C0x20hermes0x3A0x3AIdentifier0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeFunction0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fshim_type_info0x3A0x3Anoop10x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineAccessor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x3E0x3A0x3ALookupBucketFor0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AputNamedWithReceiver_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u64 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achrono0x3A0x3Asteady_clock0x3A0x3Anow0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3Areport_bad_alloc_error0x28char0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AisNativeStackOverflowingSlowPath0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AencodeUTF80x28char0x2A0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AOldGen0x3A0x3Aalloc0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_snprintf(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmoveObject0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AeraseFromParent0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AappendUTF16String0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ArelocationWriteBarrier0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Awrite0x28unsigned0x20char0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitReg320x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitAddr320x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitUInt160x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreStackInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apush_back0x28char0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x3A0x3AcopyFrom0x28llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineMethod0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdefineNewOwnProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadStackInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoIndex0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AputComputedWithReceiver_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AtruncateToInt32SlowPath0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCondBranchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AgetTerminator0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aequals0x3Cunsigned0x20char0x3E0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoLengthU640x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineProperty0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3AcreateBuffer0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u64);
void w2c_hermes_hermes0x3A0x3APassManager0x3A0x3AaddPass0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3APass0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3APass0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3Atype_info0x3A0x3A0x7Etype_info0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedPrimitiveDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoLength0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendStringPrim0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringView0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AwriteBarrierSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u64);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralNumber0x28double0x29(w2c_hermes*, u32, f64);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Finit_copy_ctor_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3A0x7Eraw_ostream0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedPropertyValue_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AcreateNotUniquedLazySymbol0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3Abacktrack0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ABacktrackInsn0x2C0x2064u0x3E0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x3A0x3Abacktrack0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x3A0x3ABacktrackInsn0x2C0x2064u0x3E0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AValue0x3A0x3AreplaceAllUsesWith0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3ASetBufferAndMode0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3Araw_ostream0x3A0x3ABufferKind0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AraisePlaceholder0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3AgetUTF16Ref0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendUTF16Ref0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AfindProperty0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Apush0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall30x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u64, u64, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall10x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u64);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_balance_after_insert0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node_base0x3Cvoid0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_external0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineSystemConstructor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x200x280x2A0x290x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x290x2C0x20hermes0x3A0x3Avm0x3A0x3ACellKind0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3AvalidateTypedArray0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AraiseOnError0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Abigint0x3A0x3AOperationStatus0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitStore0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AappendSignedLEB1280x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocStackInst0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Chermes0x3A0x3AValue0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Chermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x2B0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseSyntaxError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar0x2C0x20false0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3AgenAnonymousLabelName0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3Acompare0x28hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_out(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_lshift(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3ASmallPtrSetImplBase0x28void0x20const0x2A0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ASmallPtrSetImplBase0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineSystemConstructor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x200x280x2A0x290x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x290x2C0x20hermes0x3A0x3Avm0x3A0x3ACellKind0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aslice0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateDynamic0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdeleteComputed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdefineOwnComputedPrimitive0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x20hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmakeHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetInstructionNumber0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AsetOperand0x28hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_pad(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_multadd(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetNamedDescriptorUnsafe0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x20hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmakeHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x28hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall00x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcreateLRef0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetDerivedSideEffect0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateBinaryOperatorInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AvalueToSymbolID0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcreateIterResultObject0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseTypeErrorForValue0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AunregisterMemory0x28void0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall20x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u64, u64);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenStatement0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AIsLoopBody0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInternalIdentifierMaker0x3A0x3Anext0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AarrayToString0x3Cchar16_t0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcCompare0x28unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AfindTrap0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AfromBytes0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ArecursionDepthExceeded0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Avm0x3A0x3AscanInt0x3Chermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x3E0x28hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20int0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AIdentifier0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AGlobalObjectProperty0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AIdentifier0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ABitVector0x3A0x3Aresize0x28unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoPropertyKey0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AiteratorStep0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AIteratorRecord0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AweakRefReadBarrier0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AcreditExternalMemory0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedHeapSegment0x3A0x3A0x7EAlignedHeapSegment0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Acanonicalize0x28unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AValue0x3A0x3Adestroy0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AgetEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStorePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCallInst0x28hermes0x3A0x3ALiteralString0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3ABasicBlock0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteConstruct10x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3AAlignedStorage0x28hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenBuiltinCall0x28hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcloneNodeInternal0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Acopy0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AarrayToString0x3Cchar0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Aoperator0x2B0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoArrayIndex0x28hermes0x3A0x3Avm0x3A0x3AStringView0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AiteratorCloseAndRethrow0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AinitializeMissingPropertyMap0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADynamicStringPrimitive0x3Cchar16_t0x2C0x20false0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3AsetStorageEndIndex0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayImpl0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AreadSignedLEB1280x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x2C0x20long0x20long0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3Acompare0x28hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3Amessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20hermes0x3A0x3AWarning0x2C0x20hermes0x3A0x3ASubsystem0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCallBuiltinInst0x28hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3AValue0x2A0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_HermesABIManagedPointer0x2A0x200x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AcreatePointerImpl0x3CHermesABIObject0x3E0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_front0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x3E0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AValue0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AValue0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x3E0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x3A0x3Ainsert0x28char0x2A0x2C0x20char0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcreateASCIIRef0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AisExtensible0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetOwnPropertyKeys0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AOwnKeysFlags0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandle0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierInternal0x28hermes0x3A0x3Avm0x3A0x3ACompressedPointer0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AallocLongLived0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AdecodeUTF80x280x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3A0x3Aoperator0x280x290x28llvh0x3A0x3ATwine0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AnumberToString0x28double0x2C0x20char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, f64, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF16ToUTF8WithReplacements0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AUTF16Stream0x3A0x3Arefill0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AisIdenticalTo0x28hermes0x3A0x3AInstruction0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateVariable0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateReturnInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_pthread_mutex_lock(w2c_hermes*, u32);
u32 w2c_hermes_zi_read32(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cunsigned0x20char0x20const0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20char0x20const0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Ainsert0x3Cunsigned0x20char0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x20const0x2A0x3E0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3A0x7Eraw_string_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Aformat_object_base0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Ahash_value0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3Astr0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcNegate0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AutcTime0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoUInt32_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AspeciesConstructor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlocalTime0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetInstrumentedStats0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28llvh0x3A0x3AStringRef0x2C0x20double0x290x20const(w2c_hermes*, u32, u32, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetMethod0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCharacterString0x28char16_t0x29(w2c_hermes*, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgcStableHashHermesValue0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3AerrorWithChar0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x2C0x20char16_t0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2A0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x3E0x3A0x3Ainsert0x3Chermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2A0x2C0x20void0x3E0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AemitStore0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AgetStringID0x28hermes0x3A0x3ALiteralString0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AcheckedMalloc0x28unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28double0x29(w2c_hermes*, u32, f64);
u32 w2c_hermes_hermes0x3A0x3AInstructionNamer0x3A0x3AgetNumber0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cunsigned0x20char0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fthrow_out_of_range0x5Babi0x3Av150070x5D0x280x290x20const(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AtoVector0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3Ainsert_imp_big0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_is_equal0x28std0x3A0x3Atype_info0x20const0x2A0x2C0x20std0x3A0x3Atype_info0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoInt32_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringToBigInt0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstrictEqualityTest0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u64, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdoBigIntBinOp0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x200x280x2A0x290x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x290x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AconstructErrorObject0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AputNamedThrowOnError0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropCacheID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHermesValue320x3A0x3AunboxToHV0x28hermes0x3A0x3Avm0x3A0x3APointerBase0x260x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AdefineLazyProperties0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeOnlyLetter0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AupdateRegister0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ARegister0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralString0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryEndInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ANode0x3A0x3Aoperator0x20new0x28unsigned0x20long0x2C0x20hermes0x3A0x3AContext0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_abort_message(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AcreateValue0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u64);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcond_swap0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_strcmp(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_pow5mult(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ATwine0x3A0x3AprintOneChild0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3ATwine0x3A0x3AChild0x2C0x20llvh0x3A0x3ATwine0x3A0x3ANodeKind0x290x20const(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AyearFromTime0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisSameValue0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisSameValueZero0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u64, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetIterator0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20llvh0x3A0x3AOptional0x3Chermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3AgetCodeBlockSlowPath0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseURIError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetPrototypeOf0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetOwnComputedPrimitiveDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AIgnoreProxy0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetOwnComputedDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdefineOwnComputed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingIdentifier0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringObject0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringArray0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ATerminatorInst0x3A0x3AgetNumSuccessors0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AwillEmitValue0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCatchInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x3E0x28hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ACollectionStats0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ACollectionStats0x3E0x3E0x3A0x3Areset0x5Babi0x3Av150070x5D0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ACollectionStats0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Arandom_device0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cbool0x200x280x290x3E0x3A0x3Aswap0x5Babi0x3Av150070x5D0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fvalue_func0x3Cbool0x200x280x290x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aouts0x280x29(w2c_hermes*);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ALiteral0x2A0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ALiteral0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AAlreadyEmitted0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmonthFromTime0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcompareBigIntAndNumber0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20double0x2C0x20bool0x200x280x2A0x290x28int0x290x29(w2c_hermes*, u32, u32, u32, f64, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AsymbolEqualsToStringPrim0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AregisterMemory0x28void0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddArray0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x3A0x3AArrayType0x2C0x20void0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3Aimpl0x3A0x3AFakeAtomic0x3Cunsigned0x20int0x3E0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetOwnComputedDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHermesValue320x3A0x3AencodeHermesValue0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierRangeSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AdebitExternalMemory0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AIDTracker0x3A0x3AuntrackNative0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvalidateDeclarationNames0x28hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionHelper0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AappendUnicodeToStorage0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpressionBranch0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeModule0x3A0x3A0x7EBytecodeModule0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ATerminatorInst0x3A0x3AgetSuccessor0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x3A0x3Apop0x28hermes0x3A0x3AIdentifier0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AopenDict0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AcloseDict0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryStartInst0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThrowInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreOwnPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_dlrealloc(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_swapc(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Arandom_device0x3A0x3Arandom_device0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adeque0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fadd_back_capacity0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Areserve0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend20x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fallocation_result0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Apointer0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fallocate_at_least0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x260x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_quorem(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ASmallPtrSetImplBase0x3A0x3AFindBucketFor0x28void0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASHA10x3A0x3AhashBlock0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoNumeric_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpExec0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisArray0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetTypeName0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aequals0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3APropertyAccessor0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3A0x3AregisterCallback0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28int0x290x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3AsetToCopyOfTypedArray0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AgetOwnProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AsetParent0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AreserveSlot0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AaddProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x20hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmakeHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x28hermes0x3A0x3Avm0x3A0x3ACallable0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierRangeSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AupdateBoundaries0x28hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3ABoundary0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AdefineNameLengthAndPrototype0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AWritablePrototype0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AresizeWithinCapacity0x28hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFunctionBody0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20bool0x2C0x20bool0x2C0x20bool0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3A0x7EFunctionContext0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x3A0x3AFunctionContext0x28hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitTopLevelDeclarations0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3ADoEmitParameters0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitFunctionPreamble0x28hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AfindBufferLineAndLoc0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceCoords0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AisAllocated0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3APostOrderAnalysis0x3A0x3APostOrderAnalysis0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AgetLiteralNumber0x28double0x29(w2c_hermes*, u32, f64);
void w2c_hermes_hermes0x3A0x3AManagedChunkedList0x3C0x28anonymous0x20namespace0x290x3A0x3AManagedValue0x3Chermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x3E0x2C0x2016ul0x3E0x3A0x3Acollect0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AmoveBefore0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIdentifier0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateFunctionInst0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fstable_sort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x2C0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Ctrue0x2C0x20char16_t0x2A0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cchar16_t0x2A0x3E0x28char16_t0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20char16_t0x2A0x20hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF160x3Cchar16_t0x2A0x3E0x28char16_t0x2A0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x290x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3Cis_hashable_data0x3Cunsigned0x20int0x20const0x3E0x3A0x3Avalue0x2C0x20llvh0x3A0x3Ahash_code0x3E0x3A0x3Atype0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_range_impl0x3Cunsigned0x20int0x20const0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2A0x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunction0x3E0x3A0x3Aoperator0x280x290x5Babi0x3Av150070x5D0x28hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunction0x2A0x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsplit_buffer0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x3E0x3E0x3A0x3Apush_back0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fnext_prime0x28unsigned0x20long0x29(w2c_hermes*, u32);
u32 w2c_hermes_sbrk(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3ASetBuffered0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetIteratorImpl0x3A0x3AFoldingSetIteratorImpl0x28void0x2A0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x3A0x3AisEqual0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoArrayIndex0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmakeTime0x28double0x2C0x20double0x2C0x20double0x2C0x20double0x29(w2c_hermes*, f64, f64, f64, f64);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmakeDay0x28double0x2C0x20double0x2C0x20double0x29(w2c_hermes*, f64, f64, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3AtoTwine0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3AgetStringPrimFromStringIDMayAllocate0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3AcreateSymbolFromStringIDMayAllocate0x28unsigned0x20int0x2C0x20hermes0x3A0x3AStringTableEntry0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AhasComputed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3Aadvance0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetStringViewForDev0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierInternal0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierInternal0x28hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ACollectionStats0x3A0x3AaddCollectionType0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADomain0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AlookupEntryFor0x28hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AfindNextCardWithStatus0x28hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3ACardStatus0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Apush_back0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3A0x7EAlignedStorage0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AmakeVarDeclarator0x28hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3A0x3AcharacterHasType0x28unsigned0x20int0x2C0x20hermes0x3A0x3Aregex0x3A0x3ACharacterClass0x3A0x3AType0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeHexDigits0x28unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x2C0x20llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x3E0x28llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x260x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AvalidateBindingIdentifier0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3ATokenKind0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePropertyName0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Alookahead10x28hermes0x3A0x3AOptValue0x3Chermes0x3A0x3Aparser0x3A0x3ATokenKind0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconvertSurrogatesInString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Athread_cpu_time0x280x29(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeIDContinue0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AinitCaptureStateInES5Function0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenMemberExpressionProperty0x28hermes0x3A0x3AESTree0x3A0x3AMemberExpressionLikeNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFinallyBeforeControlChange0x28hermes0x3A0x3Airgen0x3A0x3ASurroundingTry0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3ASurroundingTry0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitLoad0x28hermes0x3A0x3AValue0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeModuleGenerator0x3A0x3AgetStringID0x28llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3A0x7EBCProviderFromBuffer0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Abigint0x3A0x3AdropExtraSignBits0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASimpleDiagHandler0x3A0x3AgetErrorString0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AgetHashCode0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStorePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadFrameInst0x28hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AFunction0x28hermes0x3A0x3AValueKind0x2C0x20hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20bool0x2C0x20llvh0x3A0x3ASMRange0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_getint0x2E1(w2c_hermes*, u32);
u32 w2c_hermes_fmt_u(w2c_hermes*, u64, u32);
f64 w2c_hermes_expm1(w2c_hermes*, f64);
u32 w2c_hermes_dlcalloc(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Chermes0x3A0x3ARegister0x3E0x28hermes0x3A0x3ARegister0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aequals0x3Cchar0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3A_decodeUTF8SlowPath0x3Cfalse0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_peekUTF80x28char0x20const0x2A0x290x20const0x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x3E0x28char0x20const0x2A0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3A_peekUTF80x28char0x20const0x2A0x290x20const0x3A0x3A0x27lambda0x270x28llvh0x3A0x3ATwine0x20const0x260x290x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3A_0x5Fappend0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Ato_string0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Amove0x28char0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Ctrue0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fassign_no_alias0x3Cfalse0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cunsigned0x20int0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3A0x7EDroppingAcceptor0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3A0x7EDroppingAcceptor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_mult(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_log(w2c_hermes*, f64);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3AFormattedNumber0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3A0x7Eraw_fd_ostream0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Aerrs0x280x29(w2c_hermes*);
u32 w2c_hermes_llvh0x3A0x3AStringRef0x3A0x3Afind_first_of0x28llvh0x3A0x3AStringRef0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x3A0x3Aswap0x28llvh0x3A0x3ASmallDenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Cllvh0x3A0x3AStringRef0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x28hermes0x3A0x3AFunction0x2A0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AAddPointer0x28void0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AAlwaysDescend0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ABumpPtrAllocatorImpl0x3Cllvh0x3A0x3AMallocAllocator0x2C0x204096ul0x2C0x204096ul0x3E0x3A0x3AAllocate0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_hermes_g_strtod(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoBigInt_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringToNumber0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ArunRequireCall0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ARequireContext0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ADomain0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessEqualOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisRegExp0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisConstructor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisConstructor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ACallable0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgreaterOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgreaterEqualOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AabstractEqualityTest_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Acompare0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AincreaseSize0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetNamed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropCacheID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3Ainsert0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSRegExp0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AgetComputed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3ArecordStackTrace0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSError0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20bool0x2C0x20hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x2C0x20hermes0x3A0x3Ainst0x3A0x3AInst0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArray0x3A0x3AcreateNoAllocPropStorage0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandle0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetSymbolHandleFromPrimitive0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AConservativeVector0x3Chermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3ALookupEntry0x3E0x3A0x3Aemplace_back0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AallocWeakSlot0x28hermes0x3A0x3Avm0x3A0x3ACompressedPointer0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AlazyCompileImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AthrowExcessiveCapacityError0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvalidateAssignmentTarget0x28hermes0x3A0x3AESTree0x3A0x3ANode0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3ABlockContext0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2A0x2C0x20hermes0x3A0x3Asem0x3A0x3AFunctionContext0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseUnaryExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBlock0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingElement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisAllASCII0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AnewDeclarativeEnvironment0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenOptionalMemberExpression0x28hermes0x3A0x3AESTree0x3A0x3AOptionalMemberExpressionNode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AMemberExpressionOperation0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAnonymousFunctionNameIfNeeded0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AaddString0x28llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfo0x3A0x3AgetLocationForAddress0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AupdateEntry0x28unsigned0x20int0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AOptValue0x3Cchar0x3E0x20hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABigIntLiteralParsingToolBox0x3Chermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStringIntegerLiteralParser0x3Cllvh0x3A0x3AArrayRef0x3Cchar0x3E0x3E0x3E0x3A0x3AlookaheadAndEatIfAnyOf0x3C0x28char0x29480x2C0x200x28char0x29490x2C0x200x28char0x29500x2C0x200x28char0x29510x2C0x200x28char0x29520x2C0x200x28char0x29530x2C0x200x28char0x29540x2C0x200x28char0x29550x2C0x200x28char0x29560x2C0x200x28char0x29570x2C0x200x28char0x29650x2C0x200x28char0x29660x2C0x200x28char0x29670x2C0x200x28char0x29680x2C0x200x28char0x29690x2C0x200x28char0x29700x2C0x200x28char0x29970x2C0x200x28char0x29980x2C0x200x28char0x29990x2C0x200x28char0x291000x2C0x200x28char0x291010x2C0x200x28char0x291020x3E0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AInstruction0x3A0x3AremoveOperand0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRVisitor0x3Chermes0x3A0x3AIRPrinter0x2C0x20void0x3E0x3A0x3Avisit0x28hermes0x3A0x3AValue0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionName0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AIRPrinter0x3A0x3APrintFunctionParams0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralString0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreFrameInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AScopeCreationInst0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateSaveAndYieldInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreatePhiInst0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x208u0x3E0x20const0x260x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x208u0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateLoadPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCreateScopeInst0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetBlockStatement0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_g_freedtoa(w2c_hermes*, u32, u32);
void w2c_hermes_dalloc_done(w2c_hermes*, u32);
void w2c_hermes_char16_t0x2A0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x3A0x3Ainsert0x3Chermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20void0x3E0x28char16_t0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3ALookupBucketFor0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_0x5F_sin(w2c_hermes*, f64, f64, u32);
u64 w2c_hermes_0x5F_lseek(w2c_hermes*, u32, u64, u32);
f64 w2c_hermes_0x5F_cos(w2c_hermes*, f64, f64);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aclone_propnameid0x28HermesABIRuntime0x2A0x2C0x20HermesABIPropNameID0x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_R(w2c_hermes*, f64);
u32 w2c_hermes_write(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fpartially_sorted_swap0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AlookupString0x3Cchar0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AlookupString0x3Cchar16_t0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsearch_random_access_impl0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fequal_to0x3Cchar16_t0x2C0x20char16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x2C0x20long0x2C0x20long0x3E0x28hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fequal_to0x3Cchar16_t0x2C0x20char16_t0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x2C0x20long0x2C0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fuse_branchless_sort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort3_maybe_branchless0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Aappend0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x3E0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20long0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fset_size0x5Babi0x3Av150070x5D0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3A_0x5Fnull_terminate_at0x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28hermes0x3A0x3Aregex0x3A0x3ANode0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
f64 w2c_hermes_scalbn(w2c_hermes*, f64, u32);
u32 w2c_hermes_memchr(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_log1p(w2c_hermes*, f64);
void w2c_hermes_llvh0x3A0x3Awrite_hex0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20llvh0x3A0x3AHexPrintStyle0x2C0x20llvh0x3A0x3AOptional0x3Cunsigned0x20long0x3E0x29(w2c_hermes*, u32, u64, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Abegin0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aappend0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3A0x7Eraw_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aindent0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u64 w2c_hermes_llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_short0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3ABasicBlock0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ADomTreeNodeBase0x3Chermes0x3A0x3ABasicBlock0x3E0x3E0x3E0x3E0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallSet0x3Cdouble0x2C0x204u0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cdouble0x3E0x3E0x3A0x3Ainsert0x28double0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AAddInteger0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AInfoRec0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Aoperator0x2B0x2B0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AflipAllBitsSlowCase0x280x29(w2c_hermes*, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtimeWithinDay0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringDirectedIndexOf0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsecFromTime0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AquickSort0x28hermes0x3A0x3Avm0x3A0x3ASortModel0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseESDate0x28hermes0x3A0x3Avm0x3A0x3AStringView0x290x3A0x3A0x24_40x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmsFromTime0x28double0x29(w2c_hermes*, f64);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AminFromTime0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisPrefix0x28hermes0x3A0x3Avm0x3A0x3AStringView0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhourFromTime0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AenumerableOwnProperties_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AEnumerableOwnPropertiesKind0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3Aslots0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x29(w2c_hermes*, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateFromTime0x28double0x29(w2c_hermes*, f64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AconvertCase0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AadvanceStringIndex0x28hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20bool0x29(w2c_hermes*, u32, u64, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AfilterKeys0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AOwnKeysFlags0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ARuntimeJSONParser0x3A0x3AparseValue0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ATwineChar160x3A0x3AtoVector0x28llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x290x20const0x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x3A0x3ANode0x2C0x20hermes0x3A0x3Avm0x3A0x3ATwineChar160x3A0x3ANodeKind0x2C0x20unsigned0x20long0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aoperator0x5B0x5D0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aequals0x28hermes0x3A0x3Avm0x3A0x3AStringView0x20const0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateStringViewMustBeFlat0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AappendCharacter0x28char16_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3Apush_back0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3A0x7ERuntime0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseTypeErrorForValue0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinterpretFunction0x28hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3AsetBuffer0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AtryGetOwnNamedDescriptorFast0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AdeleteNamed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AaddOwnProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSFunction0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ADomain0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AEnvironment0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3AsetupStack0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3AcreateDataBlock0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3E0x2C0x20unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArray0x3A0x3AsetLength0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AcopyToNewDictionary0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmakeHandle0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x20hermes0x3A0x3Avm0x3A0x3AHandleRootOwner0x3A0x3AmakeHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AaddSegmentExtentToCrashManager0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3Aoom0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2910x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x28unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x2C0x20false0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2910x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x28unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3AfindOrAdd0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AgetNameMayAllocate0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AgetDebugSourceLocationsOffset0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall40x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u64, u64, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3Aat0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3AensureScopedNamesAreUnique0x28hermes0x3A0x3Asem0x3A0x3ABlockContext0x3A0x3AIsFunctionBody0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseAssignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseVariableDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingRestElement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3A0x7EJSParser0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3Aerror0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeUnicodeEscape0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AemitLoad0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3A0x3AEnterBlockScope0x28hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenGeneratorFunction0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenES5Function0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitDestructuringArray0x28bool0x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AblockDeclarationInstantiation0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AStringLiteralTable0x3A0x3AgetStringID0x28llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AStringLiteralIDMapping0x3A0x3A0x7EStringLiteralIDMapping0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfo0x3A0x3AgetFilenameByID0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitRet0x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AupdateJumpTarget0x28unsigned0x20int0x2C0x20int0x2C0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AAllocationTable0x3Chermes0x3A0x3AFunction0x2A0x3E0x3A0x3Aallocate0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AStringSetVector0x3A0x3Ainsert0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AOptValue0x3Cdouble0x3E0x20hermes0x3A0x3AparseIntWithRadix0x3Cfalse0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3E0x28hermes0x3A0x3Avm0x3A0x3AStringView0x2C0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AManagedChunkedList0x3C0x28anonymous0x20namespace0x290x3A0x3AManagedValue0x3Chermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x3E0x2C0x2016ul0x3E0x3A0x3AallocateChunk0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ALoopAnalysis0x3A0x3AgetLoopHeader0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintScopeRange0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreNewOwnPropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateMovInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorCloseInst0x28hermes0x3A0x3AAllocStackInst0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20bool0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateCompareBranchInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABinaryOperatorInst0x3A0x3AOpKind0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AFunction0x3A0x3A0x7EFunction0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetParams0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3Avisit0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x3A0x3AFunctionExpressionNode0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ADominanceInfo0x3A0x3ADominanceInfo0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ACompactArray0x3A0x3AscaleUp0x280x29(w2c_hermes*, u32);
f64 w2c_hermes_frexp(w2c_hermes*, f64, u32);
u32 w2c_hermes_findIdenticalInWindow0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_dtoa_alloc_init(w2c_hermes*, u32);
void w2c_hermes_dispose_chunk(w2c_hermes*, u32, u32);
u32 w2c_hermes_d2b(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_close_file(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_localtime_r(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x5F_clock_gettime(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AraiseError0x28HermesABIErrorCode0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20write_unsigned0x3Cunsigned0x20long0x20long0x3E0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x2C0x20bool0x29(w2c_hermes*, u32, u64, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_up0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_00x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x3E0x28hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Chermes0x3A0x3AExceptionHandlerInfo0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fintrosort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finplace_merge0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x2C0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fdo_rehash0x3Ctrue0x3E0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASmallString0x3C32u0x3E0x3A0x3Aappend0x3Cchar0x2A0x3E0x28char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AscanDirtyCardsForSegment0x3Ctrue0x3E0x28hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3ABaseVisitor0x3A0x3AvisitArray0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x2C0x20false0x3E0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x260x2C0x20char0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AManagedChunkedList0x3Chermes0x3A0x3Avm0x3A0x3AWeakRefSlot0x2C0x2016ul0x3E0x3A0x3AforEach0x3Chermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AWeakRefSlot0x260x290x3E0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AWeakRefSlot0x260x290x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AManagedChunkedList0x3Chermes0x3A0x3Avm0x3A0x3AWeakMapEntrySlot0x2C0x2016ul0x3E0x3A0x3AforEach0x3Chermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AWeakMapEntrySlot0x260x290x3E0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AWeakMapEntrySlot0x260x290x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_wrap_policy0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_wrap_policy0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_wrap_policy0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_wrap_policy0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort50x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x3E0x28hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort40x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Athread0x3A0x3A0x7Ethread0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x3A0x3Aassign0x28char0x2A0x2C0x20unsigned0x20long0x2C0x20char0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Abasic_string0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3Anullptr_t0x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20hermes0x3A0x3ACompiledRegExp0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cchar0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fmap_value_compare0x3Cchar0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cchar0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cchar0x20const0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cchar0x20const0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvalue_type0x3Cchar0x20const0x2A0x2C0x20unsigned0x20int0x3E0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree0x3Cdouble0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cdouble0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cdouble0x3E0x3E0x3A0x3Adestroy0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ftree_node0x3Cdouble0x2C0x20void0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend80x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend60x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fitoa0x3A0x3A_0x5Fappend40x5Babi0x3Av150070x5D0x28char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
void w2c_hermes_sigdelset(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Awrite_integer0x28llvh0x3A0x3Araw_ostream0x260x2C0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aconst_iterator0x3A0x3Aoperator0x2B0x2B0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine0x28unsigned0x20long0x2C0x20char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cint0x2C0x20int0x2C0x20int0x2C0x20int0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20long0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x260x260x2C0x20unsigned0x20long0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3AVarDecl0x2C0x204u0x3E0x3E0x3E0x3E0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x3E0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3ABasicBlock0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMap0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenObjectExpr0x28hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x2A0x290x3A0x3APropertyValue0x2C0x20llvh0x3A0x3AMallocAllocator0x3E0x3A0x3Aoperator0x5B0x5D0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3A0x7ESrcBuffer0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3ASrcBuffer0x28llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintMessage0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASourceMgr0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ATwine0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMRange0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cllvh0x3A0x3ASMFixIt0x3E0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AFindLine0x28llvh0x3A0x3ASMLoc0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cchar16_t0x2C0x20true0x3E0x3A0x3Apush_back0x28char16_t0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallString0x3C32u0x3E0x3A0x3Aappend0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetIteratorImpl0x3A0x3Aadvance0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3A0x7EFoldingSetBase0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AInsertNode0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AFoldingSetBase0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AFindNodeOrInsertPos0x28llvh0x3A0x3AFoldingSetNodeID0x20const0x260x2C0x20void0x2A0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3AproperlyDominates0x28hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ASwitchImmInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x3E0x2C0x20hermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ASwitchImmInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x3E0x2C0x20hermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AConvertUTF8toUTF160x28unsigned0x20char0x20const0x2A0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20short0x2A0x2A0x2C0x20unsigned0x20short0x2A0x2C0x20llvh0x3A0x3AConversionFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcComplement0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3Anegate0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20llvh0x3A0x3AStringRef0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoPropertyDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AthisBigIntValue0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolDescriptiveString0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpInitialize0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpCreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetSubstitution0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetOwnPropertyKeysAsStrings0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AOwnKeysFlags0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetOwnPropertyDescriptor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AflattenIntoArray0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x20long0x2C0x20double0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u64, u64, f64, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdirectEval0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3AScopeChain0x20const0x260x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3Ainsert0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatetimeToLocaleString0x28double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x29(w2c_hermes*, f64, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcurTime0x280x29(w2c_hermes*);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcreateDynamicFunction0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20hermes0x3A0x3Avm0x3A0x3ADynamicFunctionKind0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AamendPropAccessErrorMsgWithPropName0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AproxyOpFlags0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x2C0x20char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACallResult0x3Cbool0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2910x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AdoQuickSort0x28hermes0x3A0x3Avm0x3A0x3ASortModel0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x260x2C0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ARuntimeJSONParser0x3A0x3Afilter0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AJSONStringifyer0x3A0x3AoperationStr0x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3AcastToChar16Ptr0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AsliceEquals0x28unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringBuilder0x3A0x3AcreateStringBuilder0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3ASafeUInt320x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASmallXString0x3Cchar16_t0x2C0x2032u0x3E0x3A0x3Aappend0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Avisit0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ASlotOffsets0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3AvisitFields0x28char0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ASlotOffsets0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASerializedLiteralParser0x3A0x3Aget0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Aresize0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AdecreaseSize0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3AimportStringIDMapMayAllocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ArunBytecode0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeModuleFlags0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AEnvironment0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseReferenceError0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AforEachPublicNativeBuiltin0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Chermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AallocStack0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARequireContext0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ADomain0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3AiteratorNext0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHashMapEntry0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3Ahas0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeState0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20void0x2A0x2C0x20void0x200x280x2A0x290x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeState0x2A0x290x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeFunctionBuildMeta0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeFunction0x3A0x3A_nativeCall0x28hermes0x3A0x3Avm0x3A0x3ANativeFunction0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSRegExp0x3A0x3Asearch0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSRegExp0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3ApreventExtensions0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AownPropertyKeys0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AOwnKeysFlags0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20long0x20long0x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x290x20const(w2c_hermes*, u32, u32, u64, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AdefineOwnProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3ApreventExtensions0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetNamedSlotValue0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x29(w2c_hermes*, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedSlotValueUnsafe0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedPropertyValueInternal_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AaddOwnPropertyImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3AscanWord0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AJSONTokenKind0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSNumber0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20double0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, f64, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSMapIteratorImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29500x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3AtoString0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3AsetMessage0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSError0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3AgetDebugInfo0x28hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSBoolean0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20bool0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3Adetach0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArray0x3A0x3AsetLength0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArray0x3A0x3AcreateClass0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInt8ArrayConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInt32ArrayConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AregisterLazyIdentifier0x28llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AupdateProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3APropertyPos0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AaddToPropertyMap0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3A0x7EHadesGC0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AyoungGenCollection0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AcreateSegment0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AconstructorWriteBarrierSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3AdrainSomeWork0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3ACollectionStats0x3A0x3AgetEvent0x280x290x200x260x26(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AuntrackObject0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3ArecordGCStats0x28hermes0x3A0x3Avm0x3A0x3AGCAnalyticsEvent0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3ACumulativeHeapStats0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3ArecordGCStats0x28hermes0x3A0x3Avm0x3A0x3AGCAnalyticsEvent0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AFloat64ArrayConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADomain0x3A0x3AaddRuntimeModule0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ADomain0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AgetVirtualOffset0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AexecuteCall0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficientImpl0x3Cchar0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3AappendToCopyableString0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AtoString0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20unsigned0x20char0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AfromDouble0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20double0x29(w2c_hermes*, u32, u32, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3AthrowExcessiveCapacityError0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AvisitAndRewriteForInOf0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AtraverseForLexicalDecl0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AVariableDeclarationNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ASequenceExpressionNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AcollectAllIDs0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3ADenseSet0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitFunction0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x260x20std0x3A0x3A_0x5F20x3A0x3Adeque0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3E0x3E0x3A0x3Aemplace_back0x3C0x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionContext0x3A0x3A0x7EFunctionContext0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7ERegex0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApushCharClass0x28hermes0x3A0x3Aregex0x3A0x3ACharacterClass0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3Acompile0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ARegex0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeUnicodeEscapeSequence0x28bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeQuantifierPrefix0x28hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AQuantifier0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AidentityEscape0x28char16_t0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AprepareToEnterLoopBody0x28hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABeginLoopInsn0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ABacktrackInsn0x2C0x2064u0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x3A0x3AprepareToEnterLoopBody0x28hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABeginLoopInsn0x20const0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x3A0x3ABacktrackInsn0x2C0x2064u0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABackRefNode0x2C0x20unsigned0x20int0x260x3E0x28unsigned0x20int0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseObjectAssignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3AObjectExpressionNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AreparseArrayAsignmentPattern0x28hermes0x3A0x3AESTree0x3A0x3AArrayExpressionNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTemplateLiteral0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseStatementListItem0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowImportExport0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseObjectBindingPattern0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseMemberSelect0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseLexicalDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseLeftHandSideExpression0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFromClause0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseFormalParameters0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArrayBindingPattern0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseArguments0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x2C0x20llvh0x3A0x3ASMLoc0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AinitializeIdentifiers0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AerrorRange0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierStart0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeDigit0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeConnectorPunctuation0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeCombiningMark0x28unsigned0x20int0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ApopulateNameTable0x28hermes0x3A0x3AScopedHashTable0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x260x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AmaterializeScopeChain0x28hermes0x3A0x3AIRBuilder0x260x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3ASerializedScope0x20const0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3A0x3A0x7EEnterBlockScope0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x260x20std0x3A0x3A_0x5F20x3A0x3Aoptional0x3Chermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x3A0x3Aemplace0x5Babi0x3Av150070x5D0x3Chermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x2C0x20void0x3E0x28hermes0x3A0x3Airgen0x3A0x3AFunctionContext0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AsetupLazyScope0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ABlockStatementNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldOrAwaitExpr0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenResumeGenerator0x28hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AGenFinally0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenOptionalCallExpr0x28hermes0x3A0x3AESTree0x3A0x3AOptionalCallExpressionNode0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenIdentifierExpression0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionBody0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForWhileLoops0x28hermes0x3A0x3AESTree0x3A0x3ALoopStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenAsyncFunction0x28hermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AVariable0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenArrayFromElements0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitOptionalInitialization0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitIteratorCompleteSlow0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitEnsureObject0x28hermes0x3A0x3AValue0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitCreateFunction0x28hermes0x3A0x3AESTree0x3A0x3AFunctionDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdeclareVariableOrGlobalProperty0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AJavaScriptDeclKind0x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AdeclareAmbientGlobalProperty0x28hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahermes_fatal0x28llvh0x3A0x3AStringRef0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AhermesLog0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x200x2E0x2E0x2E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ASerializedLiteralGenerator0x3A0x3AserializeBuffer0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ALiteral0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AacquirePropertyReadCacheIndex0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AConsecutiveStringStorage0x3A0x3AConsecutiveStringStorage0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20true0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x2A0x20const0x2A0x2C0x20long0x2C0x200l0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aintegral_constant0x3Cbool0x2C0x20true0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeModuleGenerator0x3A0x3AserializeScopeChain0x28hermes0x3A0x3AStringTable0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x260x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitLoadConstUndefined0x28long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AgetFunctionID0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AcreateBCProviderFromBuffer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABuffer0x20const0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABuffer0x20const0x3E0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABytecodeForm0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF16ToUTF8WithSingleSurrogates0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AcheckedCalloc0x28unsigned0x20long0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3Amultiply0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3AisSingleDigitTruncationLossless0x28hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASwitchInst0x3A0x3AgetCasePair0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AgetBufferFileName0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASimpleDiagHandlerRAII0x3A0x3A0x7ESimpleDiagHandlerRAII0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASimpleDiagHandlerRAII0x3A0x3ASimpleDiagHandlerRAII0x28hermes0x3A0x3ASourceErrorManager0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3A0x7ERegisterAllocator0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3A0x7EModule0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AopenArray0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AcloseArray0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AquoteStr0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintVariableName0x28hermes0x3A0x3AVariable0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AgetLiteralPositiveZero0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateUnreachableInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateUnaryOperatorInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AUnaryOperatorInst0x3A0x3AOpKind0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThrowIfEmptyInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateStoreGetterSetterInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AIRBuilder0x3A0x3APropEnumerable0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorNextInst0x28hermes0x3A0x3AAllocStackInst0x2A0x2C0x20hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCSpillMovInst0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCLoadConstInst0x28hermes0x3A0x3ALiteral0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateDeletePropertyInst0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocObjectInst0x28unsigned0x20int0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocArrayInst0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AValue0x2A0x2C0x204u0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AcalculateFunctionScopeData0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20llvh0x3A0x3AOptional0x3Cint0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3AgetSourceRepresentationStr0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunction0x3A0x3Adump0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AhasSimpleParams0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANewExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AFunctionExpressionNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AArrayPatternNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateThisPropertyInitializer0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateCallWithForwardedThis0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3ANodeVector0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ACompiledRegExp0x3A0x3A0x7ECompiledRegExp0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_getoff(w2c_hermes*, u32);
void w2c_hermes_getname(w2c_hermes*, u32, u32);
f64 w2c_hermes_exp(w2c_hermes*, f64);
u32 w2c_hermes_dtoa_fixedpoint(w2c_hermes*, u32, f64, u32, u32, u32, u32, u32);
u32 w2c_hermes_diff(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x2C0x200x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x3E0x3A0x3ALookupBucketFor0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x3E0x280x28anonymous0x20namespace0x290x3A0x3ACSEValue0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20llvh0x3A0x3AScopedHashTableVal0x3C0x28anonymous0x20namespace0x290x3A0x3ACSEValue0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2A0x3E0x20const0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aequals0x3Cchar16_t0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Aregex0x3A0x3AbracketMatchesChar0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x28hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x20const0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ABracketInsn0x20const0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABracketRange320x20const0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3A0x3ACodePoint0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20hermes0x3A0x3Aregex0x3A0x3AbracketMatchesChar0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x28hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x20const0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ABracketInsn0x20const0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3ABracketRange320x20const0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3A0x3ACodePoint0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_atan(w2c_hermes*, f64);
u64 w2c_hermes_0x5F_year_to_secs(w2c_hermes*, u64, u32);
u32 w2c_hermes_0x5F_towrite(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_rem_pio2(w2c_hermes*, f64, u32);
void w2c_hermes_0x5F_munmap(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aprop_name_id_equals0x28HermesABIRuntime0x2A0x2C0x20HermesABIPropNameID0x2C0x20HermesABIPropNameID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3A0x7EStringTableBuilder0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3ApackIntoStorage0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3AgenerateStringTable0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringTableBuilder0x3A0x3AappendU16Storage0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AradixQuicksort0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x3E0x3E0x3A0x3Aemplace_back0x3Cunsigned0x20int0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x260x3E0x28unsigned0x20int0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x260x29(w2c_hermes*, u32, u32, u64);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AradixQuicksort0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x200x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3ASuffixArrayEntry0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_wctomb(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x3E0x3E0x3A0x3A_0x5Fpush_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3ASlab0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Ahbc0x3A0x3ASimpleBytecodeBuilder0x3A0x3ASimpleFunction0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ASimpleBytecodeBuilder0x3A0x3ASimpleFunction0x3E0x3E0x3A0x3A_0x5Femplace_back_slow_path0x3Cunsigned0x20int0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x3E0x28unsigned0x20int0x260x2C0x20unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fstable_sort_move0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3A0x24_00x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Adifference_type0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x3E0x3A0x3Avalue_type0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_up0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_10x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3Aallocate0x28llvh0x3A0x3AArrayRef0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x290x3A0x3A0x24_10x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x2A0x3E0x3A0x3Adifference_type0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cunsigned0x20int0x2A0x3E0x3A0x3Adifference_type0x2C0x20unsigned0x20int0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsift_down0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cllvh0x3A0x3ASMFixIt0x2A0x3E0x3A0x3Adifference_type0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fcall_once_proxy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3Avm0x3A0x3AbuildMetadataTable0x280x290x3A0x3A0x24_00x260x260x3E0x3E0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_void0x20llvh0x3A0x3ASetVector0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3AInstruction0x2A0x2C0x2016u0x3E0x2C0x20llvh0x3A0x3ASmallDenseSet0x3Chermes0x3A0x3AInstruction0x2A0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3E0x3A0x3Ainsert0x3Chermes0x3A0x3AInstruction0x2A0x20const0x2A0x3E0x28hermes0x3A0x3AInstruction0x2A0x20const0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3AvisitSlot0x3Chermes0x3A0x3Avm0x3A0x3AGCPointerBase0x3E0x28char0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Aset0x3C0x28hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AInline0x2900x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AsetNamedSlotValueUnsafe0x3C0x28hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AInline0x2900x3E0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3ApopulateInstruction0x3Chermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3AU16BracketInsn0x3E0x3E0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x3A0x3AInstructionWrapper0x3Chermes0x3A0x3Aregex0x3A0x3AU16BracketInsn0x3E0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AquoteStringForJSON0x3Cllvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x2032u0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3E0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x2032u0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanIdentifierFastPath0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AconsumeIdentifierParts0x3C0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AIdentifierMode0x2900x3E0x280x29(w2c_hermes*, u32);
void w2c_hermes_void0x20hermes0x3A0x3AManagedChunkedList0x3Chermes0x3A0x3Avm0x3A0x3AWeakMapEntrySlot0x2C0x2016ul0x3E0x3A0x3AforEach0x3Cvoid0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AyoungGenEvacuateImpl0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x260x2C0x20bool0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AWeakMapEntrySlot0x260x290x3E0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AFunction0x3A0x3AforEachScopeImpl0x3Chermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x290x3A0x3A0x24_00x3E0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x290x3A0x3A0x24_00x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AProgramNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_void0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x3A0x3Avisit0x3Chermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x3E0x28hermes0x3A0x3Airgen0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADeclHoisting0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_vfprintf(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort30x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_unsigned0x20int0x20const0x2A0x20std0x3A0x3A_0x5F20x3A0x3Alower_bound0x5Babi0x3Av150070x5D0x3Cunsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x3E0x28unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20int0x20const0x2A0x2C0x20unsigned0x20long0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_time(w2c_hermes*);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20short0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20short0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20short0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20int0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x20llvh0x3A0x3ASourceMgr0x3A0x3ASrcBuffer0x3A0x3AgetOffsets0x3Cunsigned0x20char0x3E0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Aend0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3Acondition_variable0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Amutex0x2A0x3E0x3E0x3E0x3A0x3Abegin0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Avector0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhidden_allocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fassoc_sub_state0x2A0x3E0x3E0x3A0x3Avector0x5Babi0x3Av150070x5D0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Athread0x3A0x3Ajoin0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_node0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20void0x2A0x3E0x2A0x3E0x2C0x20bool0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_table0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_hasher0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Funordered_map_equal0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aequal_to0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ahash0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20true0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fhash_value_type0x3Chermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3AFunction0x2A0x2C0x202u0x3E0x3E0x3E0x3E0x3A0x3A_0x5Femplace_unique_key_args0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x260x260x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x3E0x28hermes0x3A0x3AFunction0x2A0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apiecewise_construct_t0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3Chermes0x3A0x3AFunction0x2A0x260x260x3E0x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Atuple0x3C0x3E0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3ADenseMapIterator0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x2C0x20false0x3E0x2C0x20bool0x3E0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x3A0x3Atry_emplace0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x260x3E0x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x3E0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fequal_range0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x3E0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x2C0x20hermes0x3A0x3ACodePointSet0x3A0x3Aadd0x28hermes0x3A0x3ACodePointRange0x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3ACodePointRange0x2C0x20hermes0x3A0x3ACodePointRange0x290x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fidentity0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fuse_branchless_sort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort5_maybe_branchless0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fuse_branchless_sort0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x3A0x3Avalue0x2C0x20void0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fsort4_maybe_branchless0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_ClassicAlgPolicy0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_random_access_iterator0x3Cchar0x20const0x2A0x3E0x3A0x3Avalue0x2C0x20char0x2A0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Acopy_n0x5Babi0x3Av150070x5D0x3Cchar0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20char0x2A0x3E0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x3E0x3E0x3A0x3Ainsert0x3Cstd0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Chermes0x3A0x3Aregex0x3A0x3ANode0x2A0x20const0x2A0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar16_t0x20const0x2A0x3E0x3A0x3Avalue0x200x260x260x20is_constructible0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aiterator_traits0x3Cchar16_t0x20const0x2A0x3E0x3A0x3Areference0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar16_t0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Ainsert0x3Cchar16_t0x20const0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar16_t0x20const0x2A0x3E0x2C0x20char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aenable_if0x3C_0x5Fis_cpp17_forward_iterator0x3Cchar0x2A0x3E0x3A0x3Avalue0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x2A0x3E0x3E0x3A0x3Atype0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3A0x3Ainsert0x3Cchar0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fwrap_iter0x3Cchar0x20const0x2A0x3E0x2C0x20char0x2A0x2C0x20char0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20std0x3A0x3A_0x5F20x3A0x3Aoperator0x2B0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x28char0x20const0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3Aappend0x28unsigned0x20long0x2C0x20char16_t0x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3A0x3A_0x5Fgrow_by_and_replace0x28unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x2C0x20char16_t0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aback_insert_iterator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x3E0x3E0x3E0x3A0x3Aoperator0x3D0x5Babi0x3Av150070x5D0x28hermes0x3A0x3Aregex0x3A0x3ACapturedRange0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3A0x3A0x7E_0x5Fthread_struct0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fdeque_base0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x3E0x3E0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_sigprocmask(w2c_hermes*, u32, u32);
u64 w2c_hermes_rule_to_secs(w2c_hermes*, u32, u32);
u32 w2c_hermes_printf_core(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_printSourceLine0x28llvh0x3A0x3Araw_ostream0x260x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_pow(w2c_hermes*, f64, f64);
void w2c_hermes_pop_arg(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3A0x7EEvacAcceptor0x280x290x2E3(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3A0x7EEvacAcceptor0x280x290x2E2(w2c_hermes*, u32);
f64 w2c_hermes_nextafter(w2c_hermes*, f64);
f64 w2c_hermes_modf(w2c_hermes*, f64, u32);
void w2c_hermes_llvh0x3A0x3Awrite_integer0x28llvh0x3A0x3Araw_ostream0x260x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x2C0x20llvh0x3A0x3AIntegerStyle0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3Aroot_path0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3Asys0x3A0x3Apath0x3A0x3AStyle0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28llvh0x3A0x3ATwine0x20const0x260x2C0x20bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Areport_fatal_error0x28char0x20const0x2A0x2C0x20bool0x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Apreferred_buffer_size0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Aformatv_object_base0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Acopy_to_buffer0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Araw_fd_ostream0x28int0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AisLegalUTF80x28unsigned0x20char0x20const0x2A0x2C0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20unsigned0x20long0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucket0x3Cunsigned0x20long0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20unsigned0x20long0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20unsigned0x20char0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20unsigned0x20char0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20unsigned0x20char0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20unsigned0x20char0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20unsigned0x20char0x3E0x3E0x3A0x3AInsertIntoBucket0x3Cunsigned0x20int0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20unsigned0x20char0x3E0x2A0x2C0x20unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Cunsigned0x20int0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x3E0x2A0x2C0x20unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Cunsigned0x20int0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRoot0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x2A0x2C0x20unsigned0x20int0x260x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3AStringRef0x3E0x28llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x2C0x20hermes0x3A0x3Aparser0x3A0x3ASMLocInfo0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x3E0x3A0x3AInsertIntoBucket0x3Cllvh0x3A0x3ASMLoc0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3Aparser0x3A0x3APreParsedFunctionInfo0x3E0x2A0x2C0x20llvh0x3A0x3ASMLoc0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucketImpl0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x28llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x20const0x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x260x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AUniqueString0x2A0x20const0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AInstruction0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AInstruction0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x3E0x3E0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AFunction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3AFunction0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AFunction0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3E0x3E0x3E0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x2A0x20llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x3E0x2C0x20hermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x3E0x3A0x3AInsertIntoBucket0x3Chermes0x3A0x3ACatchInst0x2A0x20const0x260x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x2A0x2C0x20hermes0x3A0x3ACatchInst0x2A0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ARehashTable0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AStringMapImpl0x3A0x3ALookupBucketFor0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3AgetLineRef0x28unsigned0x20int0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASourceMgr0x3A0x3APrintIncludeStack0x28llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cvoid0x2C0x20void0x200x280x2A0x290x28void0x2A0x290x3E0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x2C0x20false0x3E0x3A0x3Adestroy_range0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Aparser0x3A0x3APreParsedBufferInfo0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorTemplateBase0x3Cllvh0x3A0x3ASMFixIt0x2C0x20false0x3E0x3A0x3Agrow0x28unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Cllvh0x3A0x3ASmallString0x3C24u0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugFileRegion0x3E0x3A0x3Aoperator0x3D0x28llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3Ahbc0x3A0x3ADebugFileRegion0x3E0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACodePointRange0x3E0x3A0x3Ainsert0x28hermes0x3A0x3ACodePointRange0x2A0x2C0x20hermes0x3A0x3ACodePointRange0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallSet0x3Cunsigned0x20int0x2C0x204u0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASmallSet0x3Cunsigned0x20int0x2C0x2016u0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aless0x3Cunsigned0x20int0x3E0x3E0x3A0x3Ainsert0x28unsigned0x20int0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ASHA10x3A0x3Ahash0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AMemoryBuffer0x3A0x3AgetMemBuffer0x28llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x2C0x20bool0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3Aoperator0x3D0x3D0x28llvh0x3A0x3AFoldingSetNodeID0x20const0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSetNodeID0x3A0x3AComputeHash0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSetBase0x3A0x3AGrowBucketCount0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralBigInt0x3E0x3A0x3ANodeEquals0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x20const0x260x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralBigInt0x3E0x3A0x3AGetNodeProfile0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralBigInt0x3E0x3A0x3AComputeNodeHash0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AErrorOr0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x3E0x3A0x3AgetError0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3A0x3AupdateDFSNumbers0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3ADomTreeBuilder0x3A0x3ASemiNCAInfo0x3Cllvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x3E0x3A0x3AgetNodeForBlock0x28hermes0x3A0x3ABasicBlock0x2A0x2C0x20llvh0x3A0x3ADominatorTreeBase0x3Chermes0x3A0x3ABasicBlock0x2C0x20false0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x3E0x3A0x3AisEqual0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x2C0x204u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x3E0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AFileAndSourceMapId0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRef0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x208u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AUniqueString0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AUniqueString0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20llvh0x3A0x3ASmallPtrSet0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x202u0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ASmallDenseMap0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x2016u0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x3E0x3A0x3AmoveFromOldBuckets0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x20const0x2A0x2C0x20int0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AStringRef0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3ASmallVector0x3Cchar0x2C0x2032u0x3E0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMapBase0x3Cllvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ABasicBlock0x2A0x2C0x20hermes0x3A0x3ARegisterAllocator0x3A0x3ABlockLifetimeInfo0x3E0x3E0x3A0x3AdestroyAll0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20long0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20long0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cunsigned0x20int0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cunsigned0x20int0x2C0x20hermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cllvh0x3A0x3AStringRef0x2C0x20llvh0x3A0x3AStringRef0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cint0x2C0x20hermes0x3A0x3AIdentifier0x3E0x2C0x20hermes0x3A0x3ABuiltinMethod0x3A0x3AEnum0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Cllvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ARegister0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ARegister0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Ashrink_and_clear0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AInstruction0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetEmpty0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AInstruction0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseSetPair0x3Chermes0x3A0x3AInstruction0x2A0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3AIdentifier0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3AIdentifier0x2C0x20unsigned0x20int0x3E0x3E0x3A0x3Agrow0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcShiftRight0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcShiftLeft0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AtcMultiplyPart0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20long0x20long0x20const0x2A0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20long0x20long0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20bool0x29(w2c_hermes*, u32, u32, u64, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AshlSlowCase0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AAPInt0x3A0x3AAPInt0x28unsigned0x20int0x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20long0x20long0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_isatty(w2c_hermes*, u32);
u32 w2c_hermes_internal_memalign(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedFindHelper0x28void0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypeOf0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtrimEnd0x28hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtoUInt160x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringToSymbolID0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsplitMatch0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeExec0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpConstructorInternal0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpConstructorFastCopy0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreduceHelper0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AraisePlaceholder0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AraiseErrorForOverridingStaticBuiltin0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseESDate0x28hermes0x3A0x3Avm0x3A0x3AStringView0x290x3A0x3A0x24_50x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseESDate0x28hermes0x3A0x3Avm0x3A0x3AStringView0x290x3A0x3A0x24_10x3A0x3Aoperator0x280x290x28int0x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseESDate0x28hermes0x3A0x3Avm0x3A0x3AStringView0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28int0x290x20const(w2c_hermes*, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseDate0x28hermes0x3A0x3Avm0x3A0x3AStringView0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AordinaryToPrimitive0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APreferredType0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AordinaryHasInstance0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aoperator0x3C0x3C0x28llvh0x3A0x3Araw_ostream0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectFromPropertyDescriptor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectDefinePropertiesInternal0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmakeTimeFromArgs_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x290x3A0x3A0x24_30x3A0x3A_0x5Finvoke0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x290x3A0x3A0x24_20x3A0x3A_0x5Finvoke0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessEqualOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x290x3A0x3A0x24_30x3A0x3A_0x5Finvoke0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AlessEqualOp_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x290x3A0x3A0x24_20x3A0x3A_0x5Finvoke0x28int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AiteratorClose0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AinstanceOfOperator_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AindexOfHelper0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalTTRCReached0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetStringIndex0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgetForInPropertyNames0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20unsigned0x20int0x260x2C0x20unsigned0x20int0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfindHelper0x28void0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AeverySomeHelper0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aencode0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20bool0x200x280x2A0x290x28char16_t0x290x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdirectRegExpExec0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSRegExp0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdirectObjectPrototypeToString0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AequivalentTime0x28long0x20long0x29(w2c_hermes*, u64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransitionMap0x3A0x3Alookup0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransitionMap0x3A0x3AinsertNew0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3AIdentifierHashTable0x3A0x3AgrowAndRehash0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdefineProperty0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Adecode0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20bool0x200x280x2A0x290x28char16_t0x290x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateTimeString0x28double0x2C0x20double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, f64, f64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateString0x28double0x2C0x20double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, f64, f64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetInt80x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetInt320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetInt160x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetBigInt640x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeIsAsync0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetThis0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayCopyHelper0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AGCScope0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AtypedArrayCreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AsetWithTrap0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AproxyCreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AlookupAccessor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AisCompatiblePropertyDescriptor0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AheapFixDown0x28hermes0x3A0x3Avm0x3A0x3ASortModel0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20int0x3E0x3E0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AhasWithTrap0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AgetWithTrap0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AdeleteWithTrap0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Ctrue0x3E0x3A0x3Aswap0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStandardSortModel0x3A0x3AStandardSortModel0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ARuntimeJSONParser0x3A0x3AoperationWalk0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AJSONStringifyer0x3A0x3AappendToOutput0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AWeakValueMap0x3Chermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ATransition0x2C0x20hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3A0x3ApruneInvalid0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aslice0x28hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringView0x3A0x3Aconst_iterator0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficient0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3Aconcat0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3AvisitFieldsWithinRange0x28char0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ASlotOffsets0x20const0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3AvisitArrayWithinRange0x28char0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3AArrayData0x20const0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASlotVisitor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3AvisitWithinRange0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ASlotOffsets0x20const0x260x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3AthrowExcessiveCapacityError0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3AshrinkRight0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3AincreaseSize0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AthrowExcessiveCapacityError0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AresizeWithinCapacity0x28hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AincreaseSizeWithinCapacity0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASegmentedArrayBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Acapacity0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3A0x7ERuntimeModule0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x3A0x3AgetStringFromStringID0x28unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AraiseTypeError0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AprintRuntimeGCStats0x28hermes0x3A0x3AJSONEmitter0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmarkRoots0x28hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmarkRootsForCompleteMarking0x28hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinsertVisitedObject0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCallStackNoAlloc0x28hermes0x3A0x3Ainst0x3A0x3AInst0x20const0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AdrainJobs0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AaddToKeptObjects0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3AremoveLinkedListNode0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHashMapEntry0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3ArehashIfNecessary0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3Aerase0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AOrderedHashMap0x3A0x3Aclear0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AMetadata0x3A0x3ABuilder0x3A0x3AaddField0x28char0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3AsetValue0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3AhasValue0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3AdeleteValue0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3AdebugFreeSlotsAndGetSize0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29380x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29380x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Csigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29350x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cshort0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29360x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Clong0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29440x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cint0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29370x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSSymbol0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSRegExp0x3A0x3Ainitialize0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSRegExp0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AsetTargetAndHandler0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AsetNamed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AownPropertyKeys0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AOwnKeysFlags0x290x3A0x3A0x24_10x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3AHermesValue0x290x20const(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AhasNamed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AhasComputed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AgetPrototypeOf0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3AgetNamed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSProxy0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AupdatePropertyFlagsWithoutTransitions0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3AOptValue0x3Cllvh0x3A0x3AArrayRef0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AupdateOwnProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3APropertyPos0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AsetNamedSlotValueUnsafe0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AhasNamedOrIndexed0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetOwnNamedDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetNamedPropertyValue_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ANamedPropertyDescriptor0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AgetComputedDescriptor0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AComputedPropertyDescriptor0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3AcheckPropertyUpdate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3ADefinePropertyFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3APropOpFlags0x29(w2c_hermes*, u32, u32, u32, u32, u64, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3Aerror0x28hermes0x3A0x3Avm0x3A0x3ATwineChar160x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3AconsumeUnicode0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3AadvanceStrAsSymbol0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSONLexer0x3A0x3AadvanceHelper0x28bool0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSMapIteratorImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29500x3E0x3A0x3AnextElement0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSMapIteratorImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29500x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSMapIteratorImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29490x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29470x3E0x3A0x3AforEach0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29470x3E0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSFunction0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ADomain0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3AgetFunctionNameAtIndex0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSError0x3E0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3AJSError0x2C0x20true0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2910x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20bool0x260x3E0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x260x260x2C0x20bool0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSBigInt0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayIterator0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AIterationKind0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3AcopyDataBlockBytes0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x2A0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x2A0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AmakeA0x3Chermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x2C0x20true0x2C0x200x28hermes0x3A0x3Avm0x3A0x3AHasFinalizer0x2910x2C0x200x28hermes0x3A0x3Avm0x3A0x3ALongLived0x2900x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x3E0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AsaveGenerator0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x2A0x2C0x20hermes0x3A0x3Ainst0x3A0x3AInst0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AreifyArgumentsSlowPath0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AputByIdTransient_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AimplCallBuiltin0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AgetArgumentsPropByValSlowPath_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AcreateObjectFromBuffer0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AcreateGenerator_RJS0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x2A0x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AEnvironment0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInterpreter0x3A0x3AcreateArrayFromBuffer0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ACodeBlock0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AInt16ArrayConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AvisitIdentifiers0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AunmarkSymbols0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3Areserve0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AfreeUnmarkedSymbols0x28llvh0x3A0x3ABitVector0x20const0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AIDTracker0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AcreateNotUniquedSymbol0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AconvertSymbolToUTF80x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocIDAndInsert0x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3AdeleteProperty0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3APropertyPos0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AClassFlags0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHiddenClass0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3APropertyFlags0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AwaitForCollectionToFinish0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsnapshotWriteBarrierInternal0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AsetYoungGen0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AremoveSegmentExtentFromCrashManager0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AoldGenCollection0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AincrementalCollect0x28bool0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetKindAsStr0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfo0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AforAllObjs0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AfinalizeAll0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AconstructorWriteBarrierSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue320x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AconstructorWriteBarrierRangeSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AconstructorWriteBarrierRangeSlow0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3Acollect0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AcheckTripwireAndSubmitStats0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AOldGen0x3A0x3Asearch0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AOldGen0x3A0x3AaddSegment0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3ARootSymbolID0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHadesGC0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AGCCallbacks0x260x2C0x20hermes0x3A0x3Avm0x3A0x3APointerBase0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AGCConfig0x20const0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3ACrashManager0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGeneratorInnerFunction0x3A0x3AcallInnerFunction0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AGeneratorInnerFunction0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AGeneratorInnerFunction0x3A0x3AAction0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x3A0x3AsetNull0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCConfig0x3A0x3AGCConfig0x28hermes0x3A0x3Avm0x3A0x3AGCConfig0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3A0x7EGCBase0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AruntimeWillExecute0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AprintStats0x28hermes0x3A0x3AJSONEmitter0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AcheckTripwire0x28unsigned0x20long0x290x3A0x3ACtx0x3A0x3AcreateSnapshotToFile0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AGCCycle0x3A0x3A0x7EGCCycle0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AGCCycle0x3A0x3AGCCycle0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCAnalyticsEvent0x3A0x3A0x7EGCAnalyticsEvent0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCAnalyticsEvent0x3A0x3AGCAnalyticsEvent0x28hermes0x3A0x3Avm0x3A0x3AGCAnalyticsEvent0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3AcreateLongLived0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3ARootSymbolID0x20const0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADictPropertyMap0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACopyableVector0x3Chermes0x3A0x3Avm0x3A0x3ARuntimeModule0x2A0x3E0x3A0x3Agrow0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeCoverageProfiler0x3A0x3AglobalMutex0x280x29(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeCoverageProfiler0x3A0x3AallProfilers0x280x29(w2c_hermes*);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AfindCatchTargetOffset0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACodeBlock0x3A0x3AcreateCodeBlock0x28hermes0x3A0x3Avm0x3A0x3ARuntimeModule0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ARuntimeFunctionHeader0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AfirstObjForCard0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3AdirtyCardsForAddressRange0x28void0x20const0x2A0x2C0x20void0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACardTable0x3A0x3Aclear0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AextractOwnLengthProperty_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3AcreateThisForConstruct_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2900x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetOrCreateIdentifier0x3Cchar0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2900x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AgetOrCreateIdentifier0x3Cchar16_t0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar0x2C0x20true0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3AIdentifierTable0x3A0x3AallocateDynamicString0x3Cchar16_t0x2C0x20true0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2920x3E0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3A0x3AcreateEfficientImpl0x3Cchar16_t0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar16_t0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABufferedStringPrimitive0x3Cchar16_t0x3E0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AStringPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABoundFunction0x3A0x3AinitializeLengthAndName_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABoundFunction0x3A0x3Acreate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Areverse_iterator0x3Chermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x20const0x2A0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABoundFunction0x3A0x3A_boundCall0x28hermes0x3A0x3Avm0x3A0x3ABoundFunction0x2A0x2C0x20hermes0x3A0x3Ainst0x3A0x3AInst0x20const0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3Ashift0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3AreallocateToLarger0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3ApushBackSlowPath0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x3A0x3A_trimSizeCallback0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3Ashift0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3AreallocateToLarger0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3ApushBackSlowPath0x28hermes0x3A0x3Avm0x3A0x3AMutableHandle0x3Chermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayStorageBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x3A0x3A_trimSizeCallback0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x3A0x3Aoperator0x3D0x28hermes0x3A0x3Avm0x3A0x3AAlignedStorage0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3AcanonicalizeForBlockScoping0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x3A0x3AvisitAndRewriteFor0x28hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3AImportDefaultSpecifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3Avisit0x28hermes0x3A0x3AESTree0x3A0x3ADoWhileStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3AvisitForInOf0x28hermes0x3A0x3AESTree0x3A0x3ALoopStatementNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x3A0x3ASemanticValidator0x28hermes0x3A0x3AContext0x260x2C0x20hermes0x3A0x3Asem0x3A0x3ASemContext0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Asem0x3A0x3AFunctionInfo0x3A0x3A0x7EFunctionInfo0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AsearchWithBytecode0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x3E0x3E0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AMatchFlagType0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AsearchWithBytecode0x28llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20char16_t0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ACapturedRange0x3E0x3E0x2A0x2C0x20hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AMatchFlagType0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3Aconstants0x3A0x3AErrorType0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AparseWithBackRefLimit0x3Cchar16_t0x20const0x2A0x3E0x28char16_t0x20const0x2A0x2C0x20char16_t0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20bool0x2C0x20unsigned0x20int0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeGroupName0x28llvh0x3A0x3ASmallVector0x3Cchar16_t0x2C0x205u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AtryConsumeBracketClassAtom0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AconsumeCharacterEscape0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AcloseAlternation0x28llvh0x3A0x3ASmallVector0x3Chermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AParseStackElement0x2C0x204u0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AapplyQuantifier0x28hermes0x3A0x3Aregex0x3A0x3AParser0x3Chermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20char16_t0x20const0x2A0x3E0x3A0x3AQuantifier0x20const0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3Amatch0x28hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AContext0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x3A0x3Amatch0x28hermes0x3A0x3Aregex0x3A0x3AState0x3Chermes0x3A0x3Aregex0x3A0x3AASCIIRegexTraits0x3E0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2A0x20hermes0x3A0x3Aregex0x3A0x3ARegex0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AappendNode0x3Chermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x2C0x20hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x260x2C0x20bool0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x3E0x28hermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x260x2C0x20bool0x260x2C0x20hermes0x3A0x3Aregex0x3A0x3ASyntaxFlags0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseTemplateLiteral0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28bool0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseSpreadElement0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparsePropertyAssignment0x28bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseProgram0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseOptionalExpressionExceptNew_tail0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorCall0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseNewExpressionOrOptionalExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AIsConstructorCall0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseIfStatement0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDirective0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassTail0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AClassParseKind0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseClassDeclaration0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBindingInitializer0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseBinaryExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x290x3A0x3A0x24_10x3A0x3Aoperator0x280x290x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssignmentExpression0x28hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x3A0x3AState0x260x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AParam0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AAllowTypedArrowFunction0x2C0x20hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3ACoverTypedParameters0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AparseAssertClause0x28llvh0x3A0x3Asimple_ilist0x3Chermes0x3A0x3AESTree0x3A0x3ANode0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3Aneed0x28hermes0x3A0x3Aparser0x3A0x3ATokenKind0x2C0x20char0x20const0x2A0x2C0x20char0x20const0x2A0x2C0x20llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3A0x3AcheckDeclaration0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3APreParsedData0x3A0x3AgetBufferInfo0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3Aparse0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSParser0x3A0x3AJSParser0x28hermes0x3A0x3AContext0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Aparser0x3A0x3AParserPass0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AstoreCurrentToken0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AskipBlockComment0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanTemplateLiteral0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanReservedWord0x28char0x20const0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanNumber0x28hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AGrammarContext0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AscanLineComment0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AinitializeReservedIdentifiers0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AinitStorageWith0x28char0x20const0x2A0x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AappendUnicodeToStorage0x28unsigned0x20int0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aparser0x3A0x3AJSLexer0x3A0x3AJSLexer0x28unsigned0x20int0x2C0x20hermes0x3A0x3ASourceErrorManager0x260x2C0x20hermes0x3A0x3ABacktrackingBumpPtrAllocator0x260x2C0x20hermes0x3A0x3AStringTable0x2A0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AisUnicodeOnlySpace0x28unsigned0x20int0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AisSimpleSideEffectFreeInstruction0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AcastAsVariable0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3ALReference0x3A0x3AcastAsGlobalObjectProperty0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AserializeScope0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AhoistCreateFunctions0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenFunctionDeclarations0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenExpressionWrapper0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AensureVariableExists0x28hermes0x3A0x3AESTree0x3A0x3AIdentifierNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitParameters0x28hermes0x3A0x3AESTree0x3A0x3AFunctionLikeNode0x2A0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitIteratorValueSlow0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AemitCall0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionLikeNode0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AcreateScopeBindings0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AESTreeIRGen0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AESTree0x3A0x3AProgramNode0x2A0x3E0x3E0x20const0x260x2C0x20hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AScopeChain0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AgetStringFromEntry0x28hermes0x3A0x3AStringTableEntry0x20const0x260x2C0x20llvh0x3A0x3AArrayRef0x3Cunsigned0x20char0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AappendTagToBuffer0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20unsigned0x20char0x2C0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHVMRegisterAllocator0x3A0x3A0x7EHVMRegisterAllocator0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AobtainFileAndSourceMapId0x28hermes0x3A0x3ASourceErrorManager0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateLoadStackInst0x28hermes0x3A0x3ALoadStackInst0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AacquirePropertyWriteCacheIndex0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADebugInfoGenerator0x3A0x3AappendString0x28std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x260x2C0x20hermes0x3A0x3AIdentifier0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitPutOwnByIndex0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitPutOwnByIndexL0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitMov0x28long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitMovLong0x28long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitJmpUndefinedLong0x28long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitJStrictNotEqualLong0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitJStrictEqualLong0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitJNotEqualLong0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitJEqualLong0x28long0x20long0x2C0x20long0x20long0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64, u64, u64);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeInstructionGenerator0x3A0x3AemitGetGlobalObject0x28long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AgetScopeDescID0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AbytecodeGenerationComplete0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABytecodeFunctionGenerator0x3A0x3AaddFilename0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AcreateBCProviderFromSrcImpl0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ABuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ABuffer0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3ASourceMap0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ASourceMap0x3E0x3E0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ACompileFlags0x20const0x260x2C0x20hermes0x3A0x3AScopeChain0x20const0x260x2C0x20void0x200x280x2A0x290x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20void0x2A0x290x2C0x20void0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3AModule0x260x290x3E0x20const0x260x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3ABCProviderFromSrc0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeModule0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABytecodeModule0x3E0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3A0x3AgetEpilogue0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AconvertUTF8WithSurrogatesToUTF8WithReplacements0x28std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x260x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AconstructCatchMap0x28hermes0x3A0x3AFunction0x2A0x2C0x20llvh0x3A0x3ADenseMap0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x2C0x20llvh0x3A0x3ADenseMapInfo0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ACatchInst0x2A0x2C0x20hermes0x3A0x3ACatchCoverageInfo0x3E0x3E0x260x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Chermes0x3A0x3ACatchInst0x2A0x3E0x260x2C0x20llvh0x3A0x3ASmallPtrSetImpl0x3Chermes0x3A0x3ABasicBlock0x2A0x3E0x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3Asubtract0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3Aadd0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3AaddSignedResultSize0x28hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20long0x20long0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AsignedRightShiftAdapter0x28unsigned0x20long0x20long0x2A0x2C0x20unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AshiftImpl0x28hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AShiftOpIs0x2C0x20hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32, u32, u32, u64);
void w2c_hermes_hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AnegateAdditiveOpPostProcess0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3Adiv_rem0x3A0x3Acompute0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AbigintAsImpl0x28hermes0x3A0x3Abigint0x3A0x3AMutableBigIntRef0x2C0x20unsigned0x20int0x2C0x20unsigned0x20long0x20long0x2C0x20hermes0x3A0x3Abigint0x3A0x3AImmutableBigIntRef0x2C0x20hermes0x3A0x3Abigint0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABigIntAs0x29(w2c_hermes*, u32, u32, u64, u32, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3AdumpIfEnabled0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3ACodeGenerationSettings_DumpSettings0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32, u32, u64);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3AdumpIfEnabled0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ACodeGenerationSettings_DumpSettings0x20const0x260x2C0x20llvh0x3A0x3AStringRef0x290x20const(w2c_hermes*, u32, u32, u32, u64);
u32 w2c_hermes_hermes0x3A0x3AUnaryOperatorInst0x3A0x3AparseOperator0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AfindBufferLineAndLoc0x28llvh0x3A0x3ASMLoc0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceCoords0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AdoGenMessage0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ADiagKind0x2C0x20llvh0x3A0x3ASMLoc0x2C0x20llvh0x3A0x3ASMRange0x2C0x20llvh0x3A0x3ATwine0x20const0x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AaddNewSourceBuffer0x28std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cllvh0x3A0x3AMemoryBuffer0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3E0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetRegisterForInstructionAt0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3Adump0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AremoveEntry0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3APhiInst0x3A0x3AaddEntry0x28hermes0x3A0x3AValue0x2A0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3APassManager0x3A0x3A0x7EPassManager0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AParameter0x3A0x3AParameter0x28hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AIdentifier0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AModule0x3A0x3Adump0x28llvh0x3A0x3Araw_ostream0x260x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AModule0x3A0x3AModule0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3AContext0x3E0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AprimitiveEmitString0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AJSONEmitter0x3A0x3AemitValue0x28long0x20long0x29(w2c_hermes*, u32, u64);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3A0x7EIRPrinter0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitScope0x28hermes0x3A0x3AScopeDesc0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AvisitFunction0x28hermes0x3A0x3AFunction0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintValueLabel0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintInstructionDestination0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AescapeStr0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTryLoadGlobalPropertyInst0x28hermes0x3A0x3AGlobalObjectProperty0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateTopLevelFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateThisParameter0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateResumeGeneratorInst0x28hermes0x3A0x3AValue0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateIteratorBeginInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCResolveEnvironment0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCReifyArgumentsInst0x28hermes0x3A0x3AAllocStackInst0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCLoadParamInst0x28hermes0x3A0x3ALiteralNumber0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCGetGlobalObjectInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateHBCAllocObjectFromBufferInst0x28llvh0x3A0x3ASmallVector0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Chermes0x3A0x3ALiteral0x2A0x2C0x20hermes0x3A0x3ALiteral0x2A0x3E0x2C0x204u0x3E0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGlobalObjectProperty0x28hermes0x3A0x3AIdentifier0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateGetNewTargetInst0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateFunction0x28hermes0x3A0x3AScopeDesc0x2A0x2C0x20llvh0x3A0x3AStringRef0x2C0x20hermes0x3A0x3AFunction0x3A0x3ADefinitionKind0x2C0x20bool0x2C0x20hermes0x3A0x3ASourceVisibility0x2C0x20llvh0x3A0x3ASMRange0x2C0x20bool0x2C0x20hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRBuilder0x3A0x3AcreateAllocStackInst0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AFunctionScopeAnalysis0x3A0x3AgetScopeDepth0x28hermes0x3A0x3AScopeDesc0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ABlockScopingTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3Asem0x3A0x3ASemanticValidator0x2C0x20true0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3Asem0x3A0x3ASemanticValidator0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassPropertyNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AWithStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AObjectPatternNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AForInStatementNode0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AESTree0x3A0x3ARecursiveVisitorDispatch0x3Chermes0x3A0x3AES6ClassesTransformations0x2C0x20false0x3E0x3A0x3AvisitChildren0x28hermes0x3A0x3AES6ClassesTransformations0x260x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassDeclarationNode0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AmakeSingleVariableDecl0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AmakeHermesES6InternalCall0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AStringRef0x2C0x200x28anonymous0x20namespace0x290x3A0x3ANodeVector0x20const0x260x29(w2c_hermes*, u32, u32, u64, u32);
u32 w2c_hermes_hermes0x3A0x3AES6ClassesTransformations0x3A0x3AcreateClass0x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3AClassBodyNode0x2A0x2C0x20hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ADominanceInfo0x3A0x3AproperlyDominates0x28hermes0x3A0x3AInstruction0x20const0x2A0x2C0x20hermes0x3A0x3AInstruction0x20const0x2A0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AparseOperator0x28llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ABinaryOperatorInst0x3A0x3AgetSideEffect0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ABasicBlock0x3A0x3AeraseFromParent0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ABacktrackingBumpPtrAllocator0x3A0x3A0x7EBacktrackingBumpPtrAllocator0x280x29(w2c_hermes*, u32);
void w2c_hermes_getrule(w2c_hermes*, u32, u32);
u32 w2c_hermes_getint(w2c_hermes*, u32);
u32 w2c_hermes_getenv(w2c_hermes*, u32);
u32 w2c_hermes_g_dtoa(w2c_hermes*, u32, f64, u32, u32, u32);
u32 w2c_hermes_checkint(w2c_hermes*, u64);
u32 w2c_hermes_char0x2A0x20llvh0x3A0x3Ahashing0x3A0x3Adetail0x3A0x3Ahash_combine_recursive_helper0x3A0x3Acombine_data0x3Cunsigned0x20int0x3E0x28unsigned0x20long0x260x2C0x20char0x2A0x2C0x20char0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x2C0x20unsigned0x20int0x2A0x3E0x28unsigned0x20int0x2A0x2C0x20unsigned0x20int0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x3E0x28std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cstd0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Apair0x3Cunsigned0x20int0x2C0x20unsigned0x20int0x3E0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x2C0x20llvh0x3A0x3ASMFixIt0x2A0x3E0x28llvh0x3A0x3ASMFixIt0x2A0x2C0x20llvh0x3A0x3ASMFixIt0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Cllvh0x3A0x3ASMFixIt0x2C0x20llvh0x3A0x3ASMFixIt0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AKindedEntry0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x3E0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x3A0x3AtoTable0x28hermes0x3A0x3Ahbc0x3A0x3AUniquingStringLiteralAccumulator0x2C0x20bool0x290x3A0x3AIndex0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x3E0x28hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fless0x3Chermes0x3A0x3AExceptionHandlerInfo0x2C0x20hermes0x3A0x3AExceptionHandlerInfo0x3E0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Chermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x3E0x28llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20llvh0x3A0x3Adetail0x3A0x3ADenseMapPair0x3Chermes0x3A0x3ASwitchImmInst0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3ASwitchImmInfo0x3E0x2A0x2C0x20hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3AgenerateJumpTable0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_bool0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Finsertion_sort_incomplete0x3Chermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x3E0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3ABufferedMessage0x2A0x2C0x20hermes0x3A0x3ASourceErrorManager0x3A0x3AdisableBuffering0x280x290x3A0x3A0x24_00x260x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_b2d(w2c_hermes*, u32, u32);
void w2c_hermes_0x5F_wasm_call_ctors(w2c_hermes*);
u32 w2c_hermes_0x5F_vfprintf_internal(w2c_hermes*, u32, u32, u32, u32, u32);
f64 w2c_hermes_0x5F_tan(w2c_hermes*, f64, f64, u32);
u32 w2c_hermes_0x5F_syscall_openat(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_syscall_mprotect(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x5F_strchrnul(w2c_hermes*, u32, u32);
void w2c_hermes_0x5F_overflow(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_map_file(w2c_hermes*, u32);
u32 w2c_hermes_0x5F_lockfile(w2c_hermes*, u32);
f64 w2c_hermes_0x5F_expo2(w2c_hermes*, f64, f64);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_static_type_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Aprocess_found_base_class0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5FZN6hermes6bigint12_GLOBAL_0x5FN_127BigIntLiteralParsingToolBoxINS1_26StringIntegerLiteralParserIN4llvh8ArrayRefIDsEEEEE22lookaheadAndEatIfAnyOfIJLDs48ELDs49ELDs50ELDs51ELDs52ELDs53ELDs54ELDs55ELDs56ELDs57ELDs65ELDs66ELDs67ELDs68ELDs69ELDs70ELDs97ELDs98ELDs99ELDs100ELDs101ELDs102EEEENS_8OptValueIDsEEv(w2c_hermes*, u32, u32);
void w2c_hermes_0x5FExit(w2c_hermes*);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AwriteToBuf0x28HermesABIGrowableBuffer0x2A0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ArunBCProvider0x280x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x2C0x20llvh0x3A0x3AStringRef0x29(w2c_hermes*, u32, u32, u32, u64);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_arraybuffer_from_external_data0x28HermesABIRuntime0x2A0x2C0x20HermesABIMutableBuffer0x2A0x290x3A0x3A0x24_00x3A0x3A_0x5Finvoke0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeState0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AlayoutIfNeeded0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cunsigned0x20char0x3E0x3A0x3AStringEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cunsigned0x20char0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cunsigned0x20char0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AlayoutIfNeeded0x280x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x260x20std0x3A0x3A_0x5F20x3A0x3Avector0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AStringPacker0x3Cchar16_t0x3E0x3A0x3AStringEntry0x3E0x3E0x3A0x3Aemplace_back0x3Cunsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x3E0x28unsigned0x20int0x260x2C0x20std0x3A0x3A_0x5F20x3A0x3Avector0x3Cchar16_t0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar16_t0x3E0x3E0x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AMemoryBufferMem0x3Cllvh0x3A0x3AMemoryBuffer0x3E0x3A0x3AgetBufferIdentifier0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AManagedValue0x3Chermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x3E0x3A0x3Ainvalidate0x28HermesABIManagedPointer0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AFunctionDebugInfoDeserializer0x3A0x3Anext0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_void0x2A0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_proxy0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3Atuple0x3Cstd0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3E0x3E0x2C0x20void0x200x280x2A0x290x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x290x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x3E0x3E0x28void0x2A0x29(w2c_hermes*, u32);
f64 w2c_hermes_trunc(w2c_hermes*, f64);
f64 w2c_hermes_tanh(w2c_hermes*, f64);
f64 w2c_hermes_tan(w2c_hermes*, f64);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28std0x3A0x3A_0x5F20x3A0x3Aerror_code0x20const0x260x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Aequivalent0x28int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_condition0x20const0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3Aerror_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_specific_ptr0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fthread_struct0x3E0x3A0x3A_0x5Fat_thread_exit0x28void0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fsystem_error_category0x3A0x3Adefault_error_condition0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Avm0x3A0x3ANopCrashManager0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3ACrashManager0x3E0x3A0x3A_0x5Fshared_ptr_default_delete0x3Chermes0x3A0x3Avm0x3A0x3ACrashManager0x2C0x20hermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ANopCrashManager0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Ahbc0x3A0x3ABackendContext0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABackendContext0x3E0x3A0x3A_0x5Fshared_ptr_default_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABackendContext0x2C0x20hermes0x3A0x3Ahbc0x3A0x3ABackendContext0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ABackendContext0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_pointer0x3Chermes0x3A0x3ASourceMap0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3ASourceMap0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceMap0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Amutex0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AHeapSegment0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3APreParser0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aparser0x3A0x3Adetail0x3A0x3AJSParserImpl0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCallsContext0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASourceMapTranslator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceMapTranslator0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASourceMapTranslator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceMapTranslator0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASourceMapTranslator0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASourceMapTranslator0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3ASerializedScope0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3ASerializedScope0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3AContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AContext0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3AContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AContext0x3E0x3E0x3A0x3A0x7E_0x5Fshared_ptr_emplace0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fshared_ptr_emplace0x3Chermes0x3A0x3AContext0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3AContext0x3E0x3E0x3A0x3A_0x5Fon_zero_shared0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Fgeneric_error_category0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3A0x7E_0x5Ffunc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AFunction0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3Adestroy_deallocate0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3Adestroy0x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cstd0x3A0x3A_0x5F20x3A0x3Afunction0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3Aoperator0x280x290x28unsigned0x20int0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Chermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AinitNativeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3Aoperator0x280x290x28unsigned0x20int0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Chermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreezeBuiltins0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3Aoperator0x280x290x28unsigned0x20int0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x260x260x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Chermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AassertBuiltinsUnmodified0x280x290x3A0x3A0x24_00x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AExecutionStatus0x200x28unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3APredefined0x3A0x3AStr0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ASymbolID0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28int0x290x3E0x3A0x3Aoperator0x280x290x28int0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28int0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28int0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3ARuntime0x28std0x3A0x3A_0x5F20x3A0x3Ashared_ptr0x3Chermes0x3A0x3Avm0x3A0x3AStorageProvider0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28int0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x290x3A0x3A0x24_00x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda10x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20void0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda00x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3Aoperator0x280x290x280x29(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x280x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x290x3A0x3A0x27lambda0x270x280x290x3E0x2C0x20bool0x200x280x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenYieldStarExpr0x28hermes0x3A0x3AESTree0x3A0x3AYieldExpressionNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenTryStatement0x28hermes0x3A0x3AESTree0x3A0x3ATryStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x260x260x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x260x260x2C0x20hermes0x3A0x3ABasicBlock0x2A0x260x260x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Airgen0x3A0x3AESTreeIRGen0x3A0x3AgenForOfStatement0x28hermes0x3A0x3AESTree0x3A0x3AForOfStatementNode0x2A0x290x3A0x3A0x24_00x3A0x3Aoperator0x280x290x280x290x20const0x3A0x3A0x27lambda0x270x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x2C0x20void0x200x28hermes0x3A0x3AESTree0x3A0x3ANode0x2A0x2C0x20hermes0x3A0x3Airgen0x3A0x3AControlFlowChange0x2C0x20hermes0x3A0x3ABasicBlock0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3Aoperator0x280x290x28llvh0x3A0x3AStringRef0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28llvh0x3A0x3AStringRef0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_40x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3Aoperator0x280x290x28llvh0x3A0x3AStringRef0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28llvh0x3A0x3AStringRef0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_30x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x2C0x20bool0x290x3E0x3A0x3Aoperator0x280x290x28llvh0x3A0x3AStringRef0x260x260x2C0x20bool0x260x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x2C0x20bool0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28llvh0x3A0x3AStringRef0x2C0x20bool0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_20x3E0x2C0x20void0x200x28llvh0x3A0x3AStringRef0x2C0x20bool0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_10x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_10x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_10x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_10x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3AFunction0x20const0x2A0x260x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cbool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Chermes0x3A0x3Ahbc0x3A0x3AgenerateBytecodeModule0x28hermes0x3A0x3AModule0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3AFunction0x2A0x2C0x20hermes0x3A0x3ABytecodeGenerationOptions0x20const0x260x2C0x20hermes0x3A0x3AOptValue0x3Cunsigned0x20int0x3E0x2C0x20hermes0x3A0x3ASourceMapGenerator0x2A0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aunique_ptr0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x2C0x20std0x3A0x3A_0x5F20x3A0x3Adefault_delete0x3Chermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3E0x3E0x290x3A0x3A0x24_00x3E0x2C0x20bool0x200x28hermes0x3A0x3AFunction0x20const0x2A0x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x3A0x3Aoperator0x280x290x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x260x260x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x3A0x3A_0x5Fclone0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Fbase0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_std0x3A0x3A_0x5F20x3A0x3A_0x5Ffunction0x3A0x3A_0x5Ffunc0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3C0x28anonymous0x20namespace0x290x3A0x3AHermesABIRuntimeImpl0x3A0x3AHermesABIRuntimeImpl0x28hermes0x3A0x3Avm0x3A0x3ARuntimeConfig0x20const0x260x290x3A0x3A0x27lambda0x270x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x2C0x20void0x200x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARootAcceptor0x260x290x3E0x3A0x3A_0x5Fclone0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_stackSave_0(w2c_hermes*);
void w2c_hermes_stackRestore_0(w2c_hermes*, u32);
u32 w2c_hermes_stackAlloc_0(w2c_hermes*, u32);
f64 w2c_hermes_sqrt(w2c_hermes*, f64);
u32 w2c_hermes_sn_write(w2c_hermes*, u32, u32, u32);
f64 w2c_hermes_sinh(w2c_hermes*, f64);
f64 w2c_hermes_sin(w2c_hermes*, f64);
void w2c_hermes_pop_arg_long_double(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3A0x7ERuntime0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3A0x7ERuntime0x280x29(w2c_hermes*, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AvisitIdentifiers0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AunmarkSymbols0x280x29(w2c_hermes*, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AprintRuntimeGCStats0x28hermes0x3A0x3AJSONEmitter0x260x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AonGCEvent0x28hermes0x3A0x3Avm0x3A0x3AGCEventKind0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmarkWeakRoots0x28hermes0x3A0x3Avm0x3A0x3AWeakRootAcceptor0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmarkRoots0x28hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x260x2C0x20bool0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmallocSize0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetSymbolsEnd0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCurrentIPSlow0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCallStackNoAlloc0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreeSymbols0x28llvh0x3A0x3ABitVector0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AconvertSymbolToUTF80x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCSymbolID0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3A0x7EMarkAcceptor0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3A0x7EMarkAcceptor0x280x29(w2c_hermes*, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCSymbolID0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3AacceptWeak0x28hermes0x3A0x3Avm0x3A0x3AWeakRootBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_non0x2Dvirtual0x20thunk0x20to0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3AacceptWeak0x28hermes0x3A0x3Avm0x3A0x3AWeakRootBase0x260x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_log2(w2c_hermes*, f64);
f64 w2c_hermes_log10(w2c_hermes*, f64);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3A0x7Eraw_svector_ostream0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Apwrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u32, u64);
u64 w2c_hermes_llvh0x3A0x3Araw_svector_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3A0x7Eraw_string_ostream0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_string_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3Ahas_colors0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_ostream0x3A0x3AchangeColor0x28llvh0x3A0x3Araw_ostream0x3A0x3AColors0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3A0x7Eraw_fd_ostream0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Awrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AreverseColor0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AresetColor0x280x29(w2c_hermes*, u32);
void w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Apwrite_impl0x28char0x20const0x2A0x2C0x20unsigned0x20long0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u32, u32, u64);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Ais_displayed0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Ahas_colors0x280x290x20const(w2c_hermes*, u32);
u64 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3Acurrent_pos0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_llvh0x3A0x3Araw_fd_ostream0x3A0x3AchangeColor0x28llvh0x3A0x3Araw_ostream0x3A0x3AColors0x2C0x20bool0x2C0x20bool0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cint0x2C0x20int0x2C0x20int0x2C0x20int0x2C0x20char0x2C0x20int0x2C0x20int0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cint0x2C0x20int0x2C0x20int0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cint0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3Aformat_object0x3Cchar0x2C0x20int0x2C0x20int0x3E0x3A0x3Asnprint0x28char0x2A0x2C0x20unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralNumber0x3E0x3A0x3ANodeEquals0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x20const0x260x2C0x20unsigned0x20int0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralNumber0x3E0x3A0x3AGetNodeProfile0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_llvh0x3A0x3AFoldingSet0x3Chermes0x3A0x3ALiteralNumber0x3E0x3A0x3AComputeNodeHash0x28llvh0x3A0x3AFoldingSetBase0x3A0x3ANode0x2A0x2C0x20llvh0x3A0x3AFoldingSetNodeID0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakSetPrototypeHas0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakSetPrototypeDelete0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakSetPrototypeAdd0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakSetConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakRefPrototypeDeref0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakRefConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakMapPrototypeSet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakMapPrototypeHas0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakMapPrototypeGet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakMapPrototypeDelete0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AweakMapConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AuriUnescaped0x28char16_t0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AunescapedURISet0x28char16_t0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aunescape0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeToLocaleString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeSymbolToStringTag0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeSubarray0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeSort0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeSlice0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeSet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeReverse0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeReduce0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeMapFilter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeLength0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeJoin0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeIterator0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeIndexOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeForEach0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeFind0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeFindLast0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeFill0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeEverySome0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeCopyWithin0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeByteOffset0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeByteLength0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeBuffer0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayPrototypeAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayFrom0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtypedArrayBaseConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AtimeTZString0x28double0x2C0x20double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, f64, f64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AthrowTypeError0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3Atesthelpers0x3A0x3ADummyObject0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Atesthelpers0x3A0x3ADummyObject0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolPrototypeValueOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolPrototypeDescriptionGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolKeyFor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolFor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsymbolConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringRaw0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeTrim0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeTrimStart0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeTrimEnd0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeToUpperCase0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeToLowerCase0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeToLocaleUpperCase0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeToLocaleLowerCase0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSymbolIterator0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSubstring0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSubstr0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSplit0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSlice0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeSearch0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeReplace0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeReplaceAll0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeRepeat0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypePad0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeNormalize0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeMatch0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeMatchAll0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeLocaleCompare0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeLastIndexOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeIndexOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeIncludesOrStartsWith0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeEndsWith0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeConcat0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeCodePointAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeCharCodeAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeCharAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringPrototypeAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringIteratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringFromCodePoint0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringFromCharCode0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AstringConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsilentObjectSetPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeValues0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeSizeGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeHas0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeForEach0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeEntries0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeDelete0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeClear0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetPrototypeAdd0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetIteratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AsetConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ArunContextFunc2Arg0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ArunContextFunc1Arg0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
f64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AroundHalfwaysTowardsInfinity0x28double0x29(w2c_hermes*, f64);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreservedURISet0x28char16_t0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Arequire0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ArequireFast0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpStringIteratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpSourceGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpRightContextGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeTest0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeSymbolSplit0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeSymbolSearch0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeSymbolReplace0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeSymbolMatch0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpPrototypeSymbolMatchAll0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpLeftContextGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpLastParenGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpLastMatchGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpInputGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpFlagsGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpFlagPropertyGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpDollarNumberGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AregExpConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectSet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectSetPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectPreventExtensions0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectOwnKeys0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectIsExtensible0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectHas0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectGet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectGetPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectGetOwnPropertyDescriptor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectDeleteProperty0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectDefineProperty0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectConstruct0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AreflectApply0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AproxyRevocationSteps0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AproxyRevocable0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AproxyConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aprint0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseInt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AparseFloat0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectValues0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectSetPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectSeal0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeValueOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeToLocaleString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeProto_setter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeProto_getter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypePropertyIsEnumerable0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeLookupSetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeLookupGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeIsPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeHasOwnProperty0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeDefineSetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPrototypeDefineGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectPreventExtensions0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectKeys0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectIs0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectIsSealed0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectIsFrozen0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectIsExtensible0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectHasOwn0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectGetPrototypeOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectGetOwnPropertySymbols0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectGetOwnPropertyNames0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectGetOwnPropertyDescriptors0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectGetOwnPropertyDescriptor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectFromEntries0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectFreeze0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectEntries0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectDefineProperty0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectDefineProperties0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectCreate0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AobjectAssign0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeValueOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeToPrecision0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeToLocaleString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeToFixed0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberPrototypeToExponential0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberIsSafeInteger0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberIsNaN0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberIsInteger0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberIsFinite0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AnumberConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathSign0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathRandom0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathPow0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathMin0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathMax0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathImul0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathHypot0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathFround0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmathClz320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeValues0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeSizeGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeSet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeKeys0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeHas0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeGet0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeForEach0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeEntries0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeDelete0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapPrototypeClear0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapIteratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AmapConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AjsonStringify0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AjsonParse0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AiteratorPrototypeIterator0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisNaN0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AisFinite0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalUseEngineQueue0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalTTIReached0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalSetPromiseRejectionTrackingHook0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalIsProxy0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalIsLazy0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalHasPromise0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalHasES6Class0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetWeakSize0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetRuntimeProperties0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetInstrumentedStats0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetFunctionLocation0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalGetEpilogues0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalEnqueueJob0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalEnablePromiseRejectionTracker0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalDrainJobs0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesInternalDetachArrayBuffer0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinThrowTypeError0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinInitRegexNamedGroups0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinGetTemplateObject0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinGetOriginalNativeErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinGetMethod0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinGeneratorSetDelegated0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinExportAll0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinExponentiate0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinEnsureObject0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinCopyRestArgs0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinCopyDataProperties0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinArraySpread0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AhermesBuiltinApply0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgeneratorPrototypeReturnOrThrow0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgeneratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AgeneratorFunctionConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Agc0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionPrototypeSymbolHasInstance0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionPrototypeCall0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionPrototypeBind0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionPrototypeApply0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AfunctionConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aeval0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aescape0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AerrorStackSetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AerrorStackGetter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AerrorPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AerrorCaptureStackTrace0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AencodeURI0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AencodeURIComponent0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdecodeURI0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdecodeURIComponent0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatetimeToISOString0x28double0x2C0x20double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, f64, f64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateUTC_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateTimeUTCString0x28double0x2C0x20double0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar0x3E0x260x29(w2c_hermes*, f64, f64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeToStringHelper0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeToLocaleStringHelper0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeToJSON_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSymbolToPrimitive0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetYear_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetTime_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetSeconds_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetMonth_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetMinutes_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetMilliseconds_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetHours_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetFullYear_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeSetDate_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeGetterHelper0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdatePrototypeGetTime0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateParse_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateNow0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdateConstructor_RJS0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetFloat640x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeSetFloat320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetUint80x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetUint320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetUint160x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetInt80x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetInt320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetInt160x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetFloat640x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetFloat320x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetBigUint640x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeGetBigInt640x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeByteOffset0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeByteLength0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewPrototypeBuffer0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AdataViewConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeIsNative0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetLineNumber0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetFunctionName0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetFileName0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetColumnNumber0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AcallSitePrototypeGetBytecodeAddress0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Abtoa0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbooleanPrototypeValueOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbooleanPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbooleanConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbigintTruncate0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbigintPrototypeValueOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbigintPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbigintPrototypeToLocaleString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AbigintConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3Aatob0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AasyncFunctionConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeWith0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeUnshift0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeToString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeToSpliced0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeToReversed0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeToLocaleString0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeSplice0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeSort0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeSome0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeSlice0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeShift0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeReverse0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeReduce0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeReduceRight0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypePush0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypePop0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeMap0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeLastIndexOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeJoin0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeIterator0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeIndexOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeIncludes0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeForEach0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFlat0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFlatMap0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFind0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFindLast0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFilter0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeFill0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeEvery0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeCopyWithin0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeConcat0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayPrototypeAt0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayOf0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayIteratorPrototypeNext0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayIsArray0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayFrom0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayBufferPrototypeSlice0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayBufferPrototypeByteLength0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayBufferIsView0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AarrayBufferConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AVMAllocateStorageProvider0x3A0x3AnewStorageImpl0x28char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AVMAllocateStorageProvider0x3A0x3AdeleteStorageImpl0x28void0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Ctrue0x3E0x3A0x3A0x7ETypedArraySortModel0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Ctrue0x3E0x3A0x3A0x7ETypedArraySortModel0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Ctrue0x3E0x3A0x3Acompare0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Cfalse0x3E0x3A0x3A0x7ETypedArraySortModel0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Cfalse0x3E0x3A0x3A0x7ETypedArraySortModel0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ATypedArraySortModel0x3Cfalse0x3E0x3A0x3Acompare0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStandardSortModel0x3A0x3A0x7EStandardSortModel0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStandardSortModel0x3A0x3A0x7EStandardSortModel0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStandardSortModel0x3A0x3Aswap0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3AStandardSortModel0x3A0x3Acompare0x28unsigned0x20int0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AURIErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ATypeErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ATimeoutErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ASyntaxErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AStorageProvider0x3A0x3A0x7EStorageProvider0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3A0x7ERuntime0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AvisitIdentifiers0x28std0x3A0x3A_0x5F20x3A0x3Afunction0x3Cvoid0x200x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AStringPrimitive0x20const0x2A0x290x3E0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AunmarkSymbols0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AonGCEvent0x28hermes0x3A0x3Avm0x3A0x3AGCEventKind0x2C0x20std0x3A0x3A_0x5F20x3A0x3Abasic_string0x3Cchar0x2C0x20std0x3A0x3A_0x5F20x3A0x3Achar_traits0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aallocator0x3Cchar0x3E0x3E0x20const0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AmallocSize0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetSymbolsEnd0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCurrentIPSlow0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AgetCallStackNoAlloc0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AfreeSymbols0x28llvh0x3A0x3ABitVector0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARuntime0x3A0x3AconvertSymbolToUTF80x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3ARootSymbolID0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCSymbolID0x20const0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARootAndSlotAcceptorWithNames0x3A0x3AacceptNullable0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AReferenceErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ARangeErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AQuitErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeState0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeFunction0x3A0x3A_newObjectImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeFunction0x3A0x3A_callImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3A_newObjectImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakRef0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSWeakMapImplBase0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3A_haveOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3A_getOwnIndexedRangeImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3A_getOwnIndexedPropertyFlagsImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3A_deleteOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3A0x3A_checkAllOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AObjectVTable0x3A0x3ACheckAllOwnIndexedMode0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20short0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29400x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20short0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29400x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20short0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29400x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20long0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29450x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20long0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29450x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20long0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29450x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20int0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29410x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20int0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29410x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20int0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29410x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29390x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29390x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29390x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29380x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Csigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29350x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Csigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29350x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Csigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29350x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cshort0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29360x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cshort0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29360x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cshort0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29360x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Clong0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29440x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Clong0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29440x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Clong0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29440x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cint0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29370x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cint0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29370x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cint0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29370x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cfloat0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29420x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cfloat0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29420x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cfloat0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29420x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cfloat0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29420x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cdouble0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29430x3E0x3A0x3Aallocate0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cdouble0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29430x3E0x3A0x3AallocateSpecies0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArrayBase0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cdouble0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29430x3E0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cdouble0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29430x3E0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_haveOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_getOwnIndexedRangeImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_getOwnIndexedPropertyFlagsImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSString0x3A0x3A_deleteOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSRegExp0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3A_setOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3A_getOwnIndexedRangeImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3A_getOwnIndexedPropertyFlagsImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSObject0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSFunction0x3A0x3A_callImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSError0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSCallableProxy0x3A0x3A_proxyNativeCall0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSCallableProxy0x3A0x3A_newObjectImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHiddenClass0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3A0x7EHadesGC0x280x290x2E1(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AttiReached0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AprintStats0x28hermes0x3A0x3AJSONEmitter0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AinYoungGen0x28void0x20const0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AgetCrashManagerHeapInfo0x28hermes0x3A0x3Avm0x3A0x3ACrashManager0x3A0x3AHeapInformation0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AcanAllocExternalMemory0x28unsigned0x20int0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkWeakRootsAcceptor0x3A0x3AacceptWeak0x28hermes0x3A0x3Avm0x3A0x3AWeakRootBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3A0x7EMarkAcceptor0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3A0x7EMarkAcceptor0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3A0x3AacceptNullable0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3A0x3AacceptWeak0x28hermes0x3A0x3Avm0x3A0x3AWeakRootBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3A0x3AacceptWeak0x28hermes0x3A0x3Avm0x3A0x3AWeakRootBase0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGeneratorInnerFunction0x3A0x3A_callImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AoomDetail0x28llvh0x3A0x3AMutableArrayRef0x3Cchar0x3E0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aerror_code0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AgetPeakLiveAfterGC0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AgetPeakAllocatedBytes0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AgetHeapInfo0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AgetHeapInfoWithMallocSize0x28hermes0x3A0x3Avm0x3A0x3AGCBase0x3A0x3AHeapInfo0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AFinalizableNativeFunction0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar0x3E0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AExternalStringPrimitive0x3Cchar16_t0x3E0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AEvalErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AMarkAcceptor0x3E0x3A0x3AacceptNullable0x28hermes0x3A0x3Avm0x3A0x3APinnedHermesValue0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue0x3E0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Ctrue0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCPointerBase0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCHermesValueBase0x3Chermes0x3A0x3Avm0x3A0x3AHermesValue320x3E0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADroppingAcceptor0x3Chermes0x3A0x3Avm0x3A0x3AHadesGC0x3A0x3AEvacAcceptor0x3Cfalse0x3E0x3E0x3A0x3Aaccept0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x260x2C0x20char0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADomain0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADomain0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADecoratedObject0x3A0x3A_mallocSizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ADecoratedObject0x3A0x3A_finalizeImpl0x28hermes0x3A0x3Avm0x3A0x3AGCCell0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallable0x3A0x3A_newObjectImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakRef0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29520x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSWeakMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29510x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20short0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29400x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20long0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29450x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20int0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29410x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29390x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cunsigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29380x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Csigned0x20char0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29350x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cshort0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29360x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Clong0x20long0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29440x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cint0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29370x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cfloat0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29420x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSTypedArray0x3Cdouble0x2C0x200x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29430x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSSymbol0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSString0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSRegExp0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSProxy0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSNumber0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29480x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSMapImpl0x3C0x28hermes0x3A0x3Avm0x3A0x3ACellKind0x29470x3E0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSGeneratorFunction0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSFunction0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSError0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSDate0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSDataView0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSBoolean0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSBigInt0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSAsyncFunction0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSArrayBuffer0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ACallResult0x3Chermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x200x28hermes0x3A0x3Avm0x3A0x3Adetail0x3A0x3ACallResultSpecialize0x2960x3E0x20hermes0x3A0x3Avm0x3A0x3ANativeConstructor0x3A0x3AcreatorFunction0x3Chermes0x3A0x3Avm0x3A0x3AJSArray0x3E0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20void0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABoundFunction0x3A0x3A_newObjectImpl_RJS0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABoundFunction0x3A0x3A_callImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ACallable0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AunsignedRightShift0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3Asubtract0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AsignedRightShift0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3Aremainder0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3Amultiply0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AleftShift0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3Adivide0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AbitwiseXOR0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AbitwiseOR0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AbitwiseAND0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AasUintN0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20long0x20long0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u64, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3A0x3AasIntN0x28hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20long0x20long0x2C0x20hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3ABigIntPrimitive0x3E0x29(w2c_hermes*, u32, u32, u64, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_haveOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_getOwnIndexedRangeImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_getOwnIndexedPropertyFlagsImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
u64 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_getOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3APseudoHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_deleteOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AHandle0x3Chermes0x3A0x3Avm0x3A0x3AJSObject0x3E0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Avm0x3A0x3AArrayImpl0x3A0x3A_checkAllOwnIndexedImpl0x28hermes0x3A0x3Avm0x3A0x3AJSObject0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3AObjectVTable0x3A0x3ACheckAllOwnIndexedMode0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Avm0x3A0x3AAggregateErrorConstructor0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AWordBoundaryNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ARightAnchorNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ANode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3A0x7EMatchCharNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3A0x7EMatchCharNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AtryCoalesceCharacters0x28llvh0x3A0x3ASmallVector0x3Cunsigned0x20int0x2C0x205u0x3E0x2A0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchCharNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMatchAnyNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3A0x7EMarkedSubexpressionNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3A0x7EMarkedSubexpressionNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AMarkedSubexpressionNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3A0x7ELoopNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3A0x7ELoopNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALoopNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3A0x7ELookaroundNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3A0x7ELookaroundNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALookaroundNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ALeftAnchorNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AGoalNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7EBracketNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3A0x7EBracketNode0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AmatchesExactlyOneCharacter0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABracketNode0x3Chermes0x3A0x3Aregex0x3A0x3AUTF16RegexTraits0x3E0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3ABackRefNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3A0x7EAlternationNode0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3A0x7EAlternationNode0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AreverseChildren0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AmatchConstraints0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AgetChildren0x280x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aregex0x3A0x3AAlternationNode0x3A0x3AemitStep0x28hermes0x3A0x3Aregex0x3A0x3ARegexBytecodeStream0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Aplatform_unicode0x3A0x3AdateFormat0x28double0x2C0x20bool0x2C0x20bool0x2C0x20llvh0x3A0x3ASmallVectorImpl0x3Cchar16_t0x3E0x260x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Aoscompat0x3A0x3Avm_madvise0x28void0x2A0x2C0x20unsigned0x20long0x2C0x20hermes0x3A0x3Aoscompat0x3A0x3AMAdvice0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Aoom_category0x280x290x3A0x3AOOMErrorCategory0x3A0x3Aname0x280x290x20const(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Aoom_category0x280x290x3A0x3AOOMErrorCategory0x3A0x3Amessage0x28int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3Awarmup0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20int0x2C0x20std0x3A0x3A_0x5F20x3A0x3Aatomic0x3Cbool0x3E0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ASpillRegisters0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ARecreateCheapValues0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AOptEnvironmentInit0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerSwitchIntoJumpTables0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerLoadStoreFrameInst0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerConstruction0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerCalls0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerBuiltinCalls0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALowerArgumentsArray0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALoadParameters0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALoadConstants0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ALoadConstantValueNumbering0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AInsertProfilePoint0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHVMRegisterAllocator0x3A0x3AhasTargetSpecificLowering0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHVMRegisterAllocator0x3A0x3AhandleInstruction0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHVMRegisterAllocator0x3A0x3AgetMaxRegisterUsage0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3AHBCISel0x3A0x3Agenerate0x28hermes0x3A0x3ASourceMapGenerator0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ADedupReifyArguments0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3A0x7EBCProviderLazy0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AgetStringTableEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AgetFunctionHeader0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AgetExceptionTable0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AgetDebugOffsets0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AgetBytecode0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderLazy0x3A0x3AcreateDebugInfo0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3A0x7EBCProviderFromSrc0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3A0x7EBCProviderFromSrc0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AisFunctionLazy0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetStringTableEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetSourceHash0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetFunctionHeader0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetExceptionTable0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetDebugOffsets0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromSrc0x3A0x3AgetBytecode0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3A0x7EBCProviderFromBuffer0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AwillNeedStringTable0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AstartWarmup0x28unsigned0x20char0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AstartPageAccessTracker0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3Amadvise0x28hermes0x3A0x3Aoscompat0x3A0x3AMAdvice0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetStringTableEntry0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetSourceHash0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetRawBuffer0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetPageAccessTracker0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetFunctionHeader0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetExceptionTable0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetEpilogue0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetDebugOffsets0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AgetBytecode0x28unsigned0x20int0x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AcreateDebugInfo0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AadviseStringTableSequential0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderFromBuffer0x3A0x3AadviseStringTableRandom0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3A0x3A0x7EBCProviderBase0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3Ahbc0x3A0x3ABCProviderBase0x3A0x3AgetSourceHash0x280x290x20const(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3A0x7EDumpModule0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3A0x7EDumpModule0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpModule0x3A0x3ArunOnModule0x28hermes0x3A0x3AModule0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3A0x7EDumpFunction0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3A0x7EDumpFunction0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3A0x28anonymous0x20namespace0x290x3A0x3ADumpFunction0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ASwitchLowering0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceMapTranslator0x3A0x3A0x7ESourceMapTranslator0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ASourceMapTranslator0x3A0x3A0x7ESourceMapTranslator0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3ASourceMapTranslator0x3A0x3Atranslate0x28hermes0x3A0x3ASourceErrorManager0x3A0x3ASourceCoords0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASourceErrorManager0x3A0x3AprintDiagnostic0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20void0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3ASimpleDiagHandler0x3A0x3Ahandler0x28llvh0x3A0x3ASMDiagnostic0x20const0x260x2C0x20void0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ARegisterAllocator0x3A0x3AgetMaxRegisterUsage0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AOwnedMemoryBuffer0x3A0x3A0x7EOwnedMemoryBuffer0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AOwnedMemoryBuffer0x3A0x3A0x7EOwnedMemoryBuffer0x280x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AMovElimination0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALowerStoreInstrs0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALowerNumericProperties0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALowerExponentiationOperator0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALowerCondBranch0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALowerAllocObject0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ALimitAllocArray0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3A0x7EIRPrinter0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintTypeLabel0x28hermes0x3A0x3AType0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintSourceLocation0x28llvh0x3A0x3ASMRange0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintSourceLocation0x28llvh0x3A0x3ASMLoc0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintInstruction0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionVariables0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AIRPrinter0x3A0x3AprintFunctionHeader0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AHoistStartGenerator0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_hermes0x3A0x3AHermesLLVMMemoryBuffer0x3A0x3A0x7EHermesLLVMMemoryBuffer0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3AHermesLLVMMemoryBuffer0x3A0x3A0x7EHermesLLVMMemoryBuffer0x280x29(w2c_hermes*, u32);
void w2c_hermes_hermes0x3A0x3AHermesLLVMMemoryBuffer0x3A0x3AgetBufferIdentifier0x280x290x20const(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AFuncCallNOpts0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3AESTree0x3A0x3AgetCallee0x28hermes0x3A0x3AESTree0x3A0x3ACallExpressionLikeNode0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_hermes0x3A0x3ADCE0x3A0x3ArunOnModule0x28hermes0x3A0x3AModule0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACodeMotion0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_hermes0x3A0x3ACSE0x3A0x3ArunOnFunction0x28hermes0x3A0x3AFunction0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_get_hermes_abi_vtable_0(w2c_hermes*);
u32 w2c_hermes_fmt_fp(w2c_hermes*, u32, f64, u32, u32, u32, u32);
f64 w2c_hermes_floor(w2c_hermes*, f64);
f64 w2c_hermes_fabs(w2c_hermes*, f64);
u32 w2c_hermes_dlposix_memalign(w2c_hermes*, u32, u32, u32);
void w2c_hermes_demangling_terminate_handler0x280x29(w2c_hermes*);
void w2c_hermes_decltype0x28auto0x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fvisitation0x3A0x3A_0x5Fbase0x3A0x3A_0x5Fdispatcher0x3C2ul0x3E0x3A0x3A_0x5Fdispatch0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fdtor0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Ftraits0x3Cstd0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x2C0x200x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x3E0x3A0x3A_0x5Fdestroy0x5Babi0x3Av150070x5D0x280x290x3A0x3A0x27lambda0x270x28auto0x260x290x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x3E0x28auto0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x29(w2c_hermes*, u32, u32);
void w2c_hermes_decltype0x28auto0x290x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fvisitation0x3A0x3A_0x5Fbase0x3A0x3A_0x5Fdispatcher0x3C1ul0x3E0x3A0x3A_0x5Fdispatch0x5Babi0x3Av150070x5D0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fdtor0x3Cstd0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Ftraits0x3Cstd0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x2C0x200x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x3E0x3A0x3A_0x5Fdestroy0x5Babi0x3Av150070x5D0x280x290x3A0x3A0x27lambda0x270x28auto0x260x290x260x260x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x3E0x28auto0x2C0x20std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_0x5Fbase0x3C0x28std0x3A0x3A_0x5F20x3A0x3A_0x5Fvariant_detail0x3A0x3A_Trait0x2910x2C0x20std0x3A0x3A_0x5F20x3A0x3Amonostate0x2C0x20hermes0x3A0x3AScopedHashTableScope0x3Chermes0x3A0x3AIdentifier0x2C0x20hermes0x3A0x3AValue0x2A0x3E0x2C0x20hermes0x3A0x3Airgen0x3A0x3AEnterBlockScope0x3E0x260x29(w2c_hermes*, u32, u32);
f64 w2c_hermes_cosh(w2c_hermes*, f64);
f64 w2c_hermes_cos(w2c_hermes*, f64);
f64 w2c_hermes_ceil(w2c_hermes*, f64);
f64 w2c_hermes_cbrt(w2c_hermes*, f64);
f64 w2c_hermes_atanh(w2c_hermes*, f64);
f64 w2c_hermes_asinh(w2c_hermes*, f64);
f64 w2c_hermes_asin(w2c_hermes*, f64);
f64 w2c_hermes_acosh(w2c_hermes*, f64);
f64 w2c_hermes_acos(w2c_hermes*, f64);
void w2c_hermes_0x5Finitialize_0(w2c_hermes*);
u32 w2c_hermes_0x5F_stdio_write(w2c_hermes*, u32, u32, u32);
u64 w2c_hermes_0x5F_stdio_seek(w2c_hermes*, u32, u64, u32);
u32 w2c_hermes_0x5F_stdio_close(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fsi_class_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_below_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Asearch_above_dst0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x20const0x2A0x2C0x20void0x20const0x2A0x2C0x20int0x2C0x20bool0x290x20const(w2c_hermes*, u32, u32, u32, u32, u32, u32);
void w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Ahas_unambiguous_public_base0x28_0x5Fcxxabiv10x3A0x3A_0x5Fdynamic_cast_info0x2A0x2C0x20void0x2A0x2C0x20int0x290x20const(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x5F_cxxabiv10x3A0x3A_0x5Fclass_type_info0x3A0x3Acan_catch0x28_0x5Fcxxabiv10x3A0x3A_0x5Fshim_type_info0x20const0x2A0x2C0x20void0x2A0x260x290x20const(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E6(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E4(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor0x2E3(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxx_global_array_dtor(w2c_hermes*, u32);
void w2c_hermes_0x5F_cxa_pure_virtual(w2c_hermes*);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Astrict_equals_string0x28HermesABIRuntime0x2A0x2C0x20HermesABIString0x2C0x20HermesABIString0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Astrict_equals_bigint0x28HermesABIRuntime0x2A0x2C0x20HermesABIBigInt0x2C0x20HermesABIBigInt0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_object_property_from_value0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIValue0x20const0x2A0x2C0x20HermesABIValue0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_object_property_from_propnameid0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIPropNameID0x2C0x20HermesABIValue0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_object_external_memory_pressure0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20unsigned0x20long0x290x3A0x3A0x24_00x3A0x3A_0x5Finvoke0x28hermes0x3A0x3Avm0x3A0x3AHadesGC0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeState0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_object_external_memory_pressure0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_native_state0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABINativeState0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_native_exception_message0x28HermesABIRuntime0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aset_js_error_value0x28HermesABIRuntime0x2A0x2C0x20HermesABIValue0x20const0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Arelease_hermes_runtime0x28HermesABIRuntime0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aobject_is_function0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aobject_is_arraybuffer0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aobject_is_array0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Amake_hermes_runtime0x28HermesABIRuntimeConfig0x20const0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Alock_weak_object0x28HermesABIRuntime0x2A0x2C0x20HermesABIWeakObject0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Ais_hermes_bytecode0x28unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Ainstance_of0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIFunction0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Ahas_object_property_from_value0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIValue0x20const0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Ahas_object_property_from_propnameid0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIPropNameID0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_utf8_from_symbol0x28HermesABIRuntime0x2A0x2C0x20HermesABISymbol0x2C0x20HermesABIGrowableBuffer0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_utf8_from_string0x28HermesABIRuntime0x2A0x2C0x20HermesABIString0x2C0x20HermesABIGrowableBuffer0x2A0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_utf8_from_propnameid0x28HermesABIRuntime0x2A0x2C0x20HermesABIPropNameID0x2C0x20HermesABIGrowableBuffer0x2A0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_object_property_names0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_object_property_from_value0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIValue0x20const0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_object_property_from_propnameid0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x2C0x20HermesABIPropNameID0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_native_state0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_host_object0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_host_function0x28HermesABIRuntime0x2A0x2C0x20HermesABIFunction0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_global_object0x28HermesABIRuntime0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_arraybuffer_size0x28HermesABIRuntime0x2A0x2C0x20HermesABIArrayBuffer0x29(w2c_hermes*, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_arraybuffer_data0x28HermesABIRuntime0x2A0x2C0x20HermesABIArrayBuffer0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_array_length0x28HermesABIRuntime0x2A0x2C0x20HermesABIArray0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_and_clear_native_exception_message0x28HermesABIRuntime0x2A0x2C0x20HermesABIGrowableBuffer0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aget_and_clear_js_error_value0x28HermesABIRuntime0x2A0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aevaluate_javascript_source0x28HermesABIRuntime0x2A0x2C0x20HermesABIBuffer0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Aevaluate_hermes_bytecode0x28HermesABIRuntime0x2A0x2C0x20HermesABIBuffer0x2A0x2C0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Adrain_microtasks0x28HermesABIRuntime0x2A0x2C0x20int0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_weak_object0x28HermesABIRuntime0x2A0x2C0x20HermesABIObject0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_string_from_utf80x28HermesABIRuntime0x2A0x2C0x20unsigned0x20char0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_propnameid_from_symbol0x28HermesABIRuntime0x2A0x2C0x20HermesABISymbol0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_propnameid_from_string0x28HermesABIRuntime0x2A0x2C0x20HermesABIString0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_object_from_host_object0x28HermesABIRuntime0x2A0x2C0x20HermesABIHostObject0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_object0x28HermesABIRuntime0x2A0x29(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_function_from_host_function0x28HermesABIRuntime0x2A0x2C0x20HermesABIPropNameID0x2C0x20unsigned0x20int0x2C0x20HermesABIHostFunction0x2A0x29(w2c_hermes*, u32, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_bigint_from_uint640x28HermesABIRuntime0x2A0x2C0x20unsigned0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_bigint_from_int640x28HermesABIRuntime0x2A0x2C0x20long0x20long0x29(w2c_hermes*, u32, u64);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_arraybuffer_from_external_data0x28HermesABIRuntime0x2A0x2C0x20HermesABIMutableBuffer0x2A0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acreate_array0x28HermesABIRuntime0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acall_as_constructor0x28HermesABIRuntime0x2A0x2C0x20HermesABIFunction0x2C0x20HermesABIValue0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Acall0x28HermesABIRuntime0x2A0x2C0x20HermesABIFunction0x2C0x20HermesABIValue0x20const0x2A0x2C0x20HermesABIValue0x20const0x2A0x2C0x20unsigned0x20long0x29(w2c_hermes*, u32, u32, u32, u32, u32, u32);
u64 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Abigint_truncate_to_uint640x28HermesABIRuntime0x2A0x2C0x20HermesABIBigInt0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Abigint_to_string0x28HermesABIRuntime0x2A0x2C0x20HermesABIBigInt0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Abigint_is_uint640x28HermesABIRuntime0x2A0x2C0x20HermesABIBigInt0x29(w2c_hermes*, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3Abigint_is_int640x28HermesABIRuntime0x2A0x2C0x20HermesABIBigInt0x29(w2c_hermes*, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostObjectWrapper0x3A0x3A0x7EHostObjectWrapper0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostObjectWrapper0x3A0x3A0x7EHostObjectWrapper0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostObjectWrapper0x3A0x3Aset0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x2C0x20hermes0x3A0x3Avm0x3A0x3AHermesValue0x29(w2c_hermes*, u32, u32, u32, u64);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostObjectWrapper0x3A0x3Aget0x28hermes0x3A0x3Avm0x3A0x3ASymbolID0x29(w2c_hermes*, u32, u32, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostObjectWrapper0x3A0x3AgetHostPropertyNames0x280x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostFunctionWrapper0x3A0x3Arelease0x28void0x2A0x29(w2c_hermes*, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3AHostFunctionWrapper0x3A0x3Acall0x28void0x2A0x2C0x20hermes0x3A0x3Avm0x3A0x3ARuntime0x260x2C0x20hermes0x3A0x3Avm0x3A0x3ANativeArgs0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ABufferWrapper0x3A0x3A0x7EBufferWrapper0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_0x28anonymous0x20namespace0x290x3A0x3ABufferWrapper0x3A0x3A0x7EBufferWrapper0x280x29(w2c_hermes*, u32);
void w2c_hermes_VectorBuffer0x3A0x3A0x7EVectorBuffer0x280x290x2E1(w2c_hermes*, u32);
u32 w2c_hermes_VectorBuffer0x3A0x3A0x7EVectorBuffer0x280x29(w2c_hermes*, u32);
void w2c_hermes_LivenessRegAllocIRPrinter0x3A0x3AprintValueLabel0x28hermes0x3A0x3AInstruction0x2A0x2C0x20hermes0x3A0x3AValue0x2A0x2C0x20unsigned0x20int0x29(w2c_hermes*, u32, u32, u32, u32);
void w2c_hermes_LivenessRegAllocIRPrinter0x3A0x3AprintInstructionDestination0x28hermes0x3A0x3AInstruction0x2A0x29(w2c_hermes*, u32, u32);

extern const u8 data_segment_data_w2c_hermes_0x2Erodata[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E1[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E2[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E3[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E4[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E5[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E6[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E7[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E8[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E9[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E10[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E11[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E12[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E13[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E14[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E15[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E16[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E17[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E18[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E19[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E20[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E21[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E22[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E23[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E24[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E25[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E26[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E27[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E28[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E29[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E30[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E31[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E32[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E33[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E34[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E35[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E36[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E37[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E38[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E39[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E40[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E41[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E42[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E43[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E44[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E45[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E46[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E47[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E48[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E49[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E50[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E51[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E52[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E53[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E54[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E55[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E56[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E57[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E58[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E59[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E60[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E61[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E62[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E63[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E64[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E65[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E66[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E67[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E68[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E69[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E70[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E71[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E72[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E73[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E74[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E75[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E76[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E77[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E78[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E79[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E80[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E81[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E82[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E83[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E84[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E85[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E86[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E87[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E88[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E89[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E90[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E91[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E92[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E93[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E94[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E95[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E96[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E97[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E98[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E99[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E100[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E101[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E102[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E103[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E104[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E105[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E106[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E107[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E108[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E109[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E110[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E111[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E112[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E113[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E114[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E115[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E116[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E117[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E118[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E119[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E120[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E121[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E122[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E123[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E124[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E125[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E126[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E127[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E128[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E129[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E130[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E131[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E132[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E133[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E134[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E135[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E136[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E137[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E138[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E139[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E140[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E141[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E142[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E143[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E144[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E145[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E146[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E147[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E148[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E149[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E150[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E151[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E152[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E153[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E154[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E155[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E156[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E157[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E158[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E159[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E160[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E161[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E162[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E163[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E164[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E165[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E166[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E167[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E168[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E169[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E170[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E171[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E172[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E173[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E174[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E175[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E176[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E177[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E178[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E179[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E180[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E181[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E182[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E183[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E184[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E185[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E186[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E187[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E188[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E189[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E190[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E191[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E192[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E193[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E194[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E195[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E196[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E197[];

extern const u8 data_segment_data_w2c_hermes_0x2Erodata0x2E198[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E1[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E2[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E3[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E4[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E5[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E6[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E7[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E8[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E9[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E10[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E11[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E12[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E13[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E14[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E15[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E16[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E17[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E18[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E19[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E20[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E21[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E22[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E23[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E24[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E25[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E26[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E27[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E28[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E29[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E30[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E31[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E32[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E33[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E34[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E35[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E36[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E37[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E38[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E39[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E40[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E41[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E42[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E43[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E44[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E45[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E46[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E47[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E48[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E49[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E50[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E51[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E52[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E53[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E54[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E55[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E56[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E57[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E58[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E59[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E60[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E61[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E62[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E63[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E64[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E65[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E66[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E67[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E68[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E69[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E70[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E71[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E72[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E73[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E74[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E75[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E76[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E77[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E78[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E79[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E80[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E81[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E82[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E83[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E84[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E85[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E86[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E87[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E88[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E89[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E90[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E91[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E92[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E93[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E94[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E95[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E96[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E97[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E98[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E99[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E100[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E101[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E102[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E103[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E104[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E105[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E106[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E107[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E108[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E109[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E110[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E111[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E112[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E113[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E114[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E115[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E116[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E117[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E118[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E119[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E120[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E121[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E122[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E123[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E124[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E125[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E126[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E127[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E128[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E129[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E130[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E131[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E132[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E133[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E134[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E135[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E136[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E137[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E138[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E139[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E140[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E141[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E142[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E143[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E144[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E145[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E146[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E147[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E148[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E149[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E150[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E151[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E152[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E153[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E154[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E155[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E156[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E157[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E158[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E159[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E160[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E161[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E162[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E163[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E164[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E165[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E166[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E167[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E168[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E169[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E170[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E171[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E172[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E173[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E174[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E175[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E176[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E177[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E178[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E179[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E180[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E181[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E182[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E183[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E184[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E185[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E186[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E187[];

extern const u8 data_segment_data_w2c_hermes_0x2Edata0x2E188[];

extern const wasm_elem_segment_expr_t elem_segment_exprs_w2c_hermes_e0[];
