/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.os.Build;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformCollator;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleObjectAndroid;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Locale;

public class PlatformCollatorAndroid
implements IPlatformCollator {
    private RuleBasedCollator mCollator;
    private LocaleObjectAndroid mLocale;

    PlatformCollatorAndroid() {
    }

    @Override
    public IPlatformCollator configure(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        this.mLocale = (LocaleObjectAndroid)localeObject;
        assert (Build.VERSION.SDK_INT < 24);
        this.mCollator = (RuleBasedCollator)RuleBasedCollator.getInstance(this.mLocale.getLocale());
        return this;
    }

    @Override
    public int compare(String source, String target) {
        return this.mCollator.compare(source, target);
    }

    @Override
    public IPlatformCollator.Sensitivity getSensitivity() {
        if (this.mCollator == null) {
            return IPlatformCollator.Sensitivity.LOCALE;
        }
        int strength = this.mCollator.getStrength();
        if (strength == 0) {
            return IPlatformCollator.Sensitivity.BASE;
        }
        if (strength == 1) {
            return IPlatformCollator.Sensitivity.ACCENT;
        }
        return IPlatformCollator.Sensitivity.VARIANT;
    }

    @Override
    public IPlatformCollator setSensitivity(IPlatformCollator.Sensitivity sensitivity) {
        assert (Build.VERSION.SDK_INT < 24);
        switch (sensitivity) {
            case BASE: {
                this.mCollator.setStrength(0);
                break;
            }
            case ACCENT: {
                this.mCollator.setStrength(1);
                break;
            }
            case VARIANT: {
                this.mCollator.setStrength(2);
                break;
            }
            case CASE: {
                this.mCollator.setStrength(0);
            }
        }
        return this;
    }

    @Override
    public IPlatformCollator setIgnorePunctuation(boolean ignore) {
        return this;
    }

    @Override
    public IPlatformCollator setNumericAttribute(boolean numeric) {
        return this;
    }

    @Override
    public IPlatformCollator setCaseFirstAttribute(IPlatformCollator.CaseFirst caseFirst) {
        return this;
    }

    @Override
    public String[] getAvailableLocales() {
        Locale[] availableLocales;
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{"en"};
        }
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (Locale locale : availableLocales = Collator.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }
}

