/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.containers;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.testing.containers.BaseTestContainer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testcontainers.containers.Network;

public class NessieContainer
extends BaseTestContainer {
    private static final Logger log = Logger.get(NessieContainer.class);
    public static final String DEFAULT_IMAGE = "ghcr.io/projectnessie/nessie:0.105.7";
    public static final String DEFAULT_HOST_NAME = "nessie";
    public static final String VERSION_STORE_TYPE = "IN_MEMORY";
    public static final int PORT = 19121;
    public static final ImmutableMap<String, String> DEFAULT_ENV_VARS = ImmutableMap.of((Object)"QUARKUS_HTTP_PORT", (Object)String.valueOf(19121), (Object)"NESSIE_VERSION_STORE_TYPE", (Object)"IN_MEMORY");

    public static Builder builder() {
        return new Builder();
    }

    private NessieContainer(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    @Override
    public void start() {
        super.start();
        log.info("Nessie server container started with address for REST API: %s", new Object[]{this.getRestApiUri()});
    }

    public String getRestApiUri() {
        return "http://" + this.getMappedHostAndPortForExposedPort(19121) + "/api/v1";
    }

    public String getIcebergRestUri() {
        return "http://" + this.getMappedHostAndPortForExposedPort(19121) + "/iceberg";
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, NessieContainer> {
        private Builder() {
            this.image = NessieContainer.DEFAULT_IMAGE;
            this.hostName = NessieContainer.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)19121);
            this.envVars = DEFAULT_ENV_VARS;
        }

        @Override
        public NessieContainer build() {
            return new NessieContainer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

