/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing.containers;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.testing.containers.BaseTestContainer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.testcontainers.containers.Network;

public class KeycloakContainer
extends BaseTestContainer {
    private static final Logger log = Logger.get(KeycloakContainer.class);
    public static final String DEFAULT_IMAGE = "quay.io/keycloak/keycloak:26.4.2";
    public static final String DEFAULT_HOST_NAME = "keycloak";
    public static final String DEFAULT_USER_NAME = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    public static final String MASTER_REALM = "master";
    public static final String ADMIN_CLI_CLIENT = "admin-cli";
    public static final int PORT = 8080;
    public static final String SERVER_URL = "http://keycloak:8080";

    public static Builder builder() {
        return new Builder();
    }

    protected KeycloakContainer(String image, String hostName, Set<Integer> exposePorts, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int retryLimit) {
        super(image, hostName, exposePorts, filesToMount, envVars, network, retryLimit);
    }

    @Override
    protected void setupContainer() {
        super.setupContainer();
        this.withRunCommand((List<String>)ImmutableList.of((Object)"start-dev"));
    }

    @Override
    public void start() {
        super.start();
        log.info("Keycloak container started with URL: %s", new Object[]{this.getUrl()});
    }

    public String getUrl() {
        return "http://" + this.getMappedHostAndPortForExposedPort(8080);
    }

    public String getAccessToken() {
        try (Keycloak keycloak = KeycloakBuilder.builder().serverUrl(this.getUrl()).realm(MASTER_REALM).clientId(ADMIN_CLI_CLIENT).username("admin").password("admin").build();){
            RealmResource master = keycloak.realm(MASTER_REALM);
            RealmRepresentation masterRep = master.toRepresentation();
            masterRep.setAccessTokenLifespan(Integer.valueOf(3600));
            master.update(masterRep);
            String string = keycloak.tokenManager().getAccessTokenString();
            return string;
        }
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, KeycloakContainer> {
        private Builder() {
            this.image = KeycloakContainer.DEFAULT_IMAGE;
            this.hostName = KeycloakContainer.DEFAULT_HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)8080);
            this.envVars = ImmutableMap.of((Object)"KC_BOOTSTRAP_ADMIN_USERNAME", (Object)"admin", (Object)"KC_BOOTSTRAP_ADMIN_PASSWORD", (Object)"admin", (Object)"KC_HOSTNAME", (Object)KeycloakContainer.SERVER_URL);
        }

        @Override
        public KeycloakContainer build() {
            return new KeycloakContainer(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

