/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.sqlserver;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Joiner;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.inject.Inject;

public class SqlServerClient
extends BaseJdbcClient {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    @Inject
    public SqlServerClient(JdbcConnectorId connectorId, BaseJdbcConfig config) {
        super(connectorId, config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new SQLServerDriver(), config));
    }

    protected void renameTable(String catalogName, SchemaTableName oldTable, SchemaTableName newTable) {
        try (Connection connection = this.connectionFactory.openConnection();){
            String sql = String.format("sp_rename %s, %s", SqlServerClient.singleQuote(catalogName, oldTable.getSchemaName(), oldTable.getTableName()), SqlServerClient.singleQuote(newTable.getTableName()));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        try (Connection connection = this.connectionFactory.openConnection();){
            String sql = String.format("sp_rename %s, %s, 'COLUMN'", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), jdbcColumn.getColumnName()), SqlServerClient.singleQuote(newColumnName));
            this.execute(connection, sql);
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static String singleQuote(String ... objects) {
        return SqlServerClient.singleQuote(DOT_JOINER.join((Object[])objects));
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }
}

