/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.ScalaUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.BypassMergeSortShuffleHandle;
import org.apache.spark.storage.BlockManager;
import scala.Option;
import scala.Product2;
import scala.collection.Iterator;

public class PrestoSparkNativeExecutionShuffleManager
implements ShuffleManager {
    private final Map<StageAndMapId, ShuffleHandle> partitionIdToShuffleHandle = new ConcurrentHashMap<StageAndMapId, ShuffleHandle>();
    private final Map<Integer, BaseShuffleHandle<?, ?, ?>> shuffleIdToBaseShuffleHandle = new ConcurrentHashMap();
    private final ShuffleManager fallbackShuffleManager;
    private static final String FALLBACK_SPARK_SHUFFLE_MANAGER = "spark.fallback.shuffle.manager";

    public PrestoSparkNativeExecutionShuffleManager(SparkConf conf) {
        this.fallbackShuffleManager = (ShuffleManager)PrestoSparkNativeExecutionShuffleManager.instantiateClass(conf.get(FALLBACK_SPARK_SHUFFLE_MANAGER), conf);
    }

    private static <T> T instantiateClass(String className, SparkConf conf) {
        try {
            return (T)Class.forName(className).getConstructor(SparkConf.class).newInstance(conf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("%s class not found", className), e);
        }
    }

    protected void registerShuffleHandle(BaseShuffleHandle handle, int stageId, int mapId) {
        this.partitionIdToShuffleHandle.put(new StageAndMapId(stageId, mapId), (ShuffleHandle)handle);
        this.shuffleIdToBaseShuffleHandle.put(handle.shuffleId(), handle);
    }

    protected void unregisterShuffleHandle(int shuffleId, int stageId, int mapId) {
        this.partitionIdToShuffleHandle.remove(new StageAndMapId(stageId, mapId));
        this.shuffleIdToBaseShuffleHandle.remove(shuffleId);
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        return this.fallbackShuffleManager.registerShuffle(shuffleId, numMaps, dependency);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        Preconditions.checkState((boolean)(Objects.requireNonNull(handle, "handle is null") instanceof BypassMergeSortShuffleHandle), (String)"class %s is not instance of BypassMergeSortShuffleHandle", (Object)handle.getClass().getName());
        BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)handle;
        int shuffleId = baseShuffleHandle.shuffleId();
        int stageId = context.stageId();
        this.registerShuffleHandle(baseShuffleHandle, stageId, mapId);
        return new EmptyShuffleWriter(baseShuffleHandle.dependency().partitioner().numPartitions(), () -> this.unregisterShuffleHandle(shuffleId, stageId, mapId));
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        return new EmptyShuffleReader();
    }

    public boolean unregisterShuffle(int shuffleId) {
        this.fallbackShuffleManager.unregisterShuffle(shuffleId);
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.fallbackShuffleManager.shuffleBlockResolver();
    }

    public void stop() {
        this.fallbackShuffleManager.stop();
    }

    public Optional<ShuffleHandle> getShuffleHandle(int stageId, int mapId) {
        return Optional.ofNullable(this.partitionIdToShuffleHandle.getOrDefault(new StageAndMapId(stageId, mapId), null));
    }

    public boolean hasRegisteredShuffleHandles() {
        return !this.partitionIdToShuffleHandle.isEmpty() || !this.shuffleIdToBaseShuffleHandle.isEmpty();
    }

    public int getNumOfPartitions(int shuffleId) {
        if (!this.shuffleIdToBaseShuffleHandle.containsKey(shuffleId)) {
            throw new RuntimeException(String.format("shuffleId=[%s] is not registered", shuffleId));
        }
        return this.shuffleIdToBaseShuffleHandle.get(shuffleId).dependency().partitioner().numPartitions();
    }

    public static class StageAndMapId {
        private final int stageId;
        private final int mapId;

        public StageAndMapId(int stageId, int mapId) {
            this.stageId = stageId;
            this.mapId = mapId;
        }

        public int getStageId() {
            return this.stageId;
        }

        public int getMapId() {
            return this.mapId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StageAndMapId that = (StageAndMapId)o;
            return this.stageId == that.stageId && this.mapId == that.mapId;
        }

        public int hashCode() {
            return Objects.hash(this.stageId, this.mapId);
        }
    }

    static class EmptyShuffleWriter<K, V>
    extends ShuffleWriter<K, V> {
        private final long[] mapStatus;
        private final Runnable onStop;
        private static final long DEFAULT_MAP_STATUS = 1L;

        public EmptyShuffleWriter(int totalMapStages, Runnable onStop) {
            this.mapStatus = new long[totalMapStages];
            this.onStop = Objects.requireNonNull(onStop, "onStop is null");
            Arrays.fill(this.mapStatus, 1L);
        }

        public void write(Iterator<Product2<K, V>> records) throws IOException {
            if (records.hasNext()) {
                throw new RuntimeException("EmptyShuffleWriter can only take empty write input.");
            }
        }

        public Option<MapStatus> stop(boolean success) {
            this.onStop.run();
            BlockManager blockManager = SparkEnv.get().blockManager();
            return Option.apply((Object)MapStatus$.MODULE$.apply(blockManager.blockManagerId(), this.mapStatus));
        }
    }

    static class EmptyShuffleReader<K, V>
    implements ShuffleReader<K, V> {
        EmptyShuffleReader() {
        }

        public Iterator<Product2<K, V>> read() {
            return ScalaUtils.emptyScalaIterator();
        }
    }
}

