/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.ScalaUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.storage.BlockManager;
import scala.Option;
import scala.Product2;
import scala.collection.Iterator;

public class PrestoSparkNativeExecutionShuffleManager
implements ShuffleManager {
    private final Map<Integer, ShuffleHandle> partitionIdToShuffleHandle = new ConcurrentHashMap<Integer, ShuffleHandle>();
    private final Map<Integer, BaseShuffleHandle<?, ?, ?>> shuffleIdToBaseShuffleHandle = new ConcurrentHashMap();
    private final ShuffleManager fallbackShuffleManager;
    private static final String FALLBACK_SPARK_SHUFFLE_MANAGER = "spark.fallback.shuffle.manager";

    public PrestoSparkNativeExecutionShuffleManager(SparkConf conf) {
        this.fallbackShuffleManager = (ShuffleManager)PrestoSparkNativeExecutionShuffleManager.instantiateClass(conf.get(FALLBACK_SPARK_SHUFFLE_MANAGER), conf);
    }

    private static <T> T instantiateClass(String className, SparkConf conf) {
        try {
            return (T)Class.forName(className).getConstructor(SparkConf.class).newInstance(conf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("%s class not found", className), e);
        }
    }

    protected void registerShuffleHandle(BaseShuffleHandle handle, int mapId) {
        this.partitionIdToShuffleHandle.put(mapId, (ShuffleHandle)handle);
        this.shuffleIdToBaseShuffleHandle.put(handle.shuffleId(), handle);
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, int numMaps, ShuffleDependency<K, V, C> dependency) {
        return this.fallbackShuffleManager.registerShuffle(shuffleId, numMaps, dependency);
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, int mapId, TaskContext context) {
        Preconditions.checkState((boolean)(Objects.requireNonNull(handle, "handle is null") instanceof BaseShuffleHandle), (String)"class %s is not instance of BaseShuffleHandle", (Object)handle.getClass().getName());
        BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)handle;
        this.registerShuffleHandle(baseShuffleHandle, mapId);
        return new EmptyShuffleWriter(baseShuffleHandle.dependency().partitioner().numPartitions());
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context) {
        return new EmptyShuffleReader();
    }

    public boolean unregisterShuffle(int shuffleId) {
        this.fallbackShuffleManager.unregisterShuffle(shuffleId);
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.fallbackShuffleManager.shuffleBlockResolver();
    }

    public void stop() {
        this.fallbackShuffleManager.stop();
    }

    public Optional<ShuffleHandle> getShuffleHandle(int partitionId) {
        return Optional.ofNullable(this.partitionIdToShuffleHandle.getOrDefault(partitionId, null));
    }

    public int getNumOfPartitions(int shuffleId) {
        if (!this.shuffleIdToBaseShuffleHandle.containsKey(shuffleId)) {
            throw new RuntimeException(String.format("shuffleId=[%s] is not registered", shuffleId));
        }
        return this.shuffleIdToBaseShuffleHandle.get(shuffleId).dependency().partitioner().numPartitions();
    }

    static class EmptyShuffleWriter<K, V>
    extends ShuffleWriter<K, V> {
        private final long[] mapStatus;
        private static final long DEFAULT_MAP_STATUS = 1L;

        public EmptyShuffleWriter(int totalMapStages) {
            this.mapStatus = new long[totalMapStages];
            Arrays.fill(this.mapStatus, 1L);
        }

        public void write(Iterator<Product2<K, V>> records) throws IOException {
            if (records.hasNext()) {
                throw new RuntimeException("EmptyShuffleWriter can only take empty write input.");
            }
        }

        public Option<MapStatus> stop(boolean success) {
            BlockManager blockManager = SparkEnv.get().blockManager();
            return Option.apply((Object)MapStatus$.MODULE$.apply(blockManager.blockManagerId(), this.mapStatus));
        }
    }

    static class EmptyShuffleReader<K, V>
    implements ShuffleReader<K, V> {
        EmptyShuffleReader() {
        }

        public Iterator<Product2<K, V>> read() {
            return ScalaUtils.emptyScalaIterator();
        }
    }
}

