/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;

public class ReadOnlyAccessControl
implements ConnectorAccessControl {
    public void checkCanAddColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    public void checkCanDropTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    public void checkCanSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    public void checkCanCreateView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    public void checkCanDropView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    public void checkCanSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanCreateViewWithSelectFromTable(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName tableName) {
    }

    public void checkCanCreateViewWithSelectFromView(ConnectorTransactionHandle transaction, Identity identity, SchemaTableName viewName) {
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transaction, Identity identity, Privilege privilege, SchemaTableName tableName) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }
}

