/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QueryBody;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class Values
extends QueryBody {
    private final List<Expression> rows;

    public Values(List<Expression> rows) {
        Preconditions.checkNotNull(rows, (Object)"rows is null");
        this.rows = ImmutableList.copyOf(rows);
    }

    public List<Expression> getRows() {
        return this.rows;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public String toString() {
        return "(" + Joiner.on((String)", ").join(this.rows) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rows);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Values other = (Values)obj;
        return Objects.equals(this.rows, other.rows);
    }
}

