/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;

public final class Cast
extends Expression {
    private final Expression expression;
    private final String type;
    private final boolean safe;

    public Cast(Expression expression, String type) {
        this(expression, type, false);
    }

    public Cast(Expression expression, String type, boolean safe) {
        Preconditions.checkNotNull((Object)expression, (Object)"expression is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.expression = expression;
        this.type = type.toUpperCase(Locale.ENGLISH);
        this.safe = safe;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cast o = (Cast)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.type, o.type) && Objects.equals(this.safe, o.safe);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe);
    }
}

