/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlBaseBaseVisitor;
import com.facebook.presto.sql.parser.SqlBaseParser;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Approximate;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    AstBuilder() {
    }

    @Override
    public Node visitSingleStatement(@NotNull SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitSingleExpression(@NotNull SqlBaseParser.SingleExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitUse(@NotNull SqlBaseParser.UseContext context) {
        return new Use(AstBuilder.getTextIfPresent(context.catalog), context.schema.getText());
    }

    @Override
    public Node visitCreateTableAsSelect(@NotNull SqlBaseParser.CreateTableAsSelectContext context) {
        return new CreateTable(AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDropTable(@NotNull SqlBaseParser.DropTableContext context) {
        return new DropTable(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitDropView(@NotNull SqlBaseParser.DropViewContext context) {
        return new DropView(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitInsertInto(@NotNull SqlBaseParser.InsertIntoContext context) {
        return new Insert(AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitRenameTable(@NotNull SqlBaseParser.RenameTableContext context) {
        return new RenameTable(AstBuilder.getQualifiedName(context.from), AstBuilder.getQualifiedName(context.to));
    }

    @Override
    public Node visitCreateView(@NotNull SqlBaseParser.CreateViewContext context) {
        return new CreateView(AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()), context.REPLACE() != null);
    }

    @Override
    public Node visitQuery(@NotNull SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(this.visitIfPresent(context.with(), With.class), body.getQueryBody(), body.getOrderBy(), body.getLimit(), body.getApproximate());
    }

    @Override
    public Node visitWith(@NotNull SqlBaseParser.WithContext context) {
        return new With(context.RECURSIVE() != null, this.visit(context.namedQuery(), WithQuery.class));
    }

    @Override
    public Node visitNamedQuery(@NotNull SqlBaseParser.NamedQueryContext context) {
        return new WithQuery(context.name.getText(), (Query)this.visit((ParseTree)context.query()), AstBuilder.getColumnAliases(context.columnAliases()));
    }

    @Override
    public Node visitQueryNoWith(@NotNull SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(Optional.empty(), new QuerySpecification(query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit)), (List<SortItem>)ImmutableList.of(), Optional.empty(), AstBuilder.getTextIfPresent(context.confidence).map(Approximate::new));
        }
        return new Query(Optional.empty(), term, this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit), AstBuilder.getTextIfPresent(context.confidence).map(Approximate::new));
    }

    @Override
    public Node visitQuerySpecification(@NotNull SqlBaseParser.QuerySpecificationContext context) {
        Optional<Relation> from = Optional.empty();
        List<Relation> relations = this.visit(context.relation(), Relation.class);
        if (!relations.isEmpty()) {
            Iterator<Relation> iterator = relations.iterator();
            Relation relation = iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(Join.Type.IMPLICIT, relation, iterator.next(), Optional.empty());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(new Select(AstBuilder.isDistinct(context.setQuantifier()), this.visit(context.selectItem(), SelectItem.class)), from, this.visitIfPresent(context.where, Expression.class), this.visit(context.groupBy, Expression.class), this.visitIfPresent(context.having, Expression.class), (List<SortItem>)ImmutableList.of(), Optional.empty());
    }

    @Override
    public Node visitSetOperation(@NotNull SqlBaseParser.SetOperationContext context) {
        QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
        boolean distinct = context.setQuantifier() == null || context.setQuantifier().DISTINCT() != null;
        switch (context.operator.getType()) {
            case 113: {
                return new Union((List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 115: {
                return new Intersect((List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 114: {
                return new Except(left, right, distinct);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
    }

    @Override
    public Node visitSelectAll(@NotNull SqlBaseParser.SelectAllContext context) {
        if (context.qualifiedName() != null) {
            return new AllColumns(AstBuilder.getQualifiedName(context.qualifiedName()));
        }
        return new AllColumns();
    }

    @Override
    public Node visitSelectSingle(@NotNull SqlBaseParser.SelectSingleContext context) {
        Optional<String> alias = AstBuilder.getTextIfPresent(context.identifier());
        return new SingleColumn((Expression)this.visit((ParseTree)context.expression()), alias);
    }

    @Override
    public Node visitTable(@NotNull SqlBaseParser.TableContext context) {
        return new Table(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubquery(@NotNull SqlBaseParser.SubqueryContext context) {
        return new TableSubquery((Query)this.visit((ParseTree)context.queryNoWith()));
    }

    @Override
    public Node visitInlineTable(@NotNull SqlBaseParser.InlineTableContext context) {
        return new Values(this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitExplain(@NotNull SqlBaseParser.ExplainContext context) {
        return new Explain((Statement)this.visit((ParseTree)context.statement()), this.visit(context.explainOption(), ExplainOption.class));
    }

    @Override
    public Node visitExplainFormat(@NotNull SqlBaseParser.ExplainFormatContext context) {
        switch (context.value.getType()) {
            case 98: {
                return new ExplainFormat(ExplainFormat.Type.GRAPHVIZ);
            }
            case 97: {
                return new ExplainFormat(ExplainFormat.Type.TEXT);
            }
            case 99: {
                return new ExplainFormat(ExplainFormat.Type.JSON);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN format: " + context.value.getText());
    }

    @Override
    public Node visitExplainType(@NotNull SqlBaseParser.ExplainTypeContext context) {
        switch (context.value.getType()) {
            case 100: {
                return new ExplainType(ExplainType.Type.LOGICAL);
            }
            case 101: {
                return new ExplainType(ExplainType.Type.DISTRIBUTED);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN type: " + context.value.getText());
    }

    @Override
    public Node visitShowTables(@NotNull SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(Optional.ofNullable(context.qualifiedName()).map(AstBuilder::getQualifiedName), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowSchemas(@NotNull SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(AstBuilder.getTextIfPresent(context.identifier()));
    }

    @Override
    public Node visitShowCatalogs(@NotNull SqlBaseParser.ShowCatalogsContext context) {
        return new ShowCatalogs();
    }

    @Override
    public Node visitShowColumns(@NotNull SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitShowPartitions(@NotNull SqlBaseParser.ShowPartitionsContext context) {
        return new ShowPartitions(AstBuilder.getQualifiedName(context.qualifiedName()), this.visitIfPresent(context.booleanExpression(), Expression.class), this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit));
    }

    @Override
    public Node visitShowFunctions(@NotNull SqlBaseParser.ShowFunctionsContext context) {
        return new ShowFunctions();
    }

    @Override
    public Node visitShowSession(@NotNull SqlBaseParser.ShowSessionContext context) {
        return new ShowSession();
    }

    @Override
    public Node visitSetSession(@NotNull SqlBaseParser.SetSessionContext context) {
        return new SetSession(AstBuilder.getQualifiedName(context.qualifiedName()), AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitResetSession(@NotNull SqlBaseParser.ResetSessionContext context) {
        return new ResetSession(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitLogicalNot(@NotNull SqlBaseParser.LogicalNotContext context) {
        return new NotExpression((Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(@NotNull SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(@NotNull SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        Relation right = (Relation)this.visit((ParseTree)context.right);
        if (context.CROSS() != null) {
            return new Join(Join.Type.CROSS, left, right, Optional.empty());
        }
        if (context.NATURAL() != null) {
            criteria = new NaturalJoin();
        } else if (context.joinCriteria().ON() != null) {
            criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
        } else if (context.joinCriteria().USING() != null) {
            List<String> columns = context.joinCriteria().identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
            criteria = new JoinUsing(columns);
        } else {
            throw new IllegalArgumentException("Unsupported join criteria");
        }
        Join.Type joinType = context.joinType().LEFT() != null ? Join.Type.LEFT : (context.joinType().RIGHT() != null ? Join.Type.RIGHT : (context.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(joinType, left, right, Optional.of(criteria));
    }

    @Override
    public Node visitSampledRelation(@NotNull SqlBaseParser.SampledRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.aliasedRelation());
        if (context.TABLESAMPLE() == null) {
            return child;
        }
        Optional<List<Expression>> stratifyOn = Optional.empty();
        if (context.STRATIFY() != null) {
            stratifyOn = Optional.of(this.visit(context.stratify, Expression.class));
        }
        return new SampledRelation(child, AstBuilder.getSamplingMethod((Token)context.sampleType().getChild(0).getPayload()), (Expression)this.visit((ParseTree)context.percentage), context.RESCALED() != null, stratifyOn);
    }

    @Override
    public Node visitAliasedRelation(@NotNull SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.identifier() == null) {
            return child;
        }
        return new AliasedRelation(child, context.identifier().getText(), AstBuilder.getColumnAliases(context.columnAliases()));
    }

    @Override
    public Node visitTableName(@NotNull SqlBaseParser.TableNameContext context) {
        return new Table(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubqueryRelation(@NotNull SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitUnnest(@NotNull SqlBaseParser.UnnestContext context) {
        return new Unnest(this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitParenthesizedRelation(@NotNull SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(@NotNull SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(@NotNull SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(@NotNull SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(@NotNull SqlBaseParser.BetweenContext context) {
        return new BetweenPredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
    }

    @Override
    public Node visitNullPredicate(@NotNull SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(child);
        }
        return new IsNotNullPredicate(child);
    }

    @Override
    public Node visitLike(@NotNull SqlBaseParser.LikeContext context) {
        Expression escape = null;
        if (context.escape != null) {
            escape = (Expression)this.visit((ParseTree)context.escape);
        }
        Expression result = new LikePredicate((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape);
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitInList(@NotNull SqlBaseParser.InListContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), new InListExpression(this.visit(context.expression(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(@NotNull SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate((Expression)this.visit((ParseTree)context.value), new SubqueryExpression((Query)this.visit((ParseTree)context.query())));
        if (context.NOT() != null) {
            result = new NotExpression(result);
        }
        return result;
    }

    @Override
    public Node visitExists(@NotNull SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitArithmeticUnary(@NotNull SqlBaseParser.ArithmeticUnaryContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
        switch (context.operator.getType()) {
            case 141: {
                return ArithmeticUnaryExpression.negative(child);
            }
            case 140: {
                return ArithmeticUnaryExpression.positive(child);
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
    }

    @Override
    public Node visitArithmeticBinary(@NotNull SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticBinaryExpression(AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(@NotNull SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(new QualifiedName("concat"), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
    }

    @Override
    public Node visitAtTimeZone(@NotNull SqlBaseParser.AtTimeZoneContext context) {
        return new FunctionCall(QualifiedName.of("at_timezone", new String[0]), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.valueExpression())), (Object)((Expression)this.visit((ParseTree)context.timeZoneSpecifier()))));
    }

    @Override
    public Node visitTimeZoneInterval(@NotNull SqlBaseParser.TimeZoneIntervalContext context) {
        return (Node)this.visit((ParseTree)context.interval());
    }

    @Override
    public Node visitTimeZoneString(@NotNull SqlBaseParser.TimeZoneStringContext context) {
        return new StringLiteral(AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitParenthesizedExpression(@NotNull SqlBaseParser.ParenthesizedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitRowConstructor(@NotNull SqlBaseParser.RowConstructorContext context) {
        return new Row(this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitArrayConstructor(@NotNull SqlBaseParser.ArrayConstructorContext context) {
        return new ArrayConstructor(this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitCast(@NotNull SqlBaseParser.CastContext context) {
        boolean isTryCast = context.TRY_CAST() != null;
        return new Cast((Expression)this.visit((ParseTree)context.expression()), AstBuilder.getType(context.type()), isTryCast);
    }

    @Override
    public Node visitSpecialDateTimeFunction(@NotNull SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Type type = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(type, Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(type);
    }

    @Override
    public Node visitExtract(@NotNull SqlBaseParser.ExtractContext context) {
        return new Extract((Expression)this.visit((ParseTree)context.valueExpression()), Extract.Field.valueOf(context.identifier().getText().toUpperCase()));
    }

    @Override
    public Node visitSubstring(@NotNull SqlBaseParser.SubstringContext context) {
        return new FunctionCall(new QualifiedName("substr"), this.visit(context.valueExpression(), Expression.class));
    }

    @Override
    public Node visitSubscript(@NotNull SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression((Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubqueryExpression(@NotNull SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression((Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitColumnReference(@NotNull SqlBaseParser.ColumnReferenceContext context) {
        return new QualifiedNameReference(AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSimpleCase(@NotNull SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression((Expression)this.visit((ParseTree)context.valueExpression()), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitSearchedCase(@NotNull SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitWhenClause(@NotNull SqlBaseParser.WhenClauseContext context) {
        return new WhenClause((Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFunctionCall(@NotNull SqlBaseParser.FunctionCallContext context) {
        Optional<Window> window = this.visitIfPresent(context.over(), Window.class);
        QualifiedName name = AstBuilder.getQualifiedName(context.qualifiedName());
        boolean distinct = AstBuilder.isDistinct(context.setQuantifier());
        if (name.toString().equalsIgnoreCase("if")) {
            AstBuilder.check(context.expression().size() == 2 || context.expression().size() == 3, "Invalid number of arguments for 'if' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'if' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'if' function", context);
            Expression elseExpression = null;
            if (context.expression().size() == 3) {
                elseExpression = (Expression)this.visit((ParseTree)context.expression(2));
            }
            return new IfExpression((Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)), elseExpression);
        }
        if (name.toString().equalsIgnoreCase("nullif")) {
            AstBuilder.check(context.expression().size() == 2, "Invalid number of arguments for 'nullif' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'nullif' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", context);
            return new NullIfExpression((Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)));
        }
        if (name.toString().equalsIgnoreCase("coalesce")) {
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'coalesce' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'coalesce' function", context);
            return new CoalesceExpression(this.visit(context.expression(), Expression.class));
        }
        return new FunctionCall(AstBuilder.getQualifiedName(context.qualifiedName()), window, distinct, this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitOver(@NotNull SqlBaseParser.OverContext context) {
        return new Window(this.visit(context.partition, Expression.class), this.visit(context.sortItem(), SortItem.class), this.visitIfPresent(context.windowFrame(), WindowFrame.class));
    }

    @Override
    public Node visitSortItem(@NotNull SqlBaseParser.SortItemContext context) {
        return new SortItem((Expression)this.visit((ParseTree)context.expression()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    @Override
    public Node visitWindowFrame(@NotNull SqlBaseParser.WindowFrameContext context) {
        return new WindowFrame(AstBuilder.getFrameType(context.frameType), (FrameBound)this.visit((ParseTree)context.start), this.visitIfPresent(context.end, FrameBound.class));
    }

    @Override
    public Node visitUnboundedFrame(@NotNull SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    @Override
    public Node visitBoundedFrame(@NotNull SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitCurrentRowBound(@NotNull SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(FrameBound.Type.CURRENT_ROW);
    }

    @Override
    public Node visitNullLiteral(@NotNull SqlBaseParser.NullLiteralContext context) {
        return new NullLiteral();
    }

    @Override
    public Node visitStringLiteral(@NotNull SqlBaseParser.StringLiteralContext context) {
        return new StringLiteral(AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitTypeConstructor(@NotNull SqlBaseParser.TypeConstructorContext context) {
        String type = context.identifier().getText();
        String value = AstBuilder.unquote(context.STRING().getText());
        if (type.equalsIgnoreCase("time")) {
            return new TimeLiteral(value);
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return new TimestampLiteral(value);
        }
        return new GenericLiteral(type, value);
    }

    @Override
    public Node visitIntegerLiteral(@NotNull SqlBaseParser.IntegerLiteralContext context) {
        return new LongLiteral(context.getText());
    }

    @Override
    public Node visitDecimalLiteral(@NotNull SqlBaseParser.DecimalLiteralContext context) {
        return new DoubleLiteral(context.getText());
    }

    @Override
    public Node visitBooleanValue(@NotNull SqlBaseParser.BooleanValueContext context) {
        return new BooleanLiteral(context.getText());
    }

    @Override
    public Node visitInterval(@NotNull SqlBaseParser.IntervalContext context) {
        return new IntervalLiteral(AstBuilder.unquote(context.STRING().getText()), Optional.ofNullable(context.sign).map(AstBuilder::getIntervalSign).orElse(IntervalLiteral.Sign.POSITIVE), AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload()), Optional.ofNullable(context.to).map(x -> x.getChild(0).getPayload()).map(Token.class::cast).map(AstBuilder::getIntervalFieldType));
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String string) {
        return string.substring(1, string.length() - 1).replace("''", "'");
    }

    private static QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        List<String> parts = context.identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
        return new QualifiedName(parts);
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    private static Optional<String> getTextIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(ParseTree::getText);
    }

    private static Optional<String> getTextIfPresent(Token token) {
        return Optional.ofNullable(token).map(Token::getText);
    }

    private static List<String> getColumnAliases(SqlBaseParser.ColumnAliasesContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return null;
        }
        return columnAliasesContext.identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    private static ArithmeticBinaryExpression.Type getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 140: {
                return ArithmeticBinaryExpression.Type.ADD;
            }
            case 141: {
                return ArithmeticBinaryExpression.Type.SUBTRACT;
            }
            case 142: {
                return ArithmeticBinaryExpression.Type.MULTIPLY;
            }
            case 143: {
                return ArithmeticBinaryExpression.Type.DIVIDE;
            }
            case 144: {
                return ArithmeticBinaryExpression.Type.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 134: {
                return ComparisonExpression.Type.EQUAL;
            }
            case 135: {
                return ComparisonExpression.Type.NOT_EQUAL;
            }
            case 136: {
                return ComparisonExpression.Type.LESS_THAN;
            }
            case 137: {
                return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            }
            case 138: {
                return ComparisonExpression.Type.GREATER_THAN;
            }
            case 139: {
                return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
    }

    private static CurrentTime.Type getDateTimeFunctionType(Token token) {
        switch (token.getType()) {
            case 53: {
                return CurrentTime.Type.DATE;
            }
            case 54: {
                return CurrentTime.Type.TIME;
            }
            case 55: {
                return CurrentTime.Type.TIMESTAMP;
            }
            case 56: {
                return CurrentTime.Type.LOCALTIME;
            }
            case 57: {
                return CurrentTime.Type.LOCALTIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unsupported special function: " + token.getText());
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        switch (token.getType()) {
            case 46: {
                return IntervalLiteral.IntervalField.YEAR;
            }
            case 47: {
                return IntervalLiteral.IntervalField.MONTH;
            }
            case 48: {
                return IntervalLiteral.IntervalField.DAY;
            }
            case 49: {
                return IntervalLiteral.IntervalField.HOUR;
            }
            case 50: {
                return IntervalLiteral.IntervalField.MINUTE;
            }
            case 51: {
                return IntervalLiteral.IntervalField.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        switch (token.getType()) {
            case 141: {
                return IntervalLiteral.Sign.NEGATIVE;
            }
            case 140: {
                return IntervalLiteral.Sign.POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unsupported sign: " + token.getText());
    }

    private static WindowFrame.Type getFrameType(Token type) {
        switch (type.getType()) {
            case 76: {
                return WindowFrame.Type.RANGE;
            }
            case 77: {
                return WindowFrame.Type.ROWS;
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 79: {
                return FrameBound.Type.PRECEDING;
            }
            case 80: {
                return FrameBound.Type.FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 79: {
                return FrameBound.Type.UNBOUNDED_PRECEDING;
            }
            case 80: {
                return FrameBound.Type.UNBOUNDED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static SampledRelation.Type getSamplingMethod(Token token) {
        switch (token.getType()) {
            case 118: {
                return SampledRelation.Type.BERNOULLI;
            }
            case 117: {
                return SampledRelation.Type.SYSTEM;
            }
            case 119: {
                return SampledRelation.Type.POISSONIZED;
            }
        }
        throw new IllegalArgumentException("Unsupported sampling method: " + token.getText());
    }

    private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
        switch (token.getType()) {
            case 24: {
                return LogicalBinaryExpression.Type.AND;
            }
            case 23: {
                return LogicalBinaryExpression.Type.OR;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + token.getText());
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        switch (token.getType()) {
            case 35: {
                return SortItem.NullOrdering.FIRST;
            }
            case 36: {
                return SortItem.NullOrdering.LAST;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 38: {
                return SortItem.Ordering.ASCENDING;
            }
            case 39: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static String getType(SqlBaseParser.TypeContext type) {
        if (type.simpleType() != null) {
            return type.simpleType().getText();
        }
        if (type.ARRAY() != null) {
            return "ARRAY<" + AstBuilder.getType(type.type(0)) + ">";
        }
        if (type.MAP() != null) {
            return "MAP<" + AstBuilder.getType(type.type(0)) + "," + AstBuilder.getType(type.type(1)) + ">";
        }
        throw new IllegalArgumentException("Unsupported type specification: " + type.getText());
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
        }
    }
}

