/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class QualifiedName {
    private final List<String> parts;

    public static QualifiedName of(QualifiedName prefix, String suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        Preconditions.checkNotNull((Object)suffix, (Object)"suffix is null");
        return new QualifiedName(Iterables.concat(prefix.getParts(), (Iterable)ImmutableList.of((Object)suffix)));
    }

    public static QualifiedName of(String prefix, QualifiedName suffix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        Preconditions.checkNotNull((Object)suffix, (Object)"suffix is null");
        return QualifiedName.of(Iterables.concat((Iterable)ImmutableList.of((Object)prefix), suffix.getParts()));
    }

    public static QualifiedName of(String first, String ... rest) {
        Preconditions.checkNotNull((Object)first, (Object)"first is null");
        return new QualifiedName((Iterable<String>)ImmutableList.copyOf((Collection)Lists.asList((Object)first, (Object[])rest)));
    }

    public static QualifiedName of(Iterable<String> parts) {
        Preconditions.checkNotNull(parts, (Object)"parts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(parts) ? 1 : 0) != 0, (Object)"parts is empty");
        return new QualifiedName(parts);
    }

    public static QualifiedName parseQualifiedName(String qualifiedName) {
        Preconditions.checkNotNull((Object)qualifiedName, (Object)"qualifiedName is null");
        return QualifiedName.of(Splitter.on((char)'.').split((CharSequence)qualifiedName));
    }

    public QualifiedName(String name) {
        this((Iterable<String>)ImmutableList.of((Object)name));
    }

    public QualifiedName(Iterable<String> parts) {
        Preconditions.checkNotNull(parts, (Object)"parts");
        Preconditions.checkArgument((!Iterables.isEmpty(parts) ? 1 : 0) != 0, (Object)"parts is empty");
        this.parts = ImmutableList.copyOf((Iterable)Iterables.transform(parts, QualifiedName.toLowerCase()));
    }

    public List<String> getParts() {
        return this.parts;
    }

    public String toString() {
        return Joiner.on((char)'.').join(this.parts);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.absent();
        }
        return Optional.of((Object)QualifiedName.of(this.parts.subList(0, this.parts.size() - 1)));
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public static Predicate<QualifiedName> hasSuffixPredicate(final QualifiedName suffix) {
        return new Predicate<QualifiedName>(){

            public boolean apply(QualifiedName name) {
                return name.hasSuffix(suffix);
            }
        };
    }

    public static Function<String, QualifiedName> addPrefixFunction(final QualifiedName prefix) {
        return new Function<String, QualifiedName>(){

            public QualifiedName apply(@Nullable String suffix) {
                return QualifiedName.of(prefix, suffix);
            }
        };
    }

    public String getSuffix() {
        return (String)Iterables.getLast(this.parts);
    }

    public static Function<String, QualifiedName> fromStringFunction() {
        return new Function<String, QualifiedName>(){

            public QualifiedName apply(String input) {
                return new QualifiedName(input);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.parts.equals(that.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    private static Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            public String apply(String s) {
                return s.toLowerCase(Locale.ENGLISH);
            }
        };
    }
}

