/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class IntervalLiteral
extends Literal {
    private final String value;
    private final Sign sign;
    private final IntervalField startField;
    private final IntervalField endField;

    public IntervalLiteral(String value, Sign sign, IntervalField startField) {
        this(value, sign, startField, null);
    }

    public IntervalLiteral(String value, Sign sign, IntervalField startField, IntervalField endField) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull((Object)((Object)sign), (Object)"sign is null");
        Preconditions.checkNotNull((Object)((Object)startField), (Object)"startField is null");
        this.value = value;
        this.sign = sign;
        this.startField = startField;
        this.endField = endField;
    }

    public String getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    public IntervalField getStartField() {
        return this.startField;
    }

    public IntervalField getEndField() {
        return this.endField;
    }

    public boolean isYearToMonth() {
        return this.startField == IntervalField.YEAR || this.startField == IntervalField.MONTH;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign, this.startField, this.endField});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalLiteral other = (IntervalLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals((Object)this.sign, (Object)other.sign) && Objects.equals((Object)this.startField, (Object)other.startField) && Objects.equals((Object)this.endField, (Object)other.endField);
    }

    public static enum IntervalField {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }

    public static enum Sign {
        POSITIVE{

            @Override
            public int multiplier() {
                return 1;
            }
        }
        ,
        NEGATIVE{

            @Override
            public int multiplier() {
                return -1;
            }
        };


        public abstract int multiplier();
    }
}

