/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class WindowFrame
extends Node {
    private final Type type;
    private final FrameBound start;
    private final Optional<FrameBound> end;

    public WindowFrame(Type type, FrameBound start, FrameBound end) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.start = (FrameBound)Preconditions.checkNotNull((Object)start, (Object)"start is null");
        this.end = Optional.fromNullable((Object)end);
    }

    public Type getType() {
        return this.type;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public Optional<FrameBound> getEnd() {
        return this.end;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFrame(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFrame o = (WindowFrame)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)o.type)) && Objects.equal((Object)this.start, (Object)o.start) && Objects.equal(this.end, o.end);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.start, this.end});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("start", (Object)this.start).add("end", this.end).toString();
    }

    public static enum Type {
        RANGE,
        ROWS;

    }
}

