/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class FrameBound
extends Node {
    private final Type type;
    private final Optional<Expression> value;

    public FrameBound(Type type) {
        this(type, null);
    }

    public FrameBound(Type type, Expression value) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null"));
        this.value = Optional.fromNullable((Object)value);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFrameBound(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameBound o = (FrameBound)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)o.type)) && Objects.equal(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.value});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", this.value).toString();
    }

    public static enum Type {
        UNBOUNDED_PRECEDING,
        PRECEDING,
        CURRENT_ROW,
        FOLLOWING,
        UNBOUNDED_FOLLOWING;

    }
}

