/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Explain
extends Statement {
    private final Statement statement;
    private final List<ExplainOption> options;

    public Explain(Statement statement, List<ExplainOption> options) {
        this.statement = (Statement)Preconditions.checkNotNull((Object)statement, (Object)"statement is null");
        this.options = options == null ? ImmutableList.of() : ImmutableList.copyOf(options);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public List<ExplainOption> getOptions() {
        return this.options;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExplain(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.statement, this.options});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Explain o = (Explain)obj;
        return Objects.equal((Object)this.statement, (Object)o.statement) && Objects.equal(this.options, o.options);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("statement", (Object)this.statement).add("options", this.options).toString();
    }
}

