/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;

public class WithQuery
extends Node {
    private final String name;
    private final Query query;
    private final List<String> columnNames;

    public WithQuery(String name, Query query, List<String> columnNames) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.query = (Query)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.columnNames = columnNames;
    }

    public String getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.query, this.columnNames});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal((Object)this.query, (Object)o.query) && Objects.equal(this.columnNames, o.columnNames);
    }
}

