/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;

public final class ExpressionFormatter {
    private ExpressionFormatter() {
    }

    public static String formatExpression(Expression expression) {
        return (String)new Formatter().process(expression, null);
    }

    public static Function<Expression, String> expressionFormatterFunction() {
        return new Function<Expression, String>(){

            public String apply(Expression input) {
                return ExpressionFormatter.formatExpression(input);
            }
        };
    }

    static String formatStringLiteral(String s) {
        return "'" + s.replace("'", "''") + "'";
    }

    static String formatSortItems(List<SortItem> sortItems) {
        return Joiner.on((String)", ").join(Iterables.transform(sortItems, ExpressionFormatter.sortItemFormatterFunction()));
    }

    private static Function<SortItem, String> sortItemFormatterFunction() {
        return new Function<SortItem, String>(){

            public String apply(SortItem input) {
                StringBuilder builder = new StringBuilder();
                builder.append(ExpressionFormatter.formatExpression(input.getSortKey()));
                switch (input.getOrdering()) {
                    case ASCENDING: {
                        builder.append(" ASC");
                        break;
                    }
                    case DESCENDING: {
                        builder.append(" DESC");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unknown ordering: " + (Object)((Object)input.getOrdering()));
                    }
                }
                switch (input.getNullOrdering()) {
                    case FIRST: {
                        builder.append(" NULLS FIRST");
                        break;
                    }
                    case LAST: {
                        builder.append(" NULLS LAST");
                        break;
                    }
                    case UNDEFINED: {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unknown null ordering: " + (Object)((Object)input.getNullOrdering()));
                    }
                }
                return builder.toString();
            }
        };
    }

    public static class Formatter
    extends AstVisitor<String, Void> {
        @Override
        protected String visitNode(Node node, Void context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException(String.format("not yet implemented: %s.visit%s", this.getClass().getName(), node.getClass().getSimpleName()));
        }

        @Override
        protected String visitCurrentTime(CurrentTime node, Void context) {
            StringBuilder builder = new StringBuilder();
            switch (node.getType()) {
                case TIME: {
                    builder.append("current_time");
                    break;
                }
                case DATE: {
                    builder.append("current_date");
                    break;
                }
                case TIMESTAMP: {
                    builder.append("current_timestamp");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("not yet implemented: " + (Object)((Object)node.getType()));
                }
            }
            if (node.getPrecision() != null) {
                builder.append('(').append(node.getPrecision()).append(')');
            }
            return builder.toString();
        }

        @Override
        protected String visitExtract(Extract node, Void context) {
            return "EXTRACT(" + (Object)((Object)node.getField()) + " FROM " + (String)this.process(node.getExpression(), context) + ")";
        }

        @Override
        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return String.valueOf(node.getValue());
        }

        @Override
        protected String visitStringLiteral(StringLiteral node, Void context) {
            return ExpressionFormatter.formatStringLiteral(node.getValue());
        }

        @Override
        protected String visitLongLiteral(LongLiteral node, Void context) {
            return Long.toString(node.getValue());
        }

        @Override
        protected String visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Double.toString(node.getValue());
        }

        @Override
        protected String visitGenericLiteral(GenericLiteral node, Void context) {
            return "" + node.getType() + " '" + node.getValue() + "'";
        }

        @Override
        protected String visitTimeLiteral(TimeLiteral node, Void context) {
            return "TIME '" + node.getValue() + "'";
        }

        @Override
        protected String visitTimestampLiteral(TimestampLiteral node, Void context) {
            return "TIMESTAMP '" + node.getValue() + "'";
        }

        @Override
        protected String visitNullLiteral(NullLiteral node, Void context) {
            return "null";
        }

        @Override
        protected String visitIntervalLiteral(IntervalLiteral node, Void context) {
            String sign = node.getSign() == IntervalLiteral.Sign.NEGATIVE ? "- " : "";
            StringBuilder builder = new StringBuilder().append("INTERVAL ").append(sign).append(" '").append(node.getValue()).append("' ").append((Object)node.getStartField());
            if (node.getEndField() != null) {
                builder.append(" TO ").append((Object)node.getEndField());
            }
            return builder.toString();
        }

        @Override
        protected String visitSubqueryExpression(SubqueryExpression node, Void context) {
            return "(" + SqlFormatter.formatSql(node.getQuery()) + ")";
        }

        @Override
        protected String visitExists(ExistsPredicate node, Void context) {
            return "EXISTS (" + SqlFormatter.formatSql(node.getSubquery()) + ")";
        }

        @Override
        protected String visitQualifiedNameReference(QualifiedNameReference node, Void context) {
            return Formatter.formatQualifiedName(node.getName());
        }

        private static String formatQualifiedName(QualifiedName name) {
            ArrayList<String> parts = new ArrayList<String>();
            for (String part : name.getParts()) {
                parts.add(Formatter.formatIdentifier(part));
            }
            return Joiner.on((char)'.').join(parts);
        }

        @Override
        public String visitInputReference(InputReference node, Void context) {
            return ":input(" + node.getInput().getChannel() + ")";
        }

        @Override
        protected String visitFunctionCall(FunctionCall node, Void context) {
            StringBuilder builder = new StringBuilder();
            String arguments = this.joinExpressions(node.getArguments());
            if (node.getArguments().isEmpty() && "count".equalsIgnoreCase(node.getName().getSuffix())) {
                arguments = "*";
            }
            if (node.isDistinct()) {
                arguments = "DISTINCT " + arguments;
            }
            builder.append(Formatter.formatQualifiedName(node.getName())).append('(').append(arguments).append(')');
            if (node.getWindow().isPresent()) {
                builder.append(" OVER ").append(this.visitWindow((Window)node.getWindow().get(), null));
            }
            return builder.toString();
        }

        @Override
        protected String visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return this.formatBinaryExpression(node.getType().toString(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitNotExpression(NotExpression node, Void context) {
            return "(NOT " + (String)this.process(node.getValue(), null) + ")";
        }

        @Override
        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitIsNullPredicate(IsNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), null) + " IS NULL)";
        }

        @Override
        protected String visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), null) + " IS NOT NULL)";
        }

        @Override
        protected String visitNullIfExpression(NullIfExpression node, Void context) {
            return "NULLIF(" + (String)this.process(node.getFirst(), null) + ", " + (String)this.process(node.getSecond(), null) + ')';
        }

        @Override
        protected String visitIfExpression(IfExpression node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append("IF(").append((String)this.process(node.getCondition(), context)).append(", ").append((String)this.process(node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                builder.append(", ").append((String)this.process((Node)node.getFalseValue().get(), context));
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        protected String visitCoalesceExpression(CoalesceExpression node, Void context) {
            return "COALESCE(" + this.joinExpressions(node.getOperands()) + ")";
        }

        @Override
        protected String visitNegativeExpression(NegativeExpression node, Void context) {
            return "-" + (String)this.process(node.getValue(), null);
        }

        @Override
        protected String visitArithmeticExpression(ArithmeticExpression node, Void context) {
            return this.formatBinaryExpression(node.getType().getValue(), node.getLeft(), node.getRight());
        }

        @Override
        protected String visitLikePredicate(LikePredicate node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append('(').append((String)this.process(node.getValue(), null)).append(" LIKE ").append((String)this.process(node.getPattern(), null));
            if (node.getEscape() != null) {
                builder.append(" ESCAPE ").append((String)this.process(node.getEscape(), null));
            }
            builder.append(')');
            return builder.toString();
        }

        @Override
        protected String visitAllColumns(AllColumns node, Void context) {
            if (node.getPrefix().isPresent()) {
                return node.getPrefix().get() + ".*";
            }
            return "*";
        }

        @Override
        public String visitCast(Cast node, Void context) {
            return "CAST(" + (String)this.process(node.getExpression(), context) + " AS " + node.getType() + ")";
        }

        @Override
        protected String visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE");
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            if (node.getDefaultValue() != null) {
                parts.add((Object)"ELSE").add(this.process(node.getDefaultValue(), context));
            }
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder parts = ImmutableList.builder();
            parts.add((Object)"CASE").add(this.process(node.getOperand(), context));
            for (WhenClause whenClause : node.getWhenClauses()) {
                parts.add(this.process(whenClause, context));
            }
            if (node.getDefaultValue() != null) {
                parts.add((Object)"ELSE").add(this.process(node.getDefaultValue(), context));
            }
            parts.add((Object)"END");
            return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
        }

        @Override
        protected String visitWhenClause(WhenClause node, Void context) {
            return "WHEN " + (String)this.process(node.getOperand(), context) + " THEN " + (String)this.process(node.getResult(), context);
        }

        @Override
        protected String visitBetweenPredicate(BetweenPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " BETWEEN " + (String)this.process(node.getMin(), context) + " AND " + (String)this.process(node.getMax(), context) + ")";
        }

        @Override
        protected String visitInPredicate(InPredicate node, Void context) {
            return "(" + (String)this.process(node.getValue(), context) + " IN " + (String)this.process(node.getValueList(), context) + ")";
        }

        @Override
        protected String visitInListExpression(InListExpression node, Void context) {
            return "(" + this.joinExpressions(node.getValues()) + ")";
        }

        @Override
        public String visitWindow(Window node, Void context) {
            ArrayList<String> parts = new ArrayList<String>();
            if (!node.getPartitionBy().isEmpty()) {
                parts.add("PARTITION BY " + this.joinExpressions(node.getPartitionBy()));
            }
            if (!node.getOrderBy().isEmpty()) {
                parts.add("ORDER BY " + ExpressionFormatter.formatSortItems(node.getOrderBy()));
            }
            if (node.getFrame().isPresent()) {
                parts.add((String)this.process((Node)node.getFrame().get(), null));
            }
            return '(' + Joiner.on((char)' ').join(parts) + ')';
        }

        @Override
        public String visitWindowFrame(WindowFrame node, Void context) {
            StringBuilder builder = new StringBuilder();
            builder.append(node.getType().toString()).append(' ');
            if (node.getEnd().isPresent()) {
                builder.append("BETWEEN ").append((String)this.process(node.getStart(), null)).append(" AND ").append((String)this.process((Node)node.getEnd().get(), null));
            } else {
                builder.append((String)this.process(node.getStart(), null));
            }
            return builder.toString();
        }

        @Override
        public String visitFrameBound(FrameBound node, Void context) {
            switch (node.getType()) {
                case UNBOUNDED_PRECEDING: {
                    return "UNBOUNDED PRECEDING";
                }
                case PRECEDING: {
                    return (String)this.process((Node)node.getValue().get(), null) + " PRECEDING";
                }
                case CURRENT_ROW: {
                    return "CURRENT ROW";
                }
                case FOLLOWING: {
                    return (String)this.process((Node)node.getValue().get(), null) + " FOLLOWING";
                }
                case UNBOUNDED_FOLLOWING: {
                    return "UNBOUNDED FOLLOWING";
                }
            }
            throw new IllegalArgumentException("unhandled type: " + (Object)((Object)node.getType()));
        }

        private String formatBinaryExpression(String operator, Expression left, Expression right) {
            return '(' + (String)this.process(left, null) + ' ' + operator + ' ' + (String)this.process(right, null) + ')';
        }

        private String joinExpressions(List<Expression> expressions) {
            return Joiner.on((String)", ").join(Iterables.transform(expressions, (Function)new Function<Expression, Object>(){

                public Object apply(Expression input) {
                    return Formatter.this.process(input, null);
                }
            }));
        }

        private static String formatIdentifier(String s) {
            return '\"' + s + '\"';
        }
    }
}

