/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampLiteral
extends Literal {
    public static final DateTimeFormatter DATE_TIME_FORMATTER;
    private final String value;
    private final long unixTime;

    public TimestampLiteral(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.value = value;
        this.unixTime = TimeUnit.MILLISECONDS.toSeconds(DATE_TIME_FORMATTER.parseMillis(value));
    }

    public String getValue() {
        return this.value;
    }

    public long getUnixTime() {
        return this.unixTime;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTimestampLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampLiteral that = (TimestampLiteral)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    static {
        DateTimeFormatter timeFormatter = new DateTimeFormatterBuilder().appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendOptional(new DateTimeFormatterBuilder().appendLiteral(':').appendSecondOfMinute(2).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendMillisOfSecond(1).toParser()).toParser()).appendOptional(new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 1, 2).toParser()).appendOptional(new DateTimeFormatterBuilder().appendLiteral(' ').appendTimeZoneId().toParser()).toFormatter();
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendOptional(new DateTimeFormatterBuilder().appendLiteral(' ').append(timeFormatter).toParser()).toFormatter().withZoneUTC();
    }
}

