/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;

public class LikePredicate
extends Expression {
    private final Expression value;
    private final Expression pattern;
    private final Expression escape;

    public LikePredicate(Expression value, Expression pattern, Expression escape) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern is null");
        this.value = value;
        this.pattern = pattern;
        this.escape = escape;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getPattern() {
        return this.pattern;
    }

    public Expression getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLikePredicate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikePredicate that = (LikePredicate)o;
        if (this.escape != null ? !this.escape.equals(that.escape) : that.escape != null) {
            return false;
        }
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + (this.escape != null ? this.escape.hashCode() : 0);
        return result;
    }
}

