/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Optional<Expression> falseValue;

    public IfExpression(Expression condition, Expression trueValue, Expression falseValue) {
        this.condition = (Expression)Preconditions.checkNotNull((Object)condition, (Object)"condition is null");
        this.trueValue = (Expression)Preconditions.checkNotNull((Object)trueValue, (Object)"trueValue is null");
        this.falseValue = Optional.fromNullable((Object)falseValue);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public Optional<Expression> getFalseValue() {
        return this.falseValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression o = (IfExpression)obj;
        return Objects.equal((Object)this.condition, (Object)o.condition) && Objects.equal((Object)this.trueValue, (Object)o.trueValue) && Objects.equal(this.falseValue, o.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.condition, this.trueValue, this.falseValue});
    }
}

