/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.ArithmeticExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NegativeExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node) {
        return new ExpressionTreeRewriter<Object>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context(context, true));
    }

    public static <C, T extends Expression> Function<Expression, T> rewriteFunction(final ExpressionRewriter<C> rewriter) {
        return new Function<Expression, T>(){

            public T apply(Expression node) {
                return ExpressionTreeRewriter.rewriteWith(rewriter, node);
            }
        };
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        private RewritingVisitor() {
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getSimpleName() + " for " + node.getClass().getName());
        }

        @Override
        protected Expression visitNegativeExpression(NegativeExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNegativeExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression child = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new NegativeExpression(child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticExpression(ArithmeticExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteArithmeticExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteComparisonExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteBetweenPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression min = ExpressionTreeRewriter.this.rewrite(node.getMin(), context.get());
            Expression max = ExpressionTreeRewriter.this.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalBinaryExpression(LogicalBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLogicalBinaryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression left = ExpressionTreeRewriter.this.rewrite(node.getLeft(), context.get());
            Expression right = ExpressionTreeRewriter.this.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new LogicalBinaryExpression(node.getType(), left, right);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNotExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIsNotNullPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteNullIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression first = ExpressionTreeRewriter.this.rewrite(node.getFirst(), context.get());
            Expression second = ExpressionTreeRewriter.this.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(first, second);
            }
            return node;
        }

        @Override
        protected Expression visitIfExpression(IfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteIfExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression condition = ExpressionTreeRewriter.this.rewrite(node.getCondition(), context.get());
            Expression trueValue = ExpressionTreeRewriter.this.rewrite(node.getTrueValue(), context.get());
            Expression falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = ExpressionTreeRewriter.this.rewrite((Expression)node.getFalseValue().get(), context.get());
            }
            if (condition != node.getCondition() || trueValue != node.getTrueValue() || falseValue != node.getFalseValue().orNull()) {
                return new IfExpression(condition, trueValue, falseValue);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSearchedCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Expression defaultValue = null;
            if (node.getDefaultValue() != null) {
                defaultValue = ExpressionTreeRewriter.this.rewrite(node.getDefaultValue(), context.get());
            }
            if (defaultValue != node.getDefaultValue() || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SearchedCaseExpression((List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSimpleCaseExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            Expression defaultValue = null;
            if (node.getDefaultValue() != null) {
                defaultValue = ExpressionTreeRewriter.this.rewrite(node.getDefaultValue(), context.get());
            }
            if (operand != node.getOperand() || defaultValue != node.getDefaultValue() || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), (Iterable)builder.build())) {
                return new SimpleCaseExpression(operand, (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteWhenClause(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression operand = ExpressionTreeRewriter.this.rewrite(node.getOperand(), context.get());
            Expression result2 = ExpressionTreeRewriter.this.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(operand, result2);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCoalesceExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : node.getOperands()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), (Iterable)builder.build())) {
                return new CoalesceExpression((List<Expression>)builder.build());
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteFunctionCall(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Window rewrittenWindow = (Window)node.getWindow().orNull();
            if (rewrittenWindow != null) {
                ImmutableList.Builder partitionBy = ImmutableList.builder();
                for (Expression expression : rewrittenWindow.getPartitionBy()) {
                    partitionBy.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
                }
                ImmutableList.Builder orderBy = ImmutableList.builder();
                for (SortItem sortItem : rewrittenWindow.getOrderBy()) {
                    Expression sortKey = ExpressionTreeRewriter.this.rewrite(sortItem.getSortKey(), context.get());
                    if (sortItem.getSortKey() != sortKey) {
                        orderBy.add((Object)new SortItem(sortKey, sortItem.getOrdering(), sortItem.getNullOrdering()));
                        continue;
                    }
                    orderBy.add((Object)sortItem);
                }
                if (!ExpressionTreeRewriter.sameElements(rewrittenWindow.getPartitionBy(), (Iterable)partitionBy.build()) || !ExpressionTreeRewriter.sameElements(rewrittenWindow.getOrderBy(), (Iterable)orderBy.build())) {
                    rewrittenWindow = new Window((List<Expression>)partitionBy.build(), (List<SortItem>)orderBy.build(), (WindowFrame)rewrittenWindow.getFrame().orNull());
                }
            }
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                arguments.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            if (!ExpressionTreeRewriter.sameElements(node.getArguments(), (Iterable)arguments.build()) || rewrittenWindow != node.getWindow().orNull()) {
                return new FunctionCall(node.getName(), rewrittenWindow, node.isDistinct(), (List<Expression>)arguments.build());
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLikePredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression pattern = ExpressionTreeRewriter.this.rewrite(node.getPattern(), context.get());
            Expression escape = null;
            if (node.getEscape() != null) {
                escape = ExpressionTreeRewriter.this.rewrite(node.getEscape(), context.get());
            }
            if (value != node.getValue() || pattern != node.getPattern() || escape != node.getEscape()) {
                return new LikePredicate(value, pattern, escape);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInPredicate(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression value = ExpressionTreeRewriter.this.rewrite(node.getValue(), context.get());
            Expression list = ExpressionTreeRewriter.this.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteInListExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Expression expression : node.getValues()) {
                builder.add((Object)ExpressionTreeRewriter.this.rewrite(expression, context.get()));
            }
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), (Iterable)builder.build())) {
                return new InListExpression((List<Expression>)builder.build());
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteSubqueryExpression(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteLiteral(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitQualifiedNameReference(QualifiedNameReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteQualifiedNameReference(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitExtract(Extract node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteExtract(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Extract(expression, node.getField());
            }
            return node;
        }

        @Override
        protected Expression visitCurrentTime(CurrentTime node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCurrentTime(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = ExpressionTreeRewriter.this.rewriter.rewriteCast(node, context.get(), ExpressionTreeRewriter.this)) != null) {
                return result;
            }
            Expression expression = ExpressionTreeRewriter.this.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Cast(expression, node.getType());
            }
            return node;
        }
    }
}

