/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateLiteral
extends Literal {
    public static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date().withZoneUTC();
    private final String value;
    private final long unixTime;

    public DateLiteral(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.value = value;
        this.unixTime = TimeUnit.MILLISECONDS.toSeconds(DATE_FORMATTER.parseMillis(value));
    }

    public String getValue() {
        return this.value;
    }

    public long getUnixTime() {
        return this.unixTime;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDateLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateLiteral that = (DateLiteral)o;
        return this.value.equals(that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

