/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TruncateTable
extends Statement {
    private final QualifiedName tableName;

    public TruncateTable(QualifiedName tableName) {
        this(Optional.empty(), tableName);
    }

    public TruncateTable(NodeLocation location, QualifiedName tableName) {
        this(Optional.of(location), tableName);
    }

    private TruncateTable(Optional<NodeLocation> location, QualifiedName tableName) {
        super(location);
        this.tableName = tableName;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTruncateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TruncateTable o = (TruncateTable)obj;
        return Objects.equals(this.tableName, o.tableName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).toString();
    }
}

