/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.TableVersionExpression;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Table
extends QueryBody {
    private final QualifiedName name;
    private final Optional<TableVersionExpression> tableVersionExpression;

    public Table(QualifiedName name) {
        this(Optional.empty(), name, Optional.empty());
    }

    public Table(NodeLocation location, QualifiedName name) {
        this(Optional.of(location), name, Optional.empty());
    }

    public Table(NodeLocation location, QualifiedName name, TableVersionExpression tableVersionExpression) {
        this(Optional.of(location), name, Optional.of(tableVersionExpression));
    }

    private Table(Optional<NodeLocation> location, QualifiedName name, Optional<TableVersionExpression> tableVersionExpression) {
        super(location);
        this.name = name;
        this.tableVersionExpression = tableVersionExpression;
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    public List<Node> getChildren() {
        if (this.tableVersionExpression.isPresent()) {
            return ImmutableList.of((Object)this.tableVersionExpression.get());
        }
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).addValue(this.tableVersionExpression).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name) && Objects.equals(this.tableVersionExpression, table.getTableVersionExpression());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public Optional<TableVersionExpression> getTableVersionExpression() {
        return this.tableVersionExpression;
    }
}

