/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GroupBy
extends Node {
    private final boolean isDistinct;
    private final List<GroupingElement> groupingElements;

    public GroupBy(boolean isDistinct, List<GroupingElement> groupingElements) {
        this(Optional.empty(), isDistinct, groupingElements);
    }

    public GroupBy(NodeLocation location, boolean isDistinct, List<GroupingElement> groupingElements) {
        this(Optional.of(location), isDistinct, groupingElements);
    }

    private GroupBy(Optional<NodeLocation> location, boolean isDistinct, List<GroupingElement> groupingElements) {
        super(location);
        this.isDistinct = isDistinct;
        this.groupingElements = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingElements));
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public List<GroupingElement> getGroupingElements() {
        return this.groupingElements;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupBy(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.groupingElements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupBy groupBy = (GroupBy)o;
        return this.isDistinct == groupBy.isDistinct && Objects.equals(this.groupingElements, groupBy.groupingElements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isDistinct, this.groupingElements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("isDistinct", this.isDistinct).add("groupingElements", this.groupingElements).toString();
    }
}

