/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.RoutineBody;
import com.facebook.presto.sql.tree.RoutineCharacteristics;
import com.facebook.presto.sql.tree.SqlParameterDeclaration;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateFunction
extends Statement {
    private final QualifiedName functionName;
    private final boolean replace;
    private final boolean temporary;
    private final List<SqlParameterDeclaration> parameters;
    private final String returnType;
    private final Optional<String> comment;
    private final RoutineCharacteristics characteristics;
    private final RoutineBody body;

    public CreateFunction(QualifiedName functionName, boolean replace, boolean temporary, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body) {
        this(Optional.empty(), replace, temporary, functionName, parameters, returnType, comment, characteristics, body);
    }

    public CreateFunction(NodeLocation location, boolean replace, boolean temporary, QualifiedName functionName, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body) {
        this(Optional.of(location), replace, temporary, functionName, parameters, returnType, comment, characteristics, body);
    }

    private CreateFunction(Optional<NodeLocation> location, boolean replace, boolean temporary, QualifiedName functionName, List<SqlParameterDeclaration> parameters, String returnType, Optional<String> comment, RoutineCharacteristics characteristics, RoutineBody body) {
        super(location);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.replace = replace;
        this.temporary = temporary;
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.characteristics = Objects.requireNonNull(characteristics, "routineCharacteristics is null");
        this.body = Objects.requireNonNull(body, "body is null");
    }

    public QualifiedName getFunctionName() {
        return this.functionName;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public List<SqlParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public RoutineCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    public RoutineBody getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().add((Object)this.body).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.temporary, this.parameters, this.returnType, this.comment, this.characteristics, this.body);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateFunction o = (CreateFunction)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.temporary, o.temporary) && Objects.equals(this.parameters, o.parameters) && Objects.equals(this.returnType, o.returnType) && Objects.equals(this.comment, o.comment) && Objects.equals(this.characteristics, o.characteristics) && Objects.equals(this.body, o.body);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("functionName", (Object)this.functionName).add("temporary", this.temporary).add("parameters", this.parameters).add("returnType", (Object)this.returnType).add("comment", this.comment).add("characteristics", (Object)this.characteristics).add("body", (Object)this.body).toString();
    }
}

