/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.WindowFrame;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Window
extends Node {
    private final List<Expression> partitionBy;
    private final Optional<OrderBy> orderBy;
    private final Optional<WindowFrame> frame;

    public Window(List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        this(Optional.empty(), partitionBy, orderBy, frame);
    }

    public Window(NodeLocation location, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        this(Optional.of(location), partitionBy, orderBy, frame);
    }

    private Window(Optional<NodeLocation> location, List<Expression> partitionBy, Optional<OrderBy> orderBy, Optional<WindowFrame> frame) {
        super(location);
        this.partitionBy = Objects.requireNonNull(partitionBy, "partitionBy is null");
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
    }

    public List<Expression> getPartitionBy() {
        return this.partitionBy;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<WindowFrame> getFrame() {
        return this.frame;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.partitionBy);
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.frame.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Window o = (Window)obj;
        return Objects.equals(this.partitionBy, o.partitionBy) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.frame, o.frame);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionBy, this.orderBy, this.frame);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("frame", this.frame).toString();
    }
}

