/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IsNotNullPredicate
extends Expression {
    private final Expression value;

    public IsNotNullPredicate(Expression value) {
        this(Optional.empty(), value);
    }

    public IsNotNullPredicate(NodeLocation location, Expression value) {
        this(Optional.of(location), value);
    }

    private IsNotNullPredicate(Optional<NodeLocation> location, Expression value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsNotNullPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNotNullPredicate that = (IsNotNullPredicate)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

