/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BindExpression
extends Expression {
    private final List<Expression> values;
    private final Expression function;

    public BindExpression(List<Expression> values, Expression function) {
        this(Optional.empty(), values, function);
    }

    public BindExpression(NodeLocation location, List<Expression> values, Expression function) {
        this(Optional.of(location), values, function);
    }

    private BindExpression(Optional<NodeLocation> location, List<Expression> values, Expression function) {
        super(location);
        this.values = Objects.requireNonNull(values, "value is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public Expression getFunction() {
        return this.function;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBindExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        return nodes.addAll(this.values).add((Object)this.function).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindExpression that = (BindExpression)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.values, this.function);
    }
}

