/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ArithmeticBinaryExpression
extends Expression {
    private final Type type;
    private final Expression left;
    private final Expression right;

    public ArithmeticBinaryExpression(Type type, Expression left, Expression right) {
        this(Optional.empty(), type, left, right);
    }

    public ArithmeticBinaryExpression(NodeLocation location, Type type, Expression left, Expression right) {
        this(Optional.of(location), type, left, right);
    }

    private ArithmeticBinaryExpression(Optional<NodeLocation> location, Type type, Expression left, Expression right) {
        super(location);
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticBinaryExpression that = (ArithmeticBinaryExpression)o;
        return this.type == that.type && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right});
    }

    public static enum Type {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULUS("%");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

