/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateTableAsSelect
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean notExists;
    private final Map<String, Expression> properties;
    private final boolean withData;
    private final Optional<String> comment;

    public CreateTableAsSelect(QualifiedName name, Query query, boolean notExists, Map<String, Expression> properties, boolean withData, Optional<String> comment) {
        this(Optional.empty(), name, query, notExists, properties, withData, comment);
    }

    public CreateTableAsSelect(NodeLocation location, QualifiedName name, Query query, boolean notExists, Map<String, Expression> properties, boolean withData, Optional<String> comment) {
        this(Optional.of(location), name, query, notExists, properties, withData, comment);
    }

    private CreateTableAsSelect(Optional<NodeLocation> location, QualifiedName name, Query query, boolean notExists, Map<String, Expression> properties, boolean withData, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.notExists = notExists;
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
        this.withData = withData;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Map<String, Expression> getProperties() {
        return this.properties;
    }

    public boolean isWithData() {
        return this.withData;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTableAsSelect(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.query);
        nodes.addAll(this.properties.values());
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.properties, this.withData, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateTableAsSelect o = (CreateTableAsSelect)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.notExists, o.notExists) && Objects.equals(this.properties, o.properties) && Objects.equals(this.withData, o.withData) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("notExists", this.notExists).add("properties", this.properties).add("withData", this.withData).add("comment", this.comment).toString();
    }
}

