/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Use
extends Statement {
    private final Optional<String> catalog;
    private final String schema;

    public Use(Optional<String> catalog, String schema) {
        this(Optional.empty(), catalog, schema);
    }

    public Use(NodeLocation location, Optional<String> catalog, String schema) {
        this(Optional.of(location), catalog, schema);
    }

    private Use(Optional<NodeLocation> location, Optional<String> catalog, String schema) {
        super(location);
        Objects.requireNonNull(catalog, "catalog is null");
        Objects.requireNonNull(schema, "schema is null");
        this.catalog = catalog;
        this.schema = schema;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUse(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog, this.schema);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Use use = (Use)o;
        if (!this.catalog.equals(use.catalog)) {
            return false;
        }
        return this.schema.equals(use.schema);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

