/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.TransactionMode;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class Isolation
extends TransactionMode {
    private final Level level;

    public Isolation(Level level) {
        this(Optional.empty(), level);
    }

    public Isolation(NodeLocation location, Level level) {
        this(Optional.of(location), level);
    }

    private Isolation(Optional<NodeLocation> location, Level level) {
        super(location);
        this.level = Objects.requireNonNull(level, "level is null");
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsolationLevel(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.level});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Isolation other = (Isolation)obj;
        return this.level == other.level;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("level", (Object)this.level).toString();
    }

    public static enum Level {
        SERIALIZABLE("SERIALIZABLE"),
        REPEATABLE_READ("REPEATABLE READ"),
        READ_COMMITTED("READ COMMITTED"),
        READ_UNCOMMITTED("READ UNCOMMITTED");

        private final String text;

        private Level(String text) {
            this.text = Objects.requireNonNull(text, "text is null");
        }

        public String getText() {
            return this.text;
        }
    }
}

