/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlBaseBaseVisitor;
import com.facebook.presto.sql.parser.SqlBaseParser;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.Approximate;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AtTimeZone;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.CallArgument;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Isolation;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowCreate;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.TransactionAccessMode;
import com.facebook.presto.sql.tree.TransactionMode;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    AstBuilder() {
    }

    @Override
    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    @Override
    public Node visitSingleExpression(SqlBaseParser.SingleExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitUse(SqlBaseParser.UseContext context) {
        return new Use(AstBuilder.getLocation(context), AstBuilder.getTextIfPresent(context.catalog), context.schema.getText());
    }

    @Override
    public Node visitCreateTableAsSelect(SqlBaseParser.CreateTableAsSelectContext context) {
        return new CreateTableAsSelect(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()), context.EXISTS() != null, this.processTableProperties(context.tableProperties()), context.NO() == null);
    }

    @Override
    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        return new CreateTable(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), this.visit(context.tableElement(), TableElement.class), context.EXISTS() != null, this.processTableProperties(context.tableProperties()));
    }

    private Map<String, Expression> processTableProperties(SqlBaseParser.TablePropertiesContext tablePropertiesContext) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        if (tablePropertiesContext != null) {
            for (SqlBaseParser.TablePropertyContext tablePropertyContext : tablePropertiesContext.tableProperty()) {
                properties.put((Object)tablePropertyContext.identifier().getText(), (Object)((Expression)this.visit((ParseTree)tablePropertyContext.expression())));
            }
        }
        return properties.build();
    }

    @Override
    public Node visitShowCreateTable(SqlBaseParser.ShowCreateTableContext context) {
        return new ShowCreate(AstBuilder.getLocation(context), ShowCreate.Type.TABLE, AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitDropView(SqlBaseParser.DropViewContext context) {
        return new DropView(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    @Override
    public Node visitInsertInto(SqlBaseParser.InsertIntoContext context) {
        return new Insert(AstBuilder.getQualifiedName(context.qualifiedName()), Optional.ofNullable(AstBuilder.getColumnAliases(context.columnAliases())), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDelete(SqlBaseParser.DeleteContext context) {
        return new Delete(AstBuilder.getLocation(context), new Table(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName())), this.visitIfPresent(context.booleanExpression(), Expression.class));
    }

    @Override
    public Node visitRenameTable(SqlBaseParser.RenameTableContext context) {
        return new RenameTable(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.from), AstBuilder.getQualifiedName(context.to));
    }

    @Override
    public Node visitRenameColumn(SqlBaseParser.RenameColumnContext context) {
        return new RenameColumn(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.tableName), context.from.getText(), context.to.getText());
    }

    @Override
    public Node visitAddColumn(SqlBaseParser.AddColumnContext context) {
        return new AddColumn(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (TableElement)this.visit((ParseTree)context.tableElement()));
    }

    @Override
    public Node visitCreateView(SqlBaseParser.CreateViewContext context) {
        return new CreateView(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.query()), context.REPLACE() != null);
    }

    @Override
    public Node visitStartTransaction(SqlBaseParser.StartTransactionContext context) {
        return new StartTransaction(this.visit(context.transactionMode(), TransactionMode.class));
    }

    @Override
    public Node visitCommit(SqlBaseParser.CommitContext context) {
        return new Commit(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitRollback(SqlBaseParser.RollbackContext context) {
        return new Rollback(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitTransactionAccessMode(SqlBaseParser.TransactionAccessModeContext context) {
        return new TransactionAccessMode(AstBuilder.getLocation(context), context.accessMode.getType() == 166);
    }

    @Override
    public Node visitIsolationLevel(SqlBaseParser.IsolationLevelContext context) {
        return (Node)this.visit((ParseTree)context.levelOfIsolation());
    }

    @Override
    public Node visitReadUncommitted(SqlBaseParser.ReadUncommittedContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.READ_UNCOMMITTED);
    }

    @Override
    public Node visitReadCommitted(SqlBaseParser.ReadCommittedContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.READ_COMMITTED);
    }

    @Override
    public Node visitRepeatableRead(SqlBaseParser.RepeatableReadContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.REPEATABLE_READ);
    }

    @Override
    public Node visitSerializable(SqlBaseParser.SerializableContext context) {
        return new Isolation(AstBuilder.getLocation(context), Isolation.Level.SERIALIZABLE);
    }

    @Override
    public Node visitCall(SqlBaseParser.CallContext context) {
        return new Call(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), this.visit(context.callArgument(), CallArgument.class));
    }

    @Override
    public Node visitPrepare(SqlBaseParser.PrepareContext context) {
        String name = context.identifier().getText();
        return new Prepare(AstBuilder.getLocation(context), name, (Statement)this.visit((ParseTree)context.statement()));
    }

    @Override
    public Node visitDeallocate(SqlBaseParser.DeallocateContext context) {
        String name = context.identifier().getText();
        return new Deallocate(AstBuilder.getLocation(context), name);
    }

    @Override
    public Node visitExecute(SqlBaseParser.ExecuteContext context) {
        String name = context.identifier().getText();
        return new Execute(AstBuilder.getLocation(context), name);
    }

    @Override
    public Node visitQuery(SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(AstBuilder.getLocation(context), this.visitIfPresent(context.with(), With.class), body.getQueryBody(), body.getOrderBy(), body.getLimit(), body.getApproximate());
    }

    @Override
    public Node visitWith(SqlBaseParser.WithContext context) {
        return new With(AstBuilder.getLocation(context), context.RECURSIVE() != null, this.visit(context.namedQuery(), WithQuery.class));
    }

    @Override
    public Node visitNamedQuery(SqlBaseParser.NamedQueryContext context) {
        return new WithQuery(AstBuilder.getLocation(context), context.name.getText(), (Query)this.visit((ParseTree)context.query()), Optional.ofNullable(AstBuilder.getColumnAliases(context.columnAliases())));
    }

    @Override
    public Node visitQueryNoWith(SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(AstBuilder.getLocation(context), Optional.empty(), (QueryBody)new QuerySpecification(AstBuilder.getLocation(context), query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit)), (List<SortItem>)ImmutableList.of(), Optional.empty(), AstBuilder.getTextIfPresent(context.confidence).map(confidence -> new Approximate(AstBuilder.getLocation(context), (String)confidence)));
        }
        return new Query(AstBuilder.getLocation(context), Optional.empty(), term, this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit), AstBuilder.getTextIfPresent(context.confidence).map(confidence -> new Approximate(AstBuilder.getLocation(context), (String)confidence)));
    }

    @Override
    public Node visitQuerySpecification(SqlBaseParser.QuerySpecificationContext context) {
        Optional<Relation> from = Optional.empty();
        List<Relation> relations = this.visit(context.relation(), Relation.class);
        if (!relations.isEmpty()) {
            Iterator<Relation> iterator = relations.iterator();
            Relation relation = iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(AstBuilder.getLocation(context), Join.Type.IMPLICIT, relation, iterator.next(), Optional.empty());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(AstBuilder.getLocation(context), new Select(AstBuilder.getLocation(context.SELECT()), AstBuilder.isDistinct(context.setQuantifier()), this.visit(context.selectItem(), SelectItem.class)), from, this.visitIfPresent(context.where, Expression.class), this.visitIfPresent(context.groupBy(), GroupBy.class), this.visitIfPresent(context.having, Expression.class), (List<SortItem>)ImmutableList.of(), Optional.empty());
    }

    @Override
    public Node visitGroupBy(SqlBaseParser.GroupByContext context) {
        return new GroupBy(AstBuilder.getLocation(context), AstBuilder.isDistinct(context.setQuantifier()), this.visit(context.groupingElement(), GroupingElement.class));
    }

    @Override
    public Node visitSingleGroupingSet(SqlBaseParser.SingleGroupingSetContext context) {
        return new SimpleGroupBy(AstBuilder.getLocation(context), this.visit(context.groupingExpressions().expression(), Expression.class));
    }

    @Override
    public Node visitRollup(SqlBaseParser.RollupContext context) {
        return new Rollup(AstBuilder.getLocation(context), context.qualifiedName().stream().map(AstBuilder::getQualifiedName).collect(Collectors.toList()));
    }

    @Override
    public Node visitCube(SqlBaseParser.CubeContext context) {
        return new Cube(AstBuilder.getLocation(context), context.qualifiedName().stream().map(AstBuilder::getQualifiedName).collect(Collectors.toList()));
    }

    @Override
    public Node visitMultipleGroupingSets(SqlBaseParser.MultipleGroupingSetsContext context) {
        return new GroupingSets(AstBuilder.getLocation(context), context.groupingSet().stream().map(groupingSet -> groupingSet.qualifiedName().stream().map(AstBuilder::getQualifiedName).collect(Collectors.toList())).collect(Collectors.toList()));
    }

    @Override
    public Node visitSetOperation(SqlBaseParser.SetOperationContext context) {
        QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
        boolean distinct = context.setQuantifier() == null || context.setQuantifier().DISTINCT() != null;
        switch (context.operator.getType()) {
            case 133: {
                return new Union(AstBuilder.getLocation(context.UNION()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 135: {
                return new Intersect(AstBuilder.getLocation(context.INTERSECT()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            }
            case 134: {
                return new Except(AstBuilder.getLocation(context.EXCEPT()), (Relation)left, (Relation)right, distinct);
            }
        }
        throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
    }

    @Override
    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        if (context.qualifiedName() != null) {
            return new AllColumns(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
        }
        return new AllColumns(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        Optional<String> alias = AstBuilder.getTextIfPresent(context.identifier());
        return new SingleColumn(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), alias);
    }

    @Override
    public Node visitTable(SqlBaseParser.TableContext context) {
        return new Table(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubquery(SqlBaseParser.SubqueryContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.queryNoWith()));
    }

    @Override
    public Node visitInlineTable(SqlBaseParser.InlineTableContext context) {
        return new Values(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitExplain(SqlBaseParser.ExplainContext context) {
        return new Explain(AstBuilder.getLocation(context), context.ANALYZE() != null, (Statement)this.visit((ParseTree)context.statement()), this.visit(context.explainOption(), ExplainOption.class));
    }

    @Override
    public Node visitExplainFormat(SqlBaseParser.ExplainFormatContext context) {
        switch (context.value.getType()) {
            case 117: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.GRAPHVIZ);
            }
            case 116: {
                return new ExplainFormat(AstBuilder.getLocation(context), ExplainFormat.Type.TEXT);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN format: " + context.value.getText());
    }

    @Override
    public Node visitExplainType(SqlBaseParser.ExplainTypeContext context) {
        switch (context.value.getType()) {
            case 118: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.LOGICAL);
            }
            case 119: {
                return new ExplainType(AstBuilder.getLocation(context), ExplainType.Type.DISTRIBUTED);
            }
        }
        throw new IllegalArgumentException("Unsupported EXPLAIN type: " + context.value.getText());
    }

    @Override
    public Node visitShowTables(SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(AstBuilder.getLocation(context), Optional.ofNullable(context.qualifiedName()).map(AstBuilder::getQualifiedName), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowSchemas(SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(AstBuilder.getLocation(context), AstBuilder.getTextIfPresent(context.identifier()), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowCatalogs(SqlBaseParser.ShowCatalogsContext context) {
        return new ShowCatalogs(AstBuilder.getLocation(context), AstBuilder.getTextIfPresent(context.pattern).map(AstBuilder::unquote));
    }

    @Override
    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitShowPartitions(SqlBaseParser.ShowPartitionsContext context) {
        return new ShowPartitions(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), this.visitIfPresent(context.booleanExpression(), Expression.class), this.visit(context.sortItem(), SortItem.class), AstBuilder.getTextIfPresent(context.limit));
    }

    @Override
    public Node visitShowCreateView(SqlBaseParser.ShowCreateViewContext context) {
        return new ShowCreate(AstBuilder.getLocation(context), ShowCreate.Type.VIEW, AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitShowFunctions(SqlBaseParser.ShowFunctionsContext context) {
        return new ShowFunctions(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitShowSession(SqlBaseParser.ShowSessionContext context) {
        return new ShowSession(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitSetSession(SqlBaseParser.SetSessionContext context) {
        return new SetSession(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitResetSession(SqlBaseParser.ResetSessionContext context) {
        return new ResetSession(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitGrant(SqlBaseParser.GrantContext context) {
        String grantee = context.grantee.getText();
        Optional<List<String>> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        return new Grant(AstBuilder.getLocation(context), privileges, context.TABLE() != null, AstBuilder.getQualifiedName(context.qualifiedName()), grantee, context.OPTION() != null);
    }

    @Override
    public Node visitRevoke(SqlBaseParser.RevokeContext context) {
        Optional<Object> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        return new Revoke(AstBuilder.getLocation(context), context.OPTION() != null, privileges, context.TABLE() != null, AstBuilder.getQualifiedName(context.qualifiedName()), context.grantee.getText());
    }

    @Override
    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    @Override
    public Node visitLogicalBinary(SqlBaseParser.LogicalBinaryContext context) {
        return new LogicalBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getLogicalBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(AstBuilder.getLocation(context), Join.Type.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                List<String> columns = context.joinCriteria().identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
                criteria = new JoinUsing(columns);
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        Join.Type joinType = context.joinType().LEFT() != null ? Join.Type.LEFT : (context.joinType().RIGHT() != null ? Join.Type.RIGHT : (context.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(AstBuilder.getLocation(context), joinType, left, right, Optional.of(criteria));
    }

    @Override
    public Node visitSampledRelation(SqlBaseParser.SampledRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.aliasedRelation());
        if (context.TABLESAMPLE() == null) {
            return child;
        }
        Optional<List<Expression>> stratifyOn = Optional.empty();
        if (context.STRATIFY() != null) {
            stratifyOn = Optional.of(this.visit(context.stratify, Expression.class));
        }
        return new SampledRelation(AstBuilder.getLocation(context), child, AstBuilder.getSamplingMethod((Token)context.sampleType().getChild(0).getPayload()), (Expression)this.visit((ParseTree)context.percentage), context.RESCALED() != null, stratifyOn);
    }

    @Override
    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.identifier() == null) {
            return child;
        }
        return new AliasedRelation(AstBuilder.getLocation(context), child, context.identifier().getText(), AstBuilder.getColumnAliases(context.columnAliases()));
    }

    @Override
    public Node visitTableName(SqlBaseParser.TableNameContext context) {
        return new Table(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()));
    }

    @Override
    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitUnnest(SqlBaseParser.UnnestContext context) {
        return new Unnest(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class), context.ORDINALITY() != null);
    }

    @Override
    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    @Override
    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    @Override
    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(AstBuilder.getLocation(context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(AstBuilder.getLocation(context), ComparisonExpression.Type.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(AstBuilder.getLocation(context), expression);
        }
        return expression;
    }

    @Override
    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(AstBuilder.getLocation(context), child);
        }
        return new IsNotNullPredicate(AstBuilder.getLocation(context), child);
    }

    @Override
    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression escape = null;
        if (context.escape != null) {
            escape = (Expression)this.visit((ParseTree)context.escape);
        }
        Expression result = new LikePredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), escape);
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new InListExpression(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query())));
        if (context.NOT() != null) {
            result = new NotExpression(AstBuilder.getLocation(context), result);
        }
        return result;
    }

    @Override
    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
        switch (context.operator.getType()) {
            case 186: {
                return ArithmeticUnaryExpression.negative(AstBuilder.getLocation(context), child);
            }
            case 185: {
                return ArithmeticUnaryExpression.positive(AstBuilder.getLocation(context), child);
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
    }

    @Override
    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticBinaryExpression(AstBuilder.getLocation(context.operator), AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    @Override
    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(AstBuilder.getLocation(context.CONCAT()), QualifiedName.of("concat"), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
    }

    @Override
    public Node visitAtTimeZone(SqlBaseParser.AtTimeZoneContext context) {
        return new AtTimeZone(AstBuilder.getLocation(context.AT()), (Expression)this.visit((ParseTree)context.valueExpression()), (Expression)this.visit((ParseTree)context.timeZoneSpecifier()));
    }

    @Override
    public Node visitTimeZoneInterval(SqlBaseParser.TimeZoneIntervalContext context) {
        return (Node)this.visit((ParseTree)context.interval());
    }

    @Override
    public Node visitTimeZoneString(SqlBaseParser.TimeZoneStringContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    @Override
    public Node visitRowConstructor(SqlBaseParser.RowConstructorContext context) {
        return new Row(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitArrayConstructor(SqlBaseParser.ArrayConstructorContext context) {
        return new ArrayConstructor(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitCast(SqlBaseParser.CastContext context) {
        boolean isTryCast = context.TRY_CAST() != null;
        return new Cast(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), AstBuilder.getType(context.type()), isTryCast);
    }

    @Override
    public Node visitSpecialDateTimeFunction(SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Type type = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(AstBuilder.getLocation(context), type, (Integer)Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(AstBuilder.getLocation(context), type);
    }

    @Override
    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        Extract.Field field;
        String fieldString = context.identifier().getText();
        try {
            field = Extract.Field.valueOf(fieldString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(String.format("Invalid EXTRACT field: %s", fieldString), null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
        }
        return new Extract(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), field);
    }

    @Override
    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("substr"), this.visit(context.valueExpression(), Expression.class));
    }

    @Override
    public Node visitPosition(SqlBaseParser.PositionContext context) {
        List arguments = Lists.reverse(this.visit(context.valueExpression(), Expression.class));
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("strpos"), (List<Expression>)arguments);
    }

    @Override
    public Node visitNormalize(SqlBaseParser.NormalizeContext context) {
        Expression str = (Expression)this.visit((ParseTree)context.valueExpression());
        String normalForm = Optional.ofNullable(context.normalForm()).map(RuleContext::getText).orElse("NFC");
        return new FunctionCall(AstBuilder.getLocation(context), QualifiedName.of("normalize"), (List<Expression>)ImmutableList.of((Object)str, (Object)new StringLiteral(AstBuilder.getLocation(context), normalForm)));
    }

    @Override
    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    @Override
    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression(AstBuilder.getLocation(context), (Query)this.visit((ParseTree)context.query()));
    }

    @Override
    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        return new DereferenceExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.base), context.fieldName.getText());
    }

    @Override
    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        return new QualifiedNameReference(AstBuilder.getLocation(context), QualifiedName.of(context.getText()));
    }

    @Override
    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.valueExpression()), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(AstBuilder.getLocation(context), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent(context.elseExpression, Expression.class));
    }

    @Override
    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    @Override
    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        Optional<Window> window = this.visitIfPresent(context.over(), Window.class);
        QualifiedName name = AstBuilder.getQualifiedName(context.qualifiedName());
        boolean distinct = AstBuilder.isDistinct(context.setQuantifier());
        if (name.toString().equalsIgnoreCase("if")) {
            AstBuilder.check(context.expression().size() == 2 || context.expression().size() == 3, "Invalid number of arguments for 'if' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'if' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'if' function", context);
            Expression elseExpression = null;
            if (context.expression().size() == 3) {
                elseExpression = (Expression)this.visit((ParseTree)context.expression(2));
            }
            return new IfExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)), elseExpression);
        }
        if (name.toString().equalsIgnoreCase("nullif")) {
            AstBuilder.check(context.expression().size() == 2, "Invalid number of arguments for 'nullif' function", context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'nullif' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", context);
            return new NullIfExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)));
        }
        if (name.toString().equalsIgnoreCase("coalesce")) {
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'coalesce' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'coalesce' function", context);
            return new CoalesceExpression(AstBuilder.getLocation(context), this.visit(context.expression(), Expression.class));
        }
        if (name.toString().equalsIgnoreCase("try")) {
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'try' function", context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'try' function", context);
            return new TryExpression(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)Iterables.getOnlyElement(context.expression())));
        }
        return new FunctionCall(AstBuilder.getLocation(context), AstBuilder.getQualifiedName(context.qualifiedName()), window, distinct, this.visit(context.expression(), Expression.class));
    }

    @Override
    public Node visitLambda(SqlBaseParser.LambdaContext context) {
        List<String> arguments = context.identifier().stream().map(RuleContext::getText).collect(Collectors.toList());
        Expression body = (Expression)this.visit((ParseTree)context.expression());
        return new LambdaExpression(arguments, body);
    }

    @Override
    public Node visitOver(SqlBaseParser.OverContext context) {
        return new Window(AstBuilder.getLocation(context), this.visit(context.partition, Expression.class), this.visit(context.sortItem(), SortItem.class), this.visitIfPresent(context.windowFrame(), WindowFrame.class));
    }

    @Override
    public Node visitTableElement(SqlBaseParser.TableElementContext context) {
        return new TableElement(AstBuilder.getLocation(context), context.identifier().getText(), AstBuilder.getType(context.type()));
    }

    @Override
    public Node visitSortItem(SqlBaseParser.SortItemContext context) {
        return new SortItem(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    @Override
    public Node visitWindowFrame(SqlBaseParser.WindowFrameContext context) {
        return new WindowFrame(AstBuilder.getLocation(context), AstBuilder.getFrameType(context.frameType), (FrameBound)this.visit((ParseTree)context.start), this.visitIfPresent(context.end, FrameBound.class));
    }

    @Override
    public Node visitUnboundedFrame(SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(AstBuilder.getLocation(context), AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    @Override
    public Node visitBoundedFrame(SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(AstBuilder.getLocation(context), AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitCurrentRowBound(SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(AstBuilder.getLocation(context), FrameBound.Type.CURRENT_ROW);
    }

    @Override
    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return new NullLiteral(AstBuilder.getLocation(context));
    }

    @Override
    public Node visitStringLiteral(SqlBaseParser.StringLiteralContext context) {
        return new StringLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText()));
    }

    @Override
    public Node visitBinaryLiteral(SqlBaseParser.BinaryLiteralContext context) {
        String raw = context.BINARY_LITERAL().getText();
        return new BinaryLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(raw.substring(1)));
    }

    @Override
    public Node visitTypeConstructor(SqlBaseParser.TypeConstructorContext context) {
        String type = context.identifier().getText();
        String value = AstBuilder.unquote(context.STRING().getText());
        if (type.equalsIgnoreCase("time")) {
            return new TimeLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return new TimestampLiteral(AstBuilder.getLocation(context), value);
        }
        if (type.equalsIgnoreCase("decimal")) {
            return new DecimalLiteral(AstBuilder.getLocation(context), value);
        }
        return new GenericLiteral(AstBuilder.getLocation(context), type, value);
    }

    @Override
    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        return new LongLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        return new DoubleLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitBooleanValue(SqlBaseParser.BooleanValueContext context) {
        return new BooleanLiteral(AstBuilder.getLocation(context), context.getText());
    }

    @Override
    public Node visitInterval(SqlBaseParser.IntervalContext context) {
        return new IntervalLiteral(AstBuilder.getLocation(context), AstBuilder.unquote(context.STRING().getText()), Optional.ofNullable(context.sign).map(AstBuilder::getIntervalSign).orElse(IntervalLiteral.Sign.POSITIVE), AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload()), Optional.ofNullable(context.to).map(x -> x.getChild(0).getPayload()).map(Token.class::cast).map(AstBuilder::getIntervalFieldType));
    }

    @Override
    public Node visitPositionalArgument(SqlBaseParser.PositionalArgumentContext context) {
        return new CallArgument(AstBuilder.getLocation(context), (Expression)this.visit((ParseTree)context.expression()));
    }

    @Override
    public Node visitNamedArgument(SqlBaseParser.NamedArgumentContext context) {
        return new CallArgument(AstBuilder.getLocation(context), context.identifier().getText(), (Expression)this.visit((ParseTree)context.expression()));
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private static QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        List<String> parts = context.identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
        return QualifiedName.of(parts);
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    private static Optional<String> getTextIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(ParseTree::getText);
    }

    private static Optional<String> getTextIfPresent(Token token) {
        return Optional.ofNullable(token).map(Token::getText);
    }

    private static List<String> getColumnAliases(SqlBaseParser.ColumnAliasesContext columnAliasesContext) {
        if (columnAliasesContext == null) {
            return null;
        }
        return columnAliasesContext.identifier().stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    private static ArithmeticBinaryExpression.Type getArithmeticBinaryOperator(Token operator) {
        switch (operator.getType()) {
            case 185: {
                return ArithmeticBinaryExpression.Type.ADD;
            }
            case 186: {
                return ArithmeticBinaryExpression.Type.SUBTRACT;
            }
            case 187: {
                return ArithmeticBinaryExpression.Type.MULTIPLY;
            }
            case 188: {
                return ArithmeticBinaryExpression.Type.DIVIDE;
            }
            case 189: {
                return ArithmeticBinaryExpression.Type.MODULUS;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
    }

    private static ComparisonExpression.Type getComparisonOperator(Token symbol) {
        switch (symbol.getType()) {
            case 179: {
                return ComparisonExpression.Type.EQUAL;
            }
            case 180: {
                return ComparisonExpression.Type.NOT_EQUAL;
            }
            case 181: {
                return ComparisonExpression.Type.LESS_THAN;
            }
            case 182: {
                return ComparisonExpression.Type.LESS_THAN_OR_EQUAL;
            }
            case 183: {
                return ComparisonExpression.Type.GREATER_THAN;
            }
            case 184: {
                return ComparisonExpression.Type.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
    }

    private static CurrentTime.Type getDateTimeFunctionType(Token token) {
        switch (token.getType()) {
            case 65: {
                return CurrentTime.Type.DATE;
            }
            case 66: {
                return CurrentTime.Type.TIME;
            }
            case 67: {
                return CurrentTime.Type.TIMESTAMP;
            }
            case 68: {
                return CurrentTime.Type.LOCALTIME;
            }
            case 69: {
                return CurrentTime.Type.LOCALTIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unsupported special function: " + token.getText());
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        switch (token.getType()) {
            case 58: {
                return IntervalLiteral.IntervalField.YEAR;
            }
            case 59: {
                return IntervalLiteral.IntervalField.MONTH;
            }
            case 60: {
                return IntervalLiteral.IntervalField.DAY;
            }
            case 61: {
                return IntervalLiteral.IntervalField.HOUR;
            }
            case 62: {
                return IntervalLiteral.IntervalField.MINUTE;
            }
            case 63: {
                return IntervalLiteral.IntervalField.SECOND;
            }
        }
        throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        switch (token.getType()) {
            case 186: {
                return IntervalLiteral.Sign.NEGATIVE;
            }
            case 185: {
                return IntervalLiteral.Sign.POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unsupported sign: " + token.getText());
    }

    private static WindowFrame.Type getFrameType(Token type) {
        switch (type.getType()) {
            case 88: {
                return WindowFrame.Type.RANGE;
            }
            case 89: {
                return WindowFrame.Type.ROWS;
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 91: {
                return FrameBound.Type.PRECEDING;
            }
            case 92: {
                return FrameBound.Type.FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        switch (token.getType()) {
            case 91: {
                return FrameBound.Type.UNBOUNDED_PRECEDING;
            }
            case 92: {
                return FrameBound.Type.UNBOUNDED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
    }

    private static SampledRelation.Type getSamplingMethod(Token token) {
        switch (token.getType()) {
            case 138: {
                return SampledRelation.Type.BERNOULLI;
            }
            case 137: {
                return SampledRelation.Type.SYSTEM;
            }
            case 139: {
                return SampledRelation.Type.POISSONIZED;
            }
        }
        throw new IllegalArgumentException("Unsupported sampling method: " + token.getText());
    }

    private static LogicalBinaryExpression.Type getLogicalBinaryOperator(Token token) {
        switch (token.getType()) {
            case 31: {
                return LogicalBinaryExpression.Type.AND;
            }
            case 30: {
                return LogicalBinaryExpression.Type.OR;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + token.getText());
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        switch (token.getType()) {
            case 43: {
                return SortItem.NullOrdering.FIRST;
            }
            case 44: {
                return SortItem.NullOrdering.LAST;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        switch (token.getType()) {
            case 46: {
                return SortItem.Ordering.ASCENDING;
            }
            case 47: {
                return SortItem.Ordering.DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
    }

    private static String getType(SqlBaseParser.TypeContext type) {
        if (type.baseType() != null) {
            String signature = type.baseType().getText();
            if (!type.typeParameter().isEmpty()) {
                String typeParameterSignature = type.typeParameter().stream().map(AstBuilder::typeParameterToString).collect(Collectors.joining(","));
                signature = signature + "(" + typeParameterSignature + ")";
            }
            return signature;
        }
        if (type.ARRAY() != null) {
            return "ARRAY(" + AstBuilder.getType(type.type(0)) + ")";
        }
        if (type.MAP() != null) {
            return "MAP(" + AstBuilder.getType(type.type(0)) + "," + AstBuilder.getType(type.type(1)) + ")";
        }
        if (type.ROW() != null) {
            StringBuilder builder = new StringBuilder("(");
            for (int i = 0; i < type.identifier().size(); ++i) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(type.identifier(i).getText()).append(" ").append(AstBuilder.getType(type.type(i)));
            }
            builder.append(")");
            return "ROW" + builder.toString();
        }
        throw new IllegalArgumentException("Unsupported type specification: " + type.getText());
    }

    private static String typeParameterToString(SqlBaseParser.TypeParameterContext typeParameter) {
        if (typeParameter.INTEGER_VALUE() != null) {
            return typeParameter.INTEGER_VALUE().toString();
        }
        if (typeParameter.type() != null) {
            return AstBuilder.getType(typeParameter.type());
        }
        throw new IllegalArgumentException("Unsupported typeParameter: " + typeParameter.getText());
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine());
        }
    }

    public static NodeLocation getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return AstBuilder.getLocation(terminalNode.getSymbol());
    }

    public static NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return AstBuilder.getLocation(parserRuleContext.getStart());
    }

    public static NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return new NodeLocation(token.getLine(), token.getCharPositionInLine());
    }
}

