/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final Optional<Relation> from;
    private final Optional<Expression> where;
    private final List<Expression> groupBy;
    private final Optional<Expression> having;
    private final List<SortItem> orderBy;
    private final Optional<String> limit;

    public QuerySpecification(Select select, Optional<Relation> from, Optional<Expression> where, List<Expression> groupBy, Optional<Expression> having, List<SortItem> orderBy, Optional<String> limit) {
        Preconditions.checkNotNull((Object)select, (Object)"select is null");
        Preconditions.checkNotNull(from, (Object)"from is null");
        Preconditions.checkNotNull(where, (Object)"where is null");
        Preconditions.checkNotNull(groupBy, (Object)"groupBy is null");
        Preconditions.checkNotNull(having, (Object)"having is null");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkNotNull(limit, (Object)"limit is null");
        this.select = select;
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    public Select getSelect() {
        return this.select;
    }

    public Optional<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public List<Expression> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<String> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("select", (Object)this.select).add("from", this.from).add("where", this.where.orElse(null)).add("groupBy", this.groupBy).add("having", this.having.orElse(null)).add("orderBy", this.orderBy).add("limit", this.limit.orElse(null)).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuerySpecification o = (QuerySpecification)obj;
        return Objects.equals(this.select, o.select) && Objects.equals(this.from, o.from) && Objects.equals(this.where, o.where) && Objects.equals(this.groupBy, o.groupBy) && Objects.equals(this.having, o.having) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.orderBy, this.limit);
    }
}

