/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Optional<Expression> falseValue;

    public IfExpression(Expression condition, Expression trueValue, Expression falseValue) {
        this.condition = (Expression)Preconditions.checkNotNull((Object)condition, (Object)"condition is null");
        this.trueValue = (Expression)Preconditions.checkNotNull((Object)trueValue, (Object)"trueValue is null");
        this.falseValue = Optional.ofNullable(falseValue);
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public Optional<Expression> getFalseValue() {
        return this.falseValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression o = (IfExpression)obj;
        return Objects.equals(this.condition, o.condition) && Objects.equals(this.trueValue, o.trueValue) && Objects.equals(this.falseValue, o.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.trueValue, this.falseValue);
    }
}

