/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.type;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.type.PrestoTypes;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public final class ObjectInspectors {
    private ObjectInspectors() {
    }

    public static ObjectInspector create(Type type, TypeManager typeManager) {
        TypeSignature typeSignature = type.getTypeSignature();
        switch (typeSignature.getBase()) {
            case "unknown": {
                return PrimitiveObjectInspectorFactory.javaVoidObjectInspector;
            }
            case "bigint": {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }
            case "integer": {
                return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
            }
            case "smallint": {
                return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
            }
            case "tinyint": {
                return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
            }
            case "boolean": {
                return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
            }
            case "date": {
                return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
            }
            case "decimal": {
                DecimalType dt = PrestoTypes.createDecimalType(typeSignature);
                return new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(dt.getPrecision(), dt.getScale()));
            }
            case "real": {
                return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
            }
            case "double": {
                return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
            }
            case "timestamp": {
                return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
            }
            case "varbinary": {
                return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
            }
            case "varchar": {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
            case "char": {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
            case "row": {
                if (!(type instanceof RowType)) break;
                return ObjectInspectors.createForRow((RowType)type, typeManager);
            }
            case "array": {
                if (!(type instanceof ArrayType)) break;
                return ObjectInspectors.createForArray((ArrayType)type, typeManager);
            }
            case "map": {
                if (!(type instanceof MapType)) break;
                return ObjectInspectors.createForMap((MapType)type, typeManager);
            }
        }
        throw HiveFunctionErrorCode.unsupportedType(type);
    }

    private static ObjectInspector createForRow(RowType rowType, TypeManager typeManager) {
        List fields = rowType.getFields();
        int numField = fields.size();
        ArrayList<String> fieldNames = new ArrayList<String>(numField);
        ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>(numField);
        ArrayList<String> comments = new ArrayList<String>(numField);
        for (int i = 0; i < numField; ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            String fieldName = field.getName().orElse("col" + i);
            fieldNames.add(fieldName);
            fieldInspectors.add(ObjectInspectors.create(field.getType(), typeManager));
            comments.add(fieldName);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldInspectors, comments);
    }

    private static ObjectInspector createForMap(MapType mapType, TypeManager typeManager) {
        ObjectInspector keyInspector = ObjectInspectors.create(mapType.getKeyType(), typeManager);
        ObjectInspector valueInspector = ObjectInspectors.create(mapType.getValueType(), typeManager);
        return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyInspector, (ObjectInspector)valueInspector);
    }

    private static ObjectInspector createForArray(ArrayType arrayType, TypeManager typeManager) {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectors.create(arrayType.getElementType(), typeManager));
    }
}

