/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.HiveFunction;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunctionImplementation;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunctionImplementationFactory;
import com.facebook.presto.hive.functions.type.ObjectInspectors;
import com.facebook.presto.hive.functions.type.PrestoTypes;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.google.common.base.Verify;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class HiveAggregationFunction
extends HiveFunction {
    private final FunctionMetadata functionMetadata;
    private final HiveAggregationFunctionImplementationFactory factory;

    public static HiveAggregationFunction createHiveAggregateFunction(Class<?> cls, QualifiedObjectName name, List<TypeSignature> argumentTypes, TypeManager typeManager) {
        try {
            List<Type> inputTypes = argumentTypes.stream().map(arg_0 -> ((TypeManager)typeManager).getType(arg_0)).collect(Collectors.toList());
            ObjectInspector[] inputInspectors = (ObjectInspector[])inputTypes.stream().map(inputType -> ObjectInspectors.create(inputType, typeManager)).toArray(ObjectInspector[]::new);
            ThreadLocal<GenericUDAFEvaluator> partialEvaluatorThreadLocal = ThreadLocal.withInitial(() -> {
                try {
                    GenericUDAFEvaluator partialEvaluator = HiveAggregationFunction.getGenericUDAFEvaluator(cls, inputInspectors);
                    partialEvaluator.init(GenericUDAFEvaluator.Mode.PARTIAL1, inputInspectors);
                    return partialEvaluator;
                }
                catch (HiveException e) {
                    throw HiveFunctionErrorCode.initializationError(e);
                }
            });
            GenericUDAFEvaluator partialEvaluator = partialEvaluatorThreadLocal.get();
            ObjectInspector intermediateInspector = partialEvaluator.init(GenericUDAFEvaluator.Mode.PARTIAL1, inputInspectors);
            Type intermediateType = PrestoTypes.fromObjectInspector(intermediateInspector, typeManager);
            ThreadLocal<GenericUDAFEvaluator> finalEvaluatorThreadLocal = ThreadLocal.withInitial(() -> {
                try {
                    GenericUDAFEvaluator finalEvaluator = HiveAggregationFunction.getGenericUDAFEvaluator(cls, inputInspectors);
                    finalEvaluator.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{intermediateInspector});
                    return finalEvaluator;
                }
                catch (HiveException e) {
                    throw HiveFunctionErrorCode.initializationError(e);
                }
            });
            GenericUDAFEvaluator finalEvaluator = finalEvaluatorThreadLocal.get();
            ObjectInspector outputInspector = finalEvaluator.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{intermediateInspector});
            Type outputType = PrestoTypes.fromObjectInspector(outputInspector, typeManager);
            Signature signature = new Signature(name, FunctionKind.AGGREGATE, outputType.getTypeSignature(), argumentTypes);
            HiveAggregationFunctionImplementationFactory factory = new HiveAggregationFunctionImplementationFactory(signature, inputTypes, intermediateType, outputType, partialEvaluatorThreadLocal::get, finalEvaluatorThreadLocal::get, inputInspectors, intermediateInspector, outputInspector);
            return new HiveAggregationFunction(name, signature, "", factory);
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.initializationError(e);
        }
    }

    private HiveAggregationFunction(QualifiedObjectName name, Signature signature, String description, HiveAggregationFunctionImplementationFactory factory) {
        super(name, signature, false, true, true, description);
        this.factory = factory;
        this.functionMetadata = new FunctionMetadata(name, signature.getArgumentTypes(), signature.getReturnType(), FunctionKind.AGGREGATE, FunctionImplementationType.JAVA, true, true);
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public HiveAggregationFunctionImplementation getImplementation() {
        return this.factory.create();
    }

    private static GenericUDAFEvaluator getGenericUDAFEvaluator(Class<?> cls, ObjectInspector[] arguments) throws HiveException {
        GenericUDAFResolver resolver = HiveAggregationFunction.createGenericUDAFResolver(cls);
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(arguments, false, false, false);
        if (resolver instanceof GenericUDAFResolver2) {
            return ((GenericUDAFResolver2)resolver).getEvaluator((GenericUDAFParameterInfo)info);
        }
        return resolver.getEvaluator(info.getParameters());
    }

    private static GenericUDAFResolver createGenericUDAFResolver(Class<?> cls) throws HiveException {
        try {
            if (GenericUDAFResolver.class.isAssignableFrom(cls)) {
                return (GenericUDAFResolver)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (UDAF.class.isAssignableFrom(cls)) {
                Object udaf = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                Verify.verify((boolean)(udaf instanceof UDAF));
                return new GenericUDAFBridge((UDAF)udaf);
            }
        }
        catch (Exception e) {
            throw new HiveException(String.format("Instantiating %s error", cls), (Throwable)e);
        }
        throw HiveFunctionErrorCode.unsupportedFunctionType(cls);
    }

    public SqlFunctionVisibility getVisibility() {
        return null;
    }
}

