/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import com.facebook.presto.hive.functions.type.ObjectEncoder;
import java.util.function.Supplier;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

public final class HiveAccumulatorInvoker {
    private final Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier;
    private final Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier;
    private final ObjectEncoder objectEncoder;
    private final Type outputType;

    public HiveAccumulatorInvoker(Supplier<GenericUDAFEvaluator> partialEvaluatorSupplier, Supplier<GenericUDAFEvaluator> finalEvaluatorSupplier, ObjectEncoder objectEncoder, Type outputType) {
        this.partialEvaluatorSupplier = partialEvaluatorSupplier;
        this.finalEvaluatorSupplier = finalEvaluatorSupplier;
        this.objectEncoder = objectEncoder;
        this.outputType = outputType;
    }

    public final GenericUDAFEvaluator.AggregationBuffer newAggregationBuffer() {
        try {
            return this.partialEvaluatorSupplier.get().getNewAggregationBuffer();
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }

    public final void iterate(HiveAccumulatorState state, Object ... parameters) {
        try {
            this.partialEvaluatorSupplier.get().iterate(state.getAggregationBuffer(), parameters);
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }

    public final void combine(HiveAccumulatorState state, HiveAccumulatorState otherState) {
        try {
            Object partial = this.partialEvaluatorSupplier.get().terminatePartial(otherState.getAggregationBuffer());
            this.finalEvaluatorSupplier.get().merge(state.getAggregationBuffer(), partial);
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }

    public final void output(HiveAccumulatorState state, BlockBuilder out) {
        try {
            Object terminate = this.finalEvaluatorSupplier.get().terminate(state.getAggregationBuffer());
            if (terminate == null) {
                out.appendNull();
            } else {
                TypeUtils.writeNativeValue((Type)this.outputType, (BlockBuilder)out, (Object)this.objectEncoder.encode(terminate));
            }
        }
        catch (HiveException e) {
            throw HiveFunctionErrorCode.executionError(e);
        }
    }
}

