/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.predicate.Primitives;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.hive.functions.gen.CompilerUtils;
import com.facebook.presto.hive.functions.scalar.ScalarFunctionInvoker;
import com.facebook.presto.spi.function.Signature;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;

public final class ScalarMethodHandles {
    private static final String CLASS_NAME = "HiveScalarFunction";
    private static final String METHOD_NAME = "callEvaluate";

    private ScalarMethodHandles() {
    }

    public static MethodHandle generateUnbound(Signature signature, TypeManager typeManager) {
        Class returnType = Primitives.wrap((Class)typeManager.getType(signature.getReturnType()).getJavaType());
        List argumentTypes = signature.getArgumentTypes();
        List argumentJavaTypes = (List)argumentTypes.stream().map(t -> typeManager.getType(t).getJavaType()).map(Primitives::wrap).collect(ImmutableList.toImmutableList());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(CLASS_NAME), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter[] declareParameters = new Parameter[argumentTypes.size() + 1];
        declareParameters[0] = Parameter.arg((String)"invoker", ScalarFunctionInvoker.class);
        for (int i = 0; i < argumentTypes.size(); ++i) {
            declareParameters[i + 1] = Parameter.arg((String)("input_" + i), (Class)((Class)argumentJavaTypes.get(i)));
        }
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), METHOD_NAME, ParameterizedType.type((Class)returnType), declareParameters);
        BytecodeExpression[] evaluateInputs = new BytecodeExpression[argumentTypes.size()];
        for (int i = 0; i < argumentTypes.size(); ++i) {
            evaluateInputs[i] = declareParameters[i + 1];
        }
        method.getBody().append((BytecodeNode)declareParameters[0].invoke("evaluate", Object.class, new BytecodeExpression[]{BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (BytecodeExpression[])evaluateInputs)}).cast(returnType).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, Collections.emptyMap(), ScalarMethodHandles.class.getClassLoader());
        Class[] lookupClasses = new Class[argumentTypes.size() + 1];
        lookupClasses[0] = ScalarFunctionInvoker.class;
        for (int i = 0; i < argumentTypes.size(); ++i) {
            lookupClasses[i + 1] = Primitives.wrap((Class)typeManager.getType((TypeSignature)argumentTypes.get(i)).getJavaType());
        }
        return MethodHandleUtil.methodHandle(generatedClass, (String)METHOD_NAME, (Class[])lookupClasses);
    }
}

