/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorFunctions;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorStateDescription;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunctionDescription;
import com.facebook.presto.hive.functions.gen.AccumulatorCompiler;
import com.facebook.presto.hive.functions.gen.AggregationUtils;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveAggregationFunctionImplementation
implements JavaAggregationFunctionImplementation {
    private final HiveAggregationFunctionDescription aggregationFunctionDescription;
    private final AggregationMetadata aggregationMetadata;
    private final Class<? extends Accumulator> accumulatorClass;
    private final Class<? extends GroupedAccumulator> groupedAccumulatorClass;

    public HiveAggregationFunctionImplementation(HiveAggregationFunctionDescription aggregationFunctionDescription, HiveAccumulatorFunctions accumulatorFunctions, HiveAccumulatorStateDescription accumulatorStateDescription) {
        this.aggregationFunctionDescription = Objects.requireNonNull(aggregationFunctionDescription);
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        this.aggregationMetadata = new AggregationMetadata(AggregationUtils.generateAggregationName(aggregationFunctionDescription.getName(), aggregationFunctionDescription.getFinalType().getTypeSignature(), aggregationFunctionDescription.getParameterTypes().stream().map(Type::getTypeSignature).collect(Collectors.toList())), AggregationUtils.createInputParameterMetadata(aggregationFunctionDescription.getParameterTypes()), accumulatorFunctions.getInputFunction(), accumulatorFunctions.getCombineFunction(), accumulatorFunctions.getOutputFunction(), (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(accumulatorStateDescription.getAccumulatorStateInterface(), accumulatorStateDescription.getAccumulatorStateSerializer(), accumulatorStateDescription.getAccumulatorStateFactory())), aggregationFunctionDescription.getFinalType());
        this.accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, this.aggregationMetadata, classLoader);
        this.groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, this.aggregationMetadata, classLoader);
    }

    public boolean isDecomposable() {
        return this.aggregationFunctionDescription.isDecomposable();
    }

    public List<Type> getParameterTypes() {
        return this.aggregationFunctionDescription.getParameterTypes();
    }

    public Type getIntermediateType() {
        List<Type> intermediateType = this.aggregationFunctionDescription.getIntermediateTypes();
        if (intermediateType.size() == 1) {
            return (Type)Iterables.getOnlyElement(intermediateType);
        }
        return RowType.withDefaultFieldNames(intermediateType);
    }

    public Type getFinalType() {
        return this.aggregationFunctionDescription.getFinalType();
    }

    public boolean isOrderSensitive() {
        return this.aggregationFunctionDescription.isOrderSensitive();
    }

    public AggregationMetadata getAggregationMetadata() {
        return this.aggregationMetadata;
    }

    public Class<? extends Accumulator> getAccumulatorClass() {
        return this.accumulatorClass;
    }

    public Class<? extends GroupedAccumulator> getGroupedAccumulatorClass() {
        return this.groupedAccumulatorClass;
    }
}

