/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public enum HiveFunctionErrorCode implements ErrorCodeSupplier
{
    HIVE_FUNCTION_UNSUPPORTED_HIVE_TYPE(0, ErrorType.EXTERNAL),
    HIVE_FUNCTION_UNSUPPORTED_PRESTO_TYPE(1, ErrorType.EXTERNAL),
    HIVE_FUNCTION_UNSUPPORTED_FUNCTION_TYPE(2, ErrorType.EXTERNAL),
    HIVE_FUNCTION_INITIALIZATION_ERROR(3, ErrorType.EXTERNAL),
    HIVE_FUNCTION_EXECUTION_ERROR(4, ErrorType.EXTERNAL);

    private static final int ERROR_CODE_MASK = 0x1100000;
    private final ErrorCode errorCode;

    private HiveFunctionErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code + 0x1100000, this.name(), type);
    }

    public ErrorCode toErrorCode() {
        return this.errorCode;
    }

    public static PrestoException unsupportedType(Type type) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_UNSUPPORTED_PRESTO_TYPE, "Unsupported Presto type " + type);
    }

    public static PrestoException unsupportedType(TypeSignature type) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_UNSUPPORTED_PRESTO_TYPE, "Unsupported Presto type " + type);
    }

    public static PrestoException unsupportedType(ObjectInspector inspector) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_UNSUPPORTED_HIVE_TYPE, "Unsupported Hive type " + inspector);
    }

    public static PrestoException unsupportedFunctionType(Class<?> cls) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_UNSUPPORTED_FUNCTION_TYPE, String.format("Unsupported function type %s / %s", cls.getName(), cls.getSuperclass().getName()));
    }

    public static PrestoException unsupportedFunctionType(Class<?> cls, Throwable t) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_UNSUPPORTED_FUNCTION_TYPE, String.format("Unsupported function type %s / %s", cls.getName(), cls.getSuperclass().getName()), t);
    }

    public static PrestoException functionNotFound(String name) {
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function %s not registered", name));
    }

    public static PrestoException initializationError(Throwable t) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_INITIALIZATION_ERROR, t);
    }

    public static PrestoException executionError(Throwable t) {
        return new PrestoException((ErrorCodeSupplier)HIVE_FUNCTION_EXECUTION_ERROR, t);
    }
}

