/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.event.client.NullEventClient;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.TableFunctionRegistry;
import com.facebook.presto.server.FunctionPluginManager;
import com.facebook.presto.server.FunctionResource;
import com.facebook.presto.server.InternalCommunicationModule;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.transaction.NoOpTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionServerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(FunctionResource.class);
        binder.bind(FunctionAndTypeManager.class).in(Scopes.SINGLETON);
        binder.bind(TableFunctionRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TransactionManager.class).to(NoOpTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(HandleResolver.class).in(Scopes.SINGLETON);
        this.install((Module)new InternalCommunicationModule());
        binder.bind(EventClient.class).to(NullEventClient.class);
        binder.bind(ObjectMapper.class).toProvider(JsonObjectMapperProvider.class);
        binder.bind((TypeLiteral)new TypeLiteral<JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>>>(){}).toInstance((Object)new JsonCodecFactory().mapJsonCodec(String.class, JsonCodec.listJsonCodec(JsonBasedUdfFunctionMetadata.class)));
        binder.bind(FunctionPluginManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PluginManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FunctionsConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
    }

    @Provides
    public BlockEncodingSerde provideBlockEncodingSerde() {
        return new BlockEncodingManager();
    }

    @Provides
    public Set<Type> provideTypes() {
        return ImmutableSet.of();
    }

    @Provides
    public NodeInfo provideNodeInfo() {
        return new NodeInfo("function_server");
    }
}

