/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.HttpServerModule;
import com.facebook.airlift.jaxrs.JaxrsModule;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.FunctionPluginManager;
import com.facebook.presto.server.FunctionServerModule;
import com.facebook.presto.server.PrestoSystemRequirements;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;

public class FunctionServer
implements Runnable {
    private static final Logger log = Logger.get(FunctionServer.class);

    public static void main(String[] args) {
        new FunctionServer().run();
    }

    @Override
    public void run() {
        PrestoSystemRequirements.verifyJvmRequirements();
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        Logger log = Logger.get(FunctionServer.class);
        ImmutableList modules = ImmutableList.of((Object)((Object)new FunctionServerModule()), (Object)new HttpServerModule(), (Object)new JaxrsModule());
        try {
            Bootstrap app = new Bootstrap((Iterable)modules);
            Injector injector = app.initialize();
            ((FunctionPluginManager)injector.getInstance(FunctionPluginManager.class)).loadPlugins();
            HttpServerInfo serverInfo = (HttpServerInfo)injector.getInstance(HttpServerInfo.class);
            log.info("======== REMOTE FUNCTION SERVER STARTED at: " + serverInfo.getHttpUri() + " =========");
            Thread.currentThread().join();
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }
}

