/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.json;

import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public class JsonBasedUdfFunctionMetadata {
    private final String docString;
    private final String outputType;
    private final List<String> paramTypes;
    private final String schema;
    private final RoutineCharacteristics routineCharacteristics;

    @JsonCreator
    public JsonBasedUdfFunctionMetadata(@JsonProperty(value="docString") String docString, @JsonProperty(value="outputType") String outputType, @JsonProperty(value="paramTypes") List<String> paramTypes, @JsonProperty(value="schema") String schema, @JsonProperty(value="routineCharacteristics") RoutineCharacteristics routineCharacteristics) {
        this.docString = Objects.requireNonNull(docString, "docString is null");
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        this.paramTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(paramTypes, "paramTypes is null"));
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.routineCharacteristics = Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null");
    }

    public String getDocString() {
        return this.docString;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public List<String> getParamNames() {
        return (List)IntStream.range(0, this.paramTypes.size()).boxed().map(idx -> "input" + idx).collect(ImmutableList.toImmutableList());
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public String getSchema() {
        return this.schema;
    }

    public RoutineCharacteristics getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }
}

