/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.presto.functionNamespace.execution.SimpleAddressSqlFunctionExecutorsModule;
import com.facebook.presto.functionNamespace.mysql.MySqlConnectionModule;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.mysql.MySqlFunctionNamespaceManagerModule;
import com.facebook.presto.spi.function.FunctionHandleResolver;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;

public class MySqlFunctionNamespaceManagerFactory
implements FunctionNamespaceManagerFactory {
    public static final String NAME = "mysql";
    private static final SqlFunctionHandle.Resolver HANDLE_RESOLVER = new SqlFunctionHandle.Resolver();

    public String getName() {
        return NAME;
    }

    public FunctionHandleResolver getHandleResolver() {
        return HANDLE_RESOLVER;
    }

    public FunctionNamespaceManager<?> create(String catalogName, Map<String, String> config) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{new MySqlFunctionNamespaceManagerModule(catalogName), new MySqlConnectionModule(), new SimpleAddressSqlFunctionExecutorsModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (FunctionNamespaceManager)injector.getInstance(MySqlFunctionNamespaceManager.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

