/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class ExampleColumn {
    private final String name;
    private final Type type;

    @JsonCreator
    public ExampleColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleColumn other = (ExampleColumn)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type);
    }

    public String toString() {
        return this.name + ":" + this.type;
    }
}

