/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.example.ExampleClient;
import com.facebook.presto.example.ExampleConnectorId;
import com.facebook.presto.example.ExamplePartition;
import com.facebook.presto.example.ExampleSplit;
import com.facebook.presto.example.ExampleTable;
import com.facebook.presto.example.ExampleTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleConnectorId connectorId, ExampleClient exampleClient) {
        this.connectorId = ((ExampleConnectorId)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null")).toString();
        this.exampleClient = (ExampleClient)Preconditions.checkNotNull((Object)exampleClient, (Object)"client is null");
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle tableHandle, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        Preconditions.checkArgument((boolean)(tableHandle instanceof ExampleTableHandle), (Object)"tableHandle is not an instance of ExampleTableHandle");
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        ImmutableList partitions = ImmutableList.of((Object)new ExamplePartition(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle tableHandle, List<ConnectorPartition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        Preconditions.checkArgument((partitions.size() == 1 ? 1 : 0) != 0, (String)"Expected one partition but got %s", (Object[])new Object[]{partitions.size()});
        ConnectorPartition partition = partitions.get(0);
        Preconditions.checkArgument((boolean)(partition instanceof ExamplePartition), (Object)"partition is not an instance of ExamplePartition");
        ExamplePartition examplePartition = (ExamplePartition)partition;
        ExampleTableHandle exampleTableHandle = (ExampleTableHandle)tableHandle;
        ExampleTable table = this.exampleClient.getTable(exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName());
        Preconditions.checkState((table != null ? 1 : 0) != 0, (String)"Table %s.%s no longer exists", (Object[])new Object[]{exampleTableHandle.getSchemaName(), exampleTableHandle.getTableName()});
        ArrayList splits = Lists.newArrayList();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(this.connectorId, examplePartition.getSchemaName(), examplePartition.getTableName(), uri));
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(this.connectorId, (Iterable)splits);
    }
}

