/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.example;

import com.facebook.presto.spi.Partition;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class ExamplePartition
implements Partition {
    private final String schemaName;
    private final String tableName;

    public ExamplePartition(String schemaName, String tableName) {
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName, (Object)"schema name is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"table name is null");
    }

    public String getPartitionId() {
        return this.schemaName + ":" + this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TupleDomain getTupleDomain() {
        return TupleDomain.all();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).toString();
    }
}

